/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupstorage.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backupstorage.model.BackupStorageRequest;
import software.amazon.awssdk.services.backupstorage.model.SummaryChecksumAlgorithm;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutObjectRequest
extends BackupStorageRequest
implements ToCopyableBuilder<Builder, PutObjectRequest> {
    private static final SdkField<String> BACKUP_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupJobId").getter(PutObjectRequest.getter(PutObjectRequest::backupJobId)).setter(PutObjectRequest.setter(Builder::backupJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()}).build();
    private static final SdkField<String> OBJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectName").getter(PutObjectRequest.getter(PutObjectRequest::objectName)).setter(PutObjectRequest.setter(Builder::objectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("objectName").build()}).build();
    private static final SdkField<String> METADATA_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetadataString").getter(PutObjectRequest.getter(PutObjectRequest::metadataString)).setter(PutObjectRequest.setter(Builder::metadataString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("metadata-string").build()}).build();
    private static final SdkField<Long> INLINE_CHUNK_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("InlineChunkLength").getter(PutObjectRequest.getter(PutObjectRequest::inlineChunkLength)).setter(PutObjectRequest.setter(Builder::inlineChunkLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("length").build()}).build();
    private static final SdkField<String> INLINE_CHUNK_CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InlineChunkChecksum").getter(PutObjectRequest.getter(PutObjectRequest::inlineChunkChecksum)).setter(PutObjectRequest.setter(Builder::inlineChunkChecksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("checksum").build()}).build();
    private static final SdkField<String> INLINE_CHUNK_CHECKSUM_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InlineChunkChecksumAlgorithm").getter(PutObjectRequest.getter(PutObjectRequest::inlineChunkChecksumAlgorithm)).setter(PutObjectRequest.setter(Builder::inlineChunkChecksumAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("checksum-algorithm").build()}).build();
    private static final SdkField<String> OBJECT_CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectChecksum").getter(PutObjectRequest.getter(PutObjectRequest::objectChecksum)).setter(PutObjectRequest.setter(Builder::objectChecksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("object-checksum").build()}).build();
    private static final SdkField<String> OBJECT_CHECKSUM_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectChecksumAlgorithm").getter(PutObjectRequest.getter(PutObjectRequest::objectChecksumAlgorithmAsString)).setter(PutObjectRequest.setter(Builder::objectChecksumAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("object-checksum-algorithm").build()}).build();
    private static final SdkField<Boolean> THROW_ON_DUPLICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ThrowOnDuplicate").getter(PutObjectRequest.getter(PutObjectRequest::throwOnDuplicate)).setter(PutObjectRequest.setter(Builder::throwOnDuplicate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("throwOnDuplicate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_JOB_ID_FIELD, OBJECT_NAME_FIELD, METADATA_STRING_FIELD, INLINE_CHUNK_LENGTH_FIELD, INLINE_CHUNK_CHECKSUM_FIELD, INLINE_CHUNK_CHECKSUM_ALGORITHM_FIELD, OBJECT_CHECKSUM_FIELD, OBJECT_CHECKSUM_ALGORITHM_FIELD, THROW_ON_DUPLICATE_FIELD));
    private final String backupJobId;
    private final String objectName;
    private final String metadataString;
    private final Long inlineChunkLength;
    private final String inlineChunkChecksum;
    private final String inlineChunkChecksumAlgorithm;
    private final String objectChecksum;
    private final String objectChecksumAlgorithm;
    private final Boolean throwOnDuplicate;

    private PutObjectRequest(BuilderImpl builder) {
        super(builder);
        this.backupJobId = builder.backupJobId;
        this.objectName = builder.objectName;
        this.metadataString = builder.metadataString;
        this.inlineChunkLength = builder.inlineChunkLength;
        this.inlineChunkChecksum = builder.inlineChunkChecksum;
        this.inlineChunkChecksumAlgorithm = builder.inlineChunkChecksumAlgorithm;
        this.objectChecksum = builder.objectChecksum;
        this.objectChecksumAlgorithm = builder.objectChecksumAlgorithm;
        this.throwOnDuplicate = builder.throwOnDuplicate;
    }

    public final String backupJobId() {
        return this.backupJobId;
    }

    public final String objectName() {
        return this.objectName;
    }

    public final String metadataString() {
        return this.metadataString;
    }

    public final Long inlineChunkLength() {
        return this.inlineChunkLength;
    }

    public final String inlineChunkChecksum() {
        return this.inlineChunkChecksum;
    }

    public final String inlineChunkChecksumAlgorithm() {
        return this.inlineChunkChecksumAlgorithm;
    }

    public final String objectChecksum() {
        return this.objectChecksum;
    }

    public final SummaryChecksumAlgorithm objectChecksumAlgorithm() {
        return SummaryChecksumAlgorithm.fromValue(this.objectChecksumAlgorithm);
    }

    public final String objectChecksumAlgorithmAsString() {
        return this.objectChecksumAlgorithm;
    }

    public final Boolean throwOnDuplicate() {
        return this.throwOnDuplicate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inlineChunkLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.inlineChunkChecksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.inlineChunkChecksumAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectChecksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectChecksumAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.throwOnDuplicate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutObjectRequest)) {
            return false;
        }
        PutObjectRequest other = (PutObjectRequest)((Object)obj);
        return Objects.equals(this.backupJobId(), other.backupJobId()) && Objects.equals(this.objectName(), other.objectName()) && Objects.equals(this.metadataString(), other.metadataString()) && Objects.equals(this.inlineChunkLength(), other.inlineChunkLength()) && Objects.equals(this.inlineChunkChecksum(), other.inlineChunkChecksum()) && Objects.equals(this.inlineChunkChecksumAlgorithm(), other.inlineChunkChecksumAlgorithm()) && Objects.equals(this.objectChecksum(), other.objectChecksum()) && Objects.equals(this.objectChecksumAlgorithmAsString(), other.objectChecksumAlgorithmAsString()) && Objects.equals(this.throwOnDuplicate(), other.throwOnDuplicate());
    }

    public final String toString() {
        return ToString.builder((String)"PutObjectRequest").add("BackupJobId", (Object)this.backupJobId()).add("ObjectName", (Object)this.objectName()).add("MetadataString", (Object)this.metadataString()).add("InlineChunkLength", (Object)this.inlineChunkLength()).add("InlineChunkChecksum", (Object)this.inlineChunkChecksum()).add("InlineChunkChecksumAlgorithm", (Object)this.inlineChunkChecksumAlgorithm()).add("ObjectChecksum", (Object)this.objectChecksum()).add("ObjectChecksumAlgorithm", (Object)this.objectChecksumAlgorithmAsString()).add("ThrowOnDuplicate", (Object)this.throwOnDuplicate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupJobId": {
                return Optional.ofNullable(clazz.cast(this.backupJobId()));
            }
            case "ObjectName": {
                return Optional.ofNullable(clazz.cast(this.objectName()));
            }
            case "MetadataString": {
                return Optional.ofNullable(clazz.cast(this.metadataString()));
            }
            case "InlineChunkLength": {
                return Optional.ofNullable(clazz.cast(this.inlineChunkLength()));
            }
            case "InlineChunkChecksum": {
                return Optional.ofNullable(clazz.cast(this.inlineChunkChecksum()));
            }
            case "InlineChunkChecksumAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.inlineChunkChecksumAlgorithm()));
            }
            case "ObjectChecksum": {
                return Optional.ofNullable(clazz.cast(this.objectChecksum()));
            }
            case "ObjectChecksumAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.objectChecksumAlgorithmAsString()));
            }
            case "ThrowOnDuplicate": {
                return Optional.ofNullable(clazz.cast(this.throwOnDuplicate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutObjectRequest, T> g) {
        return obj -> g.apply((PutObjectRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupStorageRequest.BuilderImpl
    implements Builder {
        private String backupJobId;
        private String objectName;
        private String metadataString;
        private Long inlineChunkLength;
        private String inlineChunkChecksum;
        private String inlineChunkChecksumAlgorithm;
        private String objectChecksum;
        private String objectChecksumAlgorithm;
        private Boolean throwOnDuplicate;

        private BuilderImpl() {
        }

        private BuilderImpl(PutObjectRequest model) {
            super(model);
            this.backupJobId(model.backupJobId);
            this.objectName(model.objectName);
            this.metadataString(model.metadataString);
            this.inlineChunkLength(model.inlineChunkLength);
            this.inlineChunkChecksum(model.inlineChunkChecksum);
            this.inlineChunkChecksumAlgorithm(model.inlineChunkChecksumAlgorithm);
            this.objectChecksum(model.objectChecksum);
            this.objectChecksumAlgorithm(model.objectChecksumAlgorithm);
            this.throwOnDuplicate(model.throwOnDuplicate);
        }

        public final String getBackupJobId() {
            return this.backupJobId;
        }

        public final void setBackupJobId(String backupJobId) {
            this.backupJobId = backupJobId;
        }

        @Override
        public final Builder backupJobId(String backupJobId) {
            this.backupJobId = backupJobId;
            return this;
        }

        public final String getObjectName() {
            return this.objectName;
        }

        public final void setObjectName(String objectName) {
            this.objectName = objectName;
        }

        @Override
        public final Builder objectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        public final String getMetadataString() {
            return this.metadataString;
        }

        public final void setMetadataString(String metadataString) {
            this.metadataString = metadataString;
        }

        @Override
        public final Builder metadataString(String metadataString) {
            this.metadataString = metadataString;
            return this;
        }

        public final Long getInlineChunkLength() {
            return this.inlineChunkLength;
        }

        public final void setInlineChunkLength(Long inlineChunkLength) {
            this.inlineChunkLength = inlineChunkLength;
        }

        @Override
        public final Builder inlineChunkLength(Long inlineChunkLength) {
            this.inlineChunkLength = inlineChunkLength;
            return this;
        }

        public final String getInlineChunkChecksum() {
            return this.inlineChunkChecksum;
        }

        public final void setInlineChunkChecksum(String inlineChunkChecksum) {
            this.inlineChunkChecksum = inlineChunkChecksum;
        }

        @Override
        public final Builder inlineChunkChecksum(String inlineChunkChecksum) {
            this.inlineChunkChecksum = inlineChunkChecksum;
            return this;
        }

        public final String getInlineChunkChecksumAlgorithm() {
            return this.inlineChunkChecksumAlgorithm;
        }

        public final void setInlineChunkChecksumAlgorithm(String inlineChunkChecksumAlgorithm) {
            this.inlineChunkChecksumAlgorithm = inlineChunkChecksumAlgorithm;
        }

        @Override
        public final Builder inlineChunkChecksumAlgorithm(String inlineChunkChecksumAlgorithm) {
            this.inlineChunkChecksumAlgorithm = inlineChunkChecksumAlgorithm;
            return this;
        }

        public final String getObjectChecksum() {
            return this.objectChecksum;
        }

        public final void setObjectChecksum(String objectChecksum) {
            this.objectChecksum = objectChecksum;
        }

        @Override
        public final Builder objectChecksum(String objectChecksum) {
            this.objectChecksum = objectChecksum;
            return this;
        }

        public final String getObjectChecksumAlgorithm() {
            return this.objectChecksumAlgorithm;
        }

        public final void setObjectChecksumAlgorithm(String objectChecksumAlgorithm) {
            this.objectChecksumAlgorithm = objectChecksumAlgorithm;
        }

        @Override
        public final Builder objectChecksumAlgorithm(String objectChecksumAlgorithm) {
            this.objectChecksumAlgorithm = objectChecksumAlgorithm;
            return this;
        }

        @Override
        public final Builder objectChecksumAlgorithm(SummaryChecksumAlgorithm objectChecksumAlgorithm) {
            this.objectChecksumAlgorithm(objectChecksumAlgorithm == null ? null : objectChecksumAlgorithm.toString());
            return this;
        }

        public final Boolean getThrowOnDuplicate() {
            return this.throwOnDuplicate;
        }

        public final void setThrowOnDuplicate(Boolean throwOnDuplicate) {
            this.throwOnDuplicate = throwOnDuplicate;
        }

        @Override
        public final Builder throwOnDuplicate(Boolean throwOnDuplicate) {
            this.throwOnDuplicate = throwOnDuplicate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutObjectRequest build() {
            return new PutObjectRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupStorageRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutObjectRequest> {
        public Builder backupJobId(String var1);

        public Builder objectName(String var1);

        public Builder metadataString(String var1);

        public Builder inlineChunkLength(Long var1);

        public Builder inlineChunkChecksum(String var1);

        public Builder inlineChunkChecksumAlgorithm(String var1);

        public Builder objectChecksum(String var1);

        public Builder objectChecksumAlgorithm(String var1);

        public Builder objectChecksumAlgorithm(SummaryChecksumAlgorithm var1);

        public Builder throwOnDuplicate(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

