/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupgateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backupgateway.BackupGatewayClient;
import software.amazon.awssdk.services.backupgateway.internal.UserAgentUtils;
import software.amazon.awssdk.services.backupgateway.model.Gateway;
import software.amazon.awssdk.services.backupgateway.model.ListGatewaysRequest;
import software.amazon.awssdk.services.backupgateway.model.ListGatewaysResponse;

public class ListGatewaysIterable
implements SdkIterable<ListGatewaysResponse> {
    private final BackupGatewayClient client;
    private final ListGatewaysRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGatewaysIterable(BackupGatewayClient client, ListGatewaysRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListGatewaysResponseFetcher();
    }

    public Iterator<ListGatewaysResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Gateway> gateways() {
        Function<ListGatewaysResponse, Iterator> getIterator = response -> {
            if (response != null && response.gateways() != null) {
                return response.gateways().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListGatewaysResponseFetcher
    implements SyncPageFetcher<ListGatewaysResponse> {
        private ListGatewaysResponseFetcher() {
        }

        public boolean hasNextPage(ListGatewaysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGatewaysResponse nextPage(ListGatewaysResponse previousPage) {
            if (previousPage == null) {
                return ListGatewaysIterable.this.client.listGateways(ListGatewaysIterable.this.firstRequest);
            }
            return ListGatewaysIterable.this.client.listGateways((ListGatewaysRequest)((Object)ListGatewaysIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

