/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupgateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backupgateway.model.BackupGatewayResponse;
import software.amazon.awssdk.services.backupgateway.model.Hypervisor;
import software.amazon.awssdk.services.backupgateway.model.HypervisorsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListHypervisorsResponse
extends BackupGatewayResponse
implements ToCopyableBuilder<Builder, ListHypervisorsResponse> {
    private static final SdkField<List<Hypervisor>> HYPERVISORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Hypervisors").getter(ListHypervisorsResponse.getter(ListHypervisorsResponse::hypervisors)).setter(ListHypervisorsResponse.setter(Builder::hypervisors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hypervisors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Hypervisor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListHypervisorsResponse.getter(ListHypervisorsResponse::nextToken)).setter(ListHypervisorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HYPERVISORS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Hypervisor> hypervisors;
    private final String nextToken;

    private ListHypervisorsResponse(BuilderImpl builder) {
        super(builder);
        this.hypervisors = builder.hypervisors;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasHypervisors() {
        return this.hypervisors != null && !(this.hypervisors instanceof SdkAutoConstructList);
    }

    public final List<Hypervisor> hypervisors() {
        return this.hypervisors;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHypervisors() ? this.hypervisors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHypervisorsResponse)) {
            return false;
        }
        ListHypervisorsResponse other = (ListHypervisorsResponse)((Object)obj);
        return this.hasHypervisors() == other.hasHypervisors() && Objects.equals(this.hypervisors(), other.hypervisors()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListHypervisorsResponse").add("Hypervisors", this.hasHypervisors() ? this.hypervisors() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Hypervisors": {
                return Optional.ofNullable(clazz.cast(this.hypervisors()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListHypervisorsResponse, T> g) {
        return obj -> g.apply((ListHypervisorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupGatewayResponse.BuilderImpl
    implements Builder {
        private List<Hypervisor> hypervisors = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHypervisorsResponse model) {
            super(model);
            this.hypervisors(model.hypervisors);
            this.nextToken(model.nextToken);
        }

        public final List<Hypervisor.Builder> getHypervisors() {
            List<Hypervisor.Builder> result = HypervisorsCopier.copyToBuilder(this.hypervisors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHypervisors(Collection<Hypervisor.BuilderImpl> hypervisors) {
            this.hypervisors = HypervisorsCopier.copyFromBuilder(hypervisors);
        }

        @Override
        public final Builder hypervisors(Collection<Hypervisor> hypervisors) {
            this.hypervisors = HypervisorsCopier.copy(hypervisors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hypervisors(Hypervisor ... hypervisors) {
            this.hypervisors(Arrays.asList(hypervisors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hypervisors(Consumer<Hypervisor.Builder> ... hypervisors) {
            this.hypervisors(Stream.of(hypervisors).map(c -> (Hypervisor)((Hypervisor.Builder)Hypervisor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListHypervisorsResponse build() {
            return new ListHypervisorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListHypervisorsResponse> {
        public Builder hypervisors(Collection<Hypervisor> var1);

        public Builder hypervisors(Hypervisor ... var1);

        public Builder hypervisors(Consumer<Hypervisor.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

