/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupgateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a bandwidth rate limit interval for a gateway. A bandwidth rate limit schedule consists of one or more
 * bandwidth rate limit intervals. A bandwidth rate limit interval defines a period of time on one or more days of the
 * week, during which bandwidth rate limits are specified for uploading, downloading, or both.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BandwidthRateLimitInterval implements SdkPojo, Serializable,
        ToCopyableBuilder<BandwidthRateLimitInterval.Builder, BandwidthRateLimitInterval> {
    private static final SdkField<Long> AVERAGE_UPLOAD_RATE_LIMIT_IN_BITS_PER_SEC_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("AverageUploadRateLimitInBitsPerSec")
            .getter(getter(BandwidthRateLimitInterval::averageUploadRateLimitInBitsPerSec))
            .setter(setter(Builder::averageUploadRateLimitInBitsPerSec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AverageUploadRateLimitInBitsPerSec")
                    .build()).build();

    private static final SdkField<List<Integer>> DAYS_OF_WEEK_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("DaysOfWeek")
            .getter(getter(BandwidthRateLimitInterval::daysOfWeek))
            .setter(setter(Builder::daysOfWeek))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DaysOfWeek").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> END_HOUR_OF_DAY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EndHourOfDay").getter(getter(BandwidthRateLimitInterval::endHourOfDay))
            .setter(setter(Builder::endHourOfDay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndHourOfDay").build()).build();

    private static final SdkField<Integer> END_MINUTE_OF_HOUR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EndMinuteOfHour").getter(getter(BandwidthRateLimitInterval::endMinuteOfHour))
            .setter(setter(Builder::endMinuteOfHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndMinuteOfHour").build()).build();

    private static final SdkField<Integer> START_HOUR_OF_DAY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StartHourOfDay").getter(getter(BandwidthRateLimitInterval::startHourOfDay))
            .setter(setter(Builder::startHourOfDay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartHourOfDay").build()).build();

    private static final SdkField<Integer> START_MINUTE_OF_HOUR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StartMinuteOfHour").getter(getter(BandwidthRateLimitInterval::startMinuteOfHour))
            .setter(setter(Builder::startMinuteOfHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartMinuteOfHour").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AVERAGE_UPLOAD_RATE_LIMIT_IN_BITS_PER_SEC_FIELD, DAYS_OF_WEEK_FIELD, END_HOUR_OF_DAY_FIELD, END_MINUTE_OF_HOUR_FIELD,
            START_HOUR_OF_DAY_FIELD, START_MINUTE_OF_HOUR_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long averageUploadRateLimitInBitsPerSec;

    private final List<Integer> daysOfWeek;

    private final Integer endHourOfDay;

    private final Integer endMinuteOfHour;

    private final Integer startHourOfDay;

    private final Integer startMinuteOfHour;

    private BandwidthRateLimitInterval(BuilderImpl builder) {
        this.averageUploadRateLimitInBitsPerSec = builder.averageUploadRateLimitInBitsPerSec;
        this.daysOfWeek = builder.daysOfWeek;
        this.endHourOfDay = builder.endHourOfDay;
        this.endMinuteOfHour = builder.endMinuteOfHour;
        this.startHourOfDay = builder.startHourOfDay;
        this.startMinuteOfHour = builder.startMinuteOfHour;
    }

    /**
     * <p>
     * The average upload rate limit component of the bandwidth rate limit interval, in bits per second. This field does
     * not appear in the response if the upload rate limit is not set.
     * </p>
     * <note>
     * <p>
     * For Backup Gateway, the minimum value is <code>(Value)</code>.
     * </p>
     * </note>
     * 
     * @return The average upload rate limit component of the bandwidth rate limit interval, in bits per second. This
     *         field does not appear in the response if the upload rate limit is not set.</p> <note>
     *         <p>
     *         For Backup Gateway, the minimum value is <code>(Value)</code>.
     *         </p>
     */
    public final Long averageUploadRateLimitInBitsPerSec() {
        return averageUploadRateLimitInBitsPerSec;
    }

    /**
     * For responses, this returns true if the service returned a value for the DaysOfWeek property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDaysOfWeek() {
        return daysOfWeek != null && !(daysOfWeek instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The days of the week component of the bandwidth rate limit interval, represented as ordinal numbers from 0 to 6,
     * where 0 represents Sunday and 6 represents Saturday.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDaysOfWeek} method.
     * </p>
     * 
     * @return The days of the week component of the bandwidth rate limit interval, represented as ordinal numbers from
     *         0 to 6, where 0 represents Sunday and 6 represents Saturday.
     */
    public final List<Integer> daysOfWeek() {
        return daysOfWeek;
    }

    /**
     * <p>
     * The hour of the day to end the bandwidth rate limit interval.
     * </p>
     * 
     * @return The hour of the day to end the bandwidth rate limit interval.
     */
    public final Integer endHourOfDay() {
        return endHourOfDay;
    }

    /**
     * <p>
     * The minute of the hour to end the bandwidth rate limit interval.
     * </p>
     * <important>
     * <p>
     * The bandwidth rate limit interval ends at the end of the minute. To end an interval at the end of an hour, use
     * the value <code>59</code>.
     * </p>
     * </important>
     * 
     * @return The minute of the hour to end the bandwidth rate limit interval.</p> <important>
     *         <p>
     *         The bandwidth rate limit interval ends at the end of the minute. To end an interval at the end of an
     *         hour, use the value <code>59</code>.
     *         </p>
     */
    public final Integer endMinuteOfHour() {
        return endMinuteOfHour;
    }

    /**
     * <p>
     * The hour of the day to start the bandwidth rate limit interval.
     * </p>
     * 
     * @return The hour of the day to start the bandwidth rate limit interval.
     */
    public final Integer startHourOfDay() {
        return startHourOfDay;
    }

    /**
     * <p>
     * The minute of the hour to start the bandwidth rate limit interval. The interval begins at the start of that
     * minute. To begin an interval exactly at the start of the hour, use the value <code>0</code>.
     * </p>
     * 
     * @return The minute of the hour to start the bandwidth rate limit interval. The interval begins at the start of
     *         that minute. To begin an interval exactly at the start of the hour, use the value <code>0</code>.
     */
    public final Integer startMinuteOfHour() {
        return startMinuteOfHour;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(averageUploadRateLimitInBitsPerSec());
        hashCode = 31 * hashCode + Objects.hashCode(hasDaysOfWeek() ? daysOfWeek() : null);
        hashCode = 31 * hashCode + Objects.hashCode(endHourOfDay());
        hashCode = 31 * hashCode + Objects.hashCode(endMinuteOfHour());
        hashCode = 31 * hashCode + Objects.hashCode(startHourOfDay());
        hashCode = 31 * hashCode + Objects.hashCode(startMinuteOfHour());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BandwidthRateLimitInterval)) {
            return false;
        }
        BandwidthRateLimitInterval other = (BandwidthRateLimitInterval) obj;
        return Objects.equals(averageUploadRateLimitInBitsPerSec(), other.averageUploadRateLimitInBitsPerSec())
                && hasDaysOfWeek() == other.hasDaysOfWeek() && Objects.equals(daysOfWeek(), other.daysOfWeek())
                && Objects.equals(endHourOfDay(), other.endHourOfDay())
                && Objects.equals(endMinuteOfHour(), other.endMinuteOfHour())
                && Objects.equals(startHourOfDay(), other.startHourOfDay())
                && Objects.equals(startMinuteOfHour(), other.startMinuteOfHour());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BandwidthRateLimitInterval")
                .add("AverageUploadRateLimitInBitsPerSec", averageUploadRateLimitInBitsPerSec())
                .add("DaysOfWeek", hasDaysOfWeek() ? daysOfWeek() : null).add("EndHourOfDay", endHourOfDay())
                .add("EndMinuteOfHour", endMinuteOfHour()).add("StartHourOfDay", startHourOfDay())
                .add("StartMinuteOfHour", startMinuteOfHour()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AverageUploadRateLimitInBitsPerSec":
            return Optional.ofNullable(clazz.cast(averageUploadRateLimitInBitsPerSec()));
        case "DaysOfWeek":
            return Optional.ofNullable(clazz.cast(daysOfWeek()));
        case "EndHourOfDay":
            return Optional.ofNullable(clazz.cast(endHourOfDay()));
        case "EndMinuteOfHour":
            return Optional.ofNullable(clazz.cast(endMinuteOfHour()));
        case "StartHourOfDay":
            return Optional.ofNullable(clazz.cast(startHourOfDay()));
        case "StartMinuteOfHour":
            return Optional.ofNullable(clazz.cast(startMinuteOfHour()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BandwidthRateLimitInterval, T> g) {
        return obj -> g.apply((BandwidthRateLimitInterval) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BandwidthRateLimitInterval> {
        /**
         * <p>
         * The average upload rate limit component of the bandwidth rate limit interval, in bits per second. This field
         * does not appear in the response if the upload rate limit is not set.
         * </p>
         * <note>
         * <p>
         * For Backup Gateway, the minimum value is <code>(Value)</code>.
         * </p>
         * </note>
         * 
         * @param averageUploadRateLimitInBitsPerSec
         *        The average upload rate limit component of the bandwidth rate limit interval, in bits per second. This
         *        field does not appear in the response if the upload rate limit is not set.</p> <note>
         *        <p>
         *        For Backup Gateway, the minimum value is <code>(Value)</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder averageUploadRateLimitInBitsPerSec(Long averageUploadRateLimitInBitsPerSec);

        /**
         * <p>
         * The days of the week component of the bandwidth rate limit interval, represented as ordinal numbers from 0 to
         * 6, where 0 represents Sunday and 6 represents Saturday.
         * </p>
         * 
         * @param daysOfWeek
         *        The days of the week component of the bandwidth rate limit interval, represented as ordinal numbers
         *        from 0 to 6, where 0 represents Sunday and 6 represents Saturday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder daysOfWeek(Collection<Integer> daysOfWeek);

        /**
         * <p>
         * The days of the week component of the bandwidth rate limit interval, represented as ordinal numbers from 0 to
         * 6, where 0 represents Sunday and 6 represents Saturday.
         * </p>
         * 
         * @param daysOfWeek
         *        The days of the week component of the bandwidth rate limit interval, represented as ordinal numbers
         *        from 0 to 6, where 0 represents Sunday and 6 represents Saturday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder daysOfWeek(Integer... daysOfWeek);

        /**
         * <p>
         * The hour of the day to end the bandwidth rate limit interval.
         * </p>
         * 
         * @param endHourOfDay
         *        The hour of the day to end the bandwidth rate limit interval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endHourOfDay(Integer endHourOfDay);

        /**
         * <p>
         * The minute of the hour to end the bandwidth rate limit interval.
         * </p>
         * <important>
         * <p>
         * The bandwidth rate limit interval ends at the end of the minute. To end an interval at the end of an hour,
         * use the value <code>59</code>.
         * </p>
         * </important>
         * 
         * @param endMinuteOfHour
         *        The minute of the hour to end the bandwidth rate limit interval.</p> <important>
         *        <p>
         *        The bandwidth rate limit interval ends at the end of the minute. To end an interval at the end of an
         *        hour, use the value <code>59</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endMinuteOfHour(Integer endMinuteOfHour);

        /**
         * <p>
         * The hour of the day to start the bandwidth rate limit interval.
         * </p>
         * 
         * @param startHourOfDay
         *        The hour of the day to start the bandwidth rate limit interval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startHourOfDay(Integer startHourOfDay);

        /**
         * <p>
         * The minute of the hour to start the bandwidth rate limit interval. The interval begins at the start of that
         * minute. To begin an interval exactly at the start of the hour, use the value <code>0</code>.
         * </p>
         * 
         * @param startMinuteOfHour
         *        The minute of the hour to start the bandwidth rate limit interval. The interval begins at the start of
         *        that minute. To begin an interval exactly at the start of the hour, use the value <code>0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startMinuteOfHour(Integer startMinuteOfHour);
    }

    static final class BuilderImpl implements Builder {
        private Long averageUploadRateLimitInBitsPerSec;

        private List<Integer> daysOfWeek = DefaultSdkAutoConstructList.getInstance();

        private Integer endHourOfDay;

        private Integer endMinuteOfHour;

        private Integer startHourOfDay;

        private Integer startMinuteOfHour;

        private BuilderImpl() {
        }

        private BuilderImpl(BandwidthRateLimitInterval model) {
            averageUploadRateLimitInBitsPerSec(model.averageUploadRateLimitInBitsPerSec);
            daysOfWeek(model.daysOfWeek);
            endHourOfDay(model.endHourOfDay);
            endMinuteOfHour(model.endMinuteOfHour);
            startHourOfDay(model.startHourOfDay);
            startMinuteOfHour(model.startMinuteOfHour);
        }

        public final Long getAverageUploadRateLimitInBitsPerSec() {
            return averageUploadRateLimitInBitsPerSec;
        }

        public final void setAverageUploadRateLimitInBitsPerSec(Long averageUploadRateLimitInBitsPerSec) {
            this.averageUploadRateLimitInBitsPerSec = averageUploadRateLimitInBitsPerSec;
        }

        @Override
        public final Builder averageUploadRateLimitInBitsPerSec(Long averageUploadRateLimitInBitsPerSec) {
            this.averageUploadRateLimitInBitsPerSec = averageUploadRateLimitInBitsPerSec;
            return this;
        }

        public final Collection<Integer> getDaysOfWeek() {
            if (daysOfWeek instanceof SdkAutoConstructList) {
                return null;
            }
            return daysOfWeek;
        }

        public final void setDaysOfWeek(Collection<Integer> daysOfWeek) {
            this.daysOfWeek = DaysOfWeekCopier.copy(daysOfWeek);
        }

        @Override
        public final Builder daysOfWeek(Collection<Integer> daysOfWeek) {
            this.daysOfWeek = DaysOfWeekCopier.copy(daysOfWeek);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder daysOfWeek(Integer... daysOfWeek) {
            daysOfWeek(Arrays.asList(daysOfWeek));
            return this;
        }

        public final Integer getEndHourOfDay() {
            return endHourOfDay;
        }

        public final void setEndHourOfDay(Integer endHourOfDay) {
            this.endHourOfDay = endHourOfDay;
        }

        @Override
        public final Builder endHourOfDay(Integer endHourOfDay) {
            this.endHourOfDay = endHourOfDay;
            return this;
        }

        public final Integer getEndMinuteOfHour() {
            return endMinuteOfHour;
        }

        public final void setEndMinuteOfHour(Integer endMinuteOfHour) {
            this.endMinuteOfHour = endMinuteOfHour;
        }

        @Override
        public final Builder endMinuteOfHour(Integer endMinuteOfHour) {
            this.endMinuteOfHour = endMinuteOfHour;
            return this;
        }

        public final Integer getStartHourOfDay() {
            return startHourOfDay;
        }

        public final void setStartHourOfDay(Integer startHourOfDay) {
            this.startHourOfDay = startHourOfDay;
        }

        @Override
        public final Builder startHourOfDay(Integer startHourOfDay) {
            this.startHourOfDay = startHourOfDay;
            return this;
        }

        public final Integer getStartMinuteOfHour() {
            return startMinuteOfHour;
        }

        public final void setStartMinuteOfHour(Integer startMinuteOfHour) {
            this.startMinuteOfHour = startMinuteOfHour;
        }

        @Override
        public final Builder startMinuteOfHour(Integer startMinuteOfHour) {
            this.startMinuteOfHour = startMinuteOfHour;
            return this;
        }

        @Override
        public BandwidthRateLimitInterval build() {
            return new BandwidthRateLimitInterval(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
