/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.CalculatedLifecycle;
import software.amazon.awssdk.services.backup.model.Lifecycle;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRecoveryPointLifecycleResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, UpdateRecoveryPointLifecycleResponse> {
    private static final SdkField<String> BACKUP_VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultArn").getter(UpdateRecoveryPointLifecycleResponse.getter(UpdateRecoveryPointLifecycleResponse::backupVaultArn)).setter(UpdateRecoveryPointLifecycleResponse.setter(Builder::backupVaultArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultArn").build()}).build();
    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecoveryPointArn").getter(UpdateRecoveryPointLifecycleResponse.getter(UpdateRecoveryPointLifecycleResponse::recoveryPointArn)).setter(UpdateRecoveryPointLifecycleResponse.setter(Builder::recoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()}).build();
    private static final SdkField<Lifecycle> LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Lifecycle").getter(UpdateRecoveryPointLifecycleResponse.getter(UpdateRecoveryPointLifecycleResponse::lifecycle)).setter(UpdateRecoveryPointLifecycleResponse.setter(Builder::lifecycle)).constructor(Lifecycle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()}).build();
    private static final SdkField<CalculatedLifecycle> CALCULATED_LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CalculatedLifecycle").getter(UpdateRecoveryPointLifecycleResponse.getter(UpdateRecoveryPointLifecycleResponse::calculatedLifecycle)).setter(UpdateRecoveryPointLifecycleResponse.setter(Builder::calculatedLifecycle)).constructor(CalculatedLifecycle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedLifecycle").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_ARN_FIELD, RECOVERY_POINT_ARN_FIELD, LIFECYCLE_FIELD, CALCULATED_LIFECYCLE_FIELD));
    private final String backupVaultArn;
    private final String recoveryPointArn;
    private final Lifecycle lifecycle;
    private final CalculatedLifecycle calculatedLifecycle;

    private UpdateRecoveryPointLifecycleResponse(BuilderImpl builder) {
        super(builder);
        this.backupVaultArn = builder.backupVaultArn;
        this.recoveryPointArn = builder.recoveryPointArn;
        this.lifecycle = builder.lifecycle;
        this.calculatedLifecycle = builder.calculatedLifecycle;
    }

    public final String backupVaultArn() {
        return this.backupVaultArn;
    }

    public final String recoveryPointArn() {
        return this.recoveryPointArn;
    }

    public final Lifecycle lifecycle() {
        return this.lifecycle;
    }

    public final CalculatedLifecycle calculatedLifecycle() {
        return this.calculatedLifecycle;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycle());
        hashCode = 31 * hashCode + Objects.hashCode(this.calculatedLifecycle());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRecoveryPointLifecycleResponse)) {
            return false;
        }
        UpdateRecoveryPointLifecycleResponse other = (UpdateRecoveryPointLifecycleResponse)((Object)obj);
        return Objects.equals(this.backupVaultArn(), other.backupVaultArn()) && Objects.equals(this.recoveryPointArn(), other.recoveryPointArn()) && Objects.equals(this.lifecycle(), other.lifecycle()) && Objects.equals(this.calculatedLifecycle(), other.calculatedLifecycle());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRecoveryPointLifecycleResponse").add("BackupVaultArn", (Object)this.backupVaultArn()).add("RecoveryPointArn", (Object)this.recoveryPointArn()).add("Lifecycle", (Object)this.lifecycle()).add("CalculatedLifecycle", (Object)this.calculatedLifecycle()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupVaultArn": {
                return Optional.ofNullable(clazz.cast(this.backupVaultArn()));
            }
            case "RecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.recoveryPointArn()));
            }
            case "Lifecycle": {
                return Optional.ofNullable(clazz.cast(this.lifecycle()));
            }
            case "CalculatedLifecycle": {
                return Optional.ofNullable(clazz.cast(this.calculatedLifecycle()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRecoveryPointLifecycleResponse, T> g) {
        return obj -> g.apply((UpdateRecoveryPointLifecycleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String backupVaultArn;
        private String recoveryPointArn;
        private Lifecycle lifecycle;
        private CalculatedLifecycle calculatedLifecycle;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRecoveryPointLifecycleResponse model) {
            super(model);
            this.backupVaultArn(model.backupVaultArn);
            this.recoveryPointArn(model.recoveryPointArn);
            this.lifecycle(model.lifecycle);
            this.calculatedLifecycle(model.calculatedLifecycle);
        }

        public final String getBackupVaultArn() {
            return this.backupVaultArn;
        }

        public final void setBackupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
        }

        @Override
        public final Builder backupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
            return this;
        }

        public final String getRecoveryPointArn() {
            return this.recoveryPointArn;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final Lifecycle.Builder getLifecycle() {
            return this.lifecycle != null ? this.lifecycle.toBuilder() : null;
        }

        public final void setLifecycle(Lifecycle.BuilderImpl lifecycle) {
            this.lifecycle = lifecycle != null ? lifecycle.build() : null;
        }

        @Override
        public final Builder lifecycle(Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public final CalculatedLifecycle.Builder getCalculatedLifecycle() {
            return this.calculatedLifecycle != null ? this.calculatedLifecycle.toBuilder() : null;
        }

        public final void setCalculatedLifecycle(CalculatedLifecycle.BuilderImpl calculatedLifecycle) {
            this.calculatedLifecycle = calculatedLifecycle != null ? calculatedLifecycle.build() : null;
        }

        @Override
        public final Builder calculatedLifecycle(CalculatedLifecycle calculatedLifecycle) {
            this.calculatedLifecycle = calculatedLifecycle;
            return this;
        }

        @Override
        public UpdateRecoveryPointLifecycleResponse build() {
            return new UpdateRecoveryPointLifecycleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRecoveryPointLifecycleResponse> {
        public Builder backupVaultArn(String var1);

        public Builder recoveryPointArn(String var1);

        public Builder lifecycle(Lifecycle var1);

        default public Builder lifecycle(Consumer<Lifecycle.Builder> lifecycle) {
            return this.lifecycle((Lifecycle)((Lifecycle.Builder)Lifecycle.builder().applyMutation(lifecycle)).build());
        }

        public Builder calculatedLifecycle(CalculatedLifecycle var1);

        default public Builder calculatedLifecycle(Consumer<CalculatedLifecycle.Builder> calculatedLifecycle) {
            return this.calculatedLifecycle((CalculatedLifecycle)((CalculatedLifecycle.Builder)CalculatedLifecycle.builder().applyMutation(calculatedLifecycle)).build());
        }
    }
}

