/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.services.backup.model.BackupSelection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBackupSelectionRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, CreateBackupSelectionRequest> {
    private static final SdkField<String> BACKUP_PLAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupPlanId").getter(CreateBackupSelectionRequest.getter(CreateBackupSelectionRequest::backupPlanId)).setter(CreateBackupSelectionRequest.setter(Builder::backupPlanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("backupPlanId").build()}).build();
    private static final SdkField<BackupSelection> BACKUP_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BackupSelection").getter(CreateBackupSelectionRequest.getter(CreateBackupSelectionRequest::backupSelection)).setter(CreateBackupSelectionRequest.setter(Builder::backupSelection)).constructor(BackupSelection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupSelection").build()}).build();
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatorRequestId").getter(CreateBackupSelectionRequest.getter(CreateBackupSelectionRequest::creatorRequestId)).setter(CreateBackupSelectionRequest.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_PLAN_ID_FIELD, BACKUP_SELECTION_FIELD, CREATOR_REQUEST_ID_FIELD));
    private final String backupPlanId;
    private final BackupSelection backupSelection;
    private final String creatorRequestId;

    private CreateBackupSelectionRequest(BuilderImpl builder) {
        super(builder);
        this.backupPlanId = builder.backupPlanId;
        this.backupSelection = builder.backupSelection;
        this.creatorRequestId = builder.creatorRequestId;
    }

    public final String backupPlanId() {
        return this.backupPlanId;
    }

    public final BackupSelection backupSelection() {
        return this.backupSelection;
    }

    public final String creatorRequestId() {
        return this.creatorRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupSelection());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBackupSelectionRequest)) {
            return false;
        }
        CreateBackupSelectionRequest other = (CreateBackupSelectionRequest)((Object)obj);
        return Objects.equals(this.backupPlanId(), other.backupPlanId()) && Objects.equals(this.backupSelection(), other.backupSelection()) && Objects.equals(this.creatorRequestId(), other.creatorRequestId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBackupSelectionRequest").add("BackupPlanId", (Object)this.backupPlanId()).add("BackupSelection", (Object)this.backupSelection()).add("CreatorRequestId", (Object)this.creatorRequestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupPlanId": {
                return Optional.ofNullable(clazz.cast(this.backupPlanId()));
            }
            case "BackupSelection": {
                return Optional.ofNullable(clazz.cast(this.backupSelection()));
            }
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBackupSelectionRequest, T> g) {
        return obj -> g.apply((CreateBackupSelectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private String backupPlanId;
        private BackupSelection backupSelection;
        private String creatorRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBackupSelectionRequest model) {
            super(model);
            this.backupPlanId(model.backupPlanId);
            this.backupSelection(model.backupSelection);
            this.creatorRequestId(model.creatorRequestId);
        }

        public final String getBackupPlanId() {
            return this.backupPlanId;
        }

        public final void setBackupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
        }

        @Override
        public final Builder backupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
            return this;
        }

        public final BackupSelection.Builder getBackupSelection() {
            return this.backupSelection != null ? this.backupSelection.toBuilder() : null;
        }

        public final void setBackupSelection(BackupSelection.BuilderImpl backupSelection) {
            this.backupSelection = backupSelection != null ? backupSelection.build() : null;
        }

        @Override
        public final Builder backupSelection(BackupSelection backupSelection) {
            this.backupSelection = backupSelection;
            return this;
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBackupSelectionRequest build() {
            return new CreateBackupSelectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBackupSelectionRequest> {
        public Builder backupPlanId(String var1);

        public Builder backupSelection(BackupSelection var1);

        default public Builder backupSelection(Consumer<BackupSelection.Builder> backupSelection) {
            return this.backupSelection((BackupSelection)((BackupSelection.Builder)BackupSelection.builder().applyMutation(backupSelection)).build());
        }

        public Builder creatorRequestId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

