/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartBackupJobResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, StartBackupJobResponse> {
    private static final SdkField<String> BACKUP_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupJobId").getter(StartBackupJobResponse.getter(StartBackupJobResponse::backupJobId)).setter(StartBackupJobResponse.setter(Builder::backupJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupJobId").build()}).build();
    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecoveryPointArn").getter(StartBackupJobResponse.getter(StartBackupJobResponse::recoveryPointArn)).setter(StartBackupJobResponse.setter(Builder::recoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(StartBackupJobResponse.getter(StartBackupJobResponse::creationDate)).setter(StartBackupJobResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<Boolean> IS_PARENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsParent").getter(StartBackupJobResponse.getter(StartBackupJobResponse::isParent)).setter(StartBackupJobResponse.setter(Builder::isParent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsParent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_JOB_ID_FIELD, RECOVERY_POINT_ARN_FIELD, CREATION_DATE_FIELD, IS_PARENT_FIELD));
    private final String backupJobId;
    private final String recoveryPointArn;
    private final Instant creationDate;
    private final Boolean isParent;

    private StartBackupJobResponse(BuilderImpl builder) {
        super(builder);
        this.backupJobId = builder.backupJobId;
        this.recoveryPointArn = builder.recoveryPointArn;
        this.creationDate = builder.creationDate;
        this.isParent = builder.isParent;
    }

    public final String backupJobId() {
        return this.backupJobId;
    }

    public final String recoveryPointArn() {
        return this.recoveryPointArn;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Boolean isParent() {
        return this.isParent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.isParent());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartBackupJobResponse)) {
            return false;
        }
        StartBackupJobResponse other = (StartBackupJobResponse)((Object)obj);
        return Objects.equals(this.backupJobId(), other.backupJobId()) && Objects.equals(this.recoveryPointArn(), other.recoveryPointArn()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.isParent(), other.isParent());
    }

    public final String toString() {
        return ToString.builder((String)"StartBackupJobResponse").add("BackupJobId", (Object)this.backupJobId()).add("RecoveryPointArn", (Object)this.recoveryPointArn()).add("CreationDate", (Object)this.creationDate()).add("IsParent", (Object)this.isParent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupJobId": {
                return Optional.ofNullable(clazz.cast(this.backupJobId()));
            }
            case "RecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.recoveryPointArn()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "IsParent": {
                return Optional.ofNullable(clazz.cast(this.isParent()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartBackupJobResponse, T> g) {
        return obj -> g.apply((StartBackupJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String backupJobId;
        private String recoveryPointArn;
        private Instant creationDate;
        private Boolean isParent;

        private BuilderImpl() {
        }

        private BuilderImpl(StartBackupJobResponse model) {
            super(model);
            this.backupJobId(model.backupJobId);
            this.recoveryPointArn(model.recoveryPointArn);
            this.creationDate(model.creationDate);
            this.isParent(model.isParent);
        }

        public final String getBackupJobId() {
            return this.backupJobId;
        }

        public final void setBackupJobId(String backupJobId) {
            this.backupJobId = backupJobId;
        }

        @Override
        public final Builder backupJobId(String backupJobId) {
            this.backupJobId = backupJobId;
            return this;
        }

        public final String getRecoveryPointArn() {
            return this.recoveryPointArn;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Boolean getIsParent() {
            return this.isParent;
        }

        public final void setIsParent(Boolean isParent) {
            this.isParent = isParent;
        }

        @Override
        public final Builder isParent(Boolean isParent) {
            this.isParent = isParent;
            return this;
        }

        @Override
        public StartBackupJobResponse build() {
            return new StartBackupJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartBackupJobResponse> {
        public Builder backupJobId(String var1);

        public Builder recoveryPointArn(String var1);

        public Builder creationDate(Instant var1);

        public Builder isParent(Boolean var1);
    }
}

