/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.FormatListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReportDeliveryChannel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReportDeliveryChannel> {
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketName").getter(ReportDeliveryChannel.getter(ReportDeliveryChannel::s3BucketName)).setter(ReportDeliveryChannel.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()}).build();
    private static final SdkField<String> S3_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3KeyPrefix").getter(ReportDeliveryChannel.getter(ReportDeliveryChannel::s3KeyPrefix)).setter(ReportDeliveryChannel.setter(Builder::s3KeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3KeyPrefix").build()}).build();
    private static final SdkField<List<String>> FORMATS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Formats").getter(ReportDeliveryChannel.getter(ReportDeliveryChannel::formats)).setter(ReportDeliveryChannel.setter(Builder::formats)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Formats").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_NAME_FIELD, S3_KEY_PREFIX_FIELD, FORMATS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String s3BucketName;
    private final String s3KeyPrefix;
    private final List<String> formats;

    private ReportDeliveryChannel(BuilderImpl builder) {
        this.s3BucketName = builder.s3BucketName;
        this.s3KeyPrefix = builder.s3KeyPrefix;
        this.formats = builder.formats;
    }

    public final String s3BucketName() {
        return this.s3BucketName;
    }

    public final String s3KeyPrefix() {
        return this.s3KeyPrefix;
    }

    public final boolean hasFormats() {
        return this.formats != null && !(this.formats instanceof SdkAutoConstructList);
    }

    public final List<String> formats() {
        return this.formats;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFormats() ? this.formats() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportDeliveryChannel)) {
            return false;
        }
        ReportDeliveryChannel other = (ReportDeliveryChannel)obj;
        return Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.s3KeyPrefix(), other.s3KeyPrefix()) && this.hasFormats() == other.hasFormats() && Objects.equals(this.formats(), other.formats());
    }

    public final String toString() {
        return ToString.builder((String)"ReportDeliveryChannel").add("S3BucketName", (Object)this.s3BucketName()).add("S3KeyPrefix", (Object)this.s3KeyPrefix()).add("Formats", this.hasFormats() ? this.formats() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "S3KeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.s3KeyPrefix()));
            }
            case "Formats": {
                return Optional.ofNullable(clazz.cast(this.formats()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReportDeliveryChannel, T> g) {
        return obj -> g.apply((ReportDeliveryChannel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3BucketName;
        private String s3KeyPrefix;
        private List<String> formats = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReportDeliveryChannel model) {
            this.s3BucketName(model.s3BucketName);
            this.s3KeyPrefix(model.s3KeyPrefix);
            this.formats(model.formats);
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getS3KeyPrefix() {
            return this.s3KeyPrefix;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public final Collection<String> getFormats() {
            if (this.formats instanceof SdkAutoConstructList) {
                return null;
            }
            return this.formats;
        }

        public final void setFormats(Collection<String> formats) {
            this.formats = FormatListCopier.copy(formats);
        }

        @Override
        public final Builder formats(Collection<String> formats) {
            this.formats = FormatListCopier.copy(formats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formats(String ... formats) {
            this.formats(Arrays.asList(formats));
            return this;
        }

        public ReportDeliveryChannel build() {
            return new ReportDeliveryChannel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReportDeliveryChannel> {
        public Builder s3BucketName(String var1);

        public Builder s3KeyPrefix(String var1);

        public Builder formats(Collection<String> var1);

        public Builder formats(String ... var1);
    }
}

