/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.b2bi.model.B2BiRequest;
import software.amazon.awssdk.services.b2bi.model.EdiType;
import software.amazon.awssdk.services.b2bi.model.FileFormat;
import software.amazon.awssdk.services.b2bi.model.Tag;
import software.amazon.awssdk.services.b2bi.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTransformerRequest
extends B2BiRequest
implements ToCopyableBuilder<Builder, CreateTransformerRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateTransformerRequest.getter(CreateTransformerRequest::name)).setter(CreateTransformerRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> FILE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileFormat").getter(CreateTransformerRequest.getter(CreateTransformerRequest::fileFormatAsString)).setter(CreateTransformerRequest.setter(Builder::fileFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileFormat").build()}).build();
    private static final SdkField<String> MAPPING_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mappingTemplate").getter(CreateTransformerRequest.getter(CreateTransformerRequest::mappingTemplate)).setter(CreateTransformerRequest.setter(Builder::mappingTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mappingTemplate").build()}).build();
    private static final SdkField<EdiType> EDI_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ediType").getter(CreateTransformerRequest.getter(CreateTransformerRequest::ediType)).setter(CreateTransformerRequest.setter(Builder::ediType)).constructor(EdiType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ediType").build()}).build();
    private static final SdkField<String> SAMPLE_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sampleDocument").getter(CreateTransformerRequest.getter(CreateTransformerRequest::sampleDocument)).setter(CreateTransformerRequest.setter(Builder::sampleDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleDocument").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateTransformerRequest.getter(CreateTransformerRequest::clientToken)).setter(CreateTransformerRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateTransformerRequest.getter(CreateTransformerRequest::tags)).setter(CreateTransformerRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FILE_FORMAT_FIELD, MAPPING_TEMPLATE_FIELD, EDI_TYPE_FIELD, SAMPLE_DOCUMENT_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private final String name;
    private final String fileFormat;
    private final String mappingTemplate;
    private final EdiType ediType;
    private final String sampleDocument;
    private final String clientToken;
    private final List<Tag> tags;

    private CreateTransformerRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.fileFormat = builder.fileFormat;
        this.mappingTemplate = builder.mappingTemplate;
        this.ediType = builder.ediType;
        this.sampleDocument = builder.sampleDocument;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final FileFormat fileFormat() {
        return FileFormat.fromValue(this.fileFormat);
    }

    public final String fileFormatAsString() {
        return this.fileFormat;
    }

    public final String mappingTemplate() {
        return this.mappingTemplate;
    }

    public final EdiType ediType() {
        return this.ediType;
    }

    public final String sampleDocument() {
        return this.sampleDocument;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mappingTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.ediType());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransformerRequest)) {
            return false;
        }
        CreateTransformerRequest other = (CreateTransformerRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.fileFormatAsString(), other.fileFormatAsString()) && Objects.equals(this.mappingTemplate(), other.mappingTemplate()) && Objects.equals(this.ediType(), other.ediType()) && Objects.equals(this.sampleDocument(), other.sampleDocument()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTransformerRequest").add("Name", (Object)this.name()).add("FileFormat", (Object)this.fileFormatAsString()).add("MappingTemplate", (Object)this.mappingTemplate()).add("EdiType", (Object)this.ediType()).add("SampleDocument", (Object)this.sampleDocument()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "fileFormat": {
                return Optional.ofNullable(clazz.cast(this.fileFormatAsString()));
            }
            case "mappingTemplate": {
                return Optional.ofNullable(clazz.cast(this.mappingTemplate()));
            }
            case "ediType": {
                return Optional.ofNullable(clazz.cast(this.ediType()));
            }
            case "sampleDocument": {
                return Optional.ofNullable(clazz.cast(this.sampleDocument()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTransformerRequest, T> g) {
        return obj -> g.apply((CreateTransformerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends B2BiRequest.BuilderImpl
    implements Builder {
        private String name;
        private String fileFormat;
        private String mappingTemplate;
        private EdiType ediType;
        private String sampleDocument;
        private String clientToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTransformerRequest model) {
            super(model);
            this.name(model.name);
            this.fileFormat(model.fileFormat);
            this.mappingTemplate(model.mappingTemplate);
            this.ediType(model.ediType);
            this.sampleDocument(model.sampleDocument);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getFileFormat() {
            return this.fileFormat;
        }

        public final void setFileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
        }

        @Override
        public final Builder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        @Override
        public final Builder fileFormat(FileFormat fileFormat) {
            this.fileFormat(fileFormat == null ? null : fileFormat.toString());
            return this;
        }

        public final String getMappingTemplate() {
            return this.mappingTemplate;
        }

        public final void setMappingTemplate(String mappingTemplate) {
            this.mappingTemplate = mappingTemplate;
        }

        @Override
        public final Builder mappingTemplate(String mappingTemplate) {
            this.mappingTemplate = mappingTemplate;
            return this;
        }

        public final EdiType.Builder getEdiType() {
            return this.ediType != null ? this.ediType.toBuilder() : null;
        }

        public final void setEdiType(EdiType.BuilderImpl ediType) {
            this.ediType = ediType != null ? ediType.build() : null;
        }

        @Override
        public final Builder ediType(EdiType ediType) {
            this.ediType = ediType;
            return this;
        }

        public final String getSampleDocument() {
            return this.sampleDocument;
        }

        public final void setSampleDocument(String sampleDocument) {
            this.sampleDocument = sampleDocument;
        }

        @Override
        public final Builder sampleDocument(String sampleDocument) {
            this.sampleDocument = sampleDocument;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTransformerRequest build() {
            return new CreateTransformerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends B2BiRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTransformerRequest> {
        public Builder name(String var1);

        public Builder fileFormat(String var1);

        public Builder fileFormat(FileFormat var1);

        public Builder mappingTemplate(String var1);

        public Builder ediType(EdiType var1);

        default public Builder ediType(Consumer<EdiType.Builder> ediType) {
            return this.ediType((EdiType)((EdiType.Builder)EdiType.builder().applyMutation(ediType)).build());
        }

        public Builder sampleDocument(String var1);

        public Builder clientToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

