/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscalingplans.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScalableDimension {
    AUTOSCALING_AUTO_SCALING_GROUP_DESIRED_CAPACITY("autoscaling:autoScalingGroup:DesiredCapacity"),
    ECS_SERVICE_DESIRED_COUNT("ecs:service:DesiredCount"),
    EC2_SPOT_FLEET_REQUEST_TARGET_CAPACITY("ec2:spot-fleet-request:TargetCapacity"),
    RDS_CLUSTER_READ_REPLICA_COUNT("rds:cluster:ReadReplicaCount"),
    DYNAMODB_TABLE_READ_CAPACITY_UNITS("dynamodb:table:ReadCapacityUnits"),
    DYNAMODB_TABLE_WRITE_CAPACITY_UNITS("dynamodb:table:WriteCapacityUnits"),
    DYNAMODB_INDEX_READ_CAPACITY_UNITS("dynamodb:index:ReadCapacityUnits"),
    DYNAMODB_INDEX_WRITE_CAPACITY_UNITS("dynamodb:index:WriteCapacityUnits"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScalableDimension> VALUE_MAP;
    private final String value;

    private ScalableDimension(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScalableDimension fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScalableDimension> knownValues() {
        EnumSet<ScalableDimension> knownValues = EnumSet.allOf(ScalableDimension.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScalableDimension.class, ScalableDimension::toString);
    }
}

