/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecutePolicyRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, ExecutePolicyRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingGroupName").getter(ExecutePolicyRequest.getter(ExecutePolicyRequest::autoScalingGroupName)).setter(ExecutePolicyRequest.setter(Builder::autoScalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build()}).build();
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyName").getter(ExecutePolicyRequest.getter(ExecutePolicyRequest::policyName)).setter(ExecutePolicyRequest.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()}).build();
    private static final SdkField<Boolean> HONOR_COOLDOWN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HonorCooldown").getter(ExecutePolicyRequest.getter(ExecutePolicyRequest::honorCooldown)).setter(ExecutePolicyRequest.setter(Builder::honorCooldown)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HonorCooldown").build()}).build();
    private static final SdkField<Double> METRIC_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MetricValue").getter(ExecutePolicyRequest.getter(ExecutePolicyRequest::metricValue)).setter(ExecutePolicyRequest.setter(Builder::metricValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricValue").build()}).build();
    private static final SdkField<Double> BREACH_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("BreachThreshold").getter(ExecutePolicyRequest.getter(ExecutePolicyRequest::breachThreshold)).setter(ExecutePolicyRequest.setter(Builder::breachThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BreachThreshold").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD, POLICY_NAME_FIELD, HONOR_COOLDOWN_FIELD, METRIC_VALUE_FIELD, BREACH_THRESHOLD_FIELD));
    private final String autoScalingGroupName;
    private final String policyName;
    private final Boolean honorCooldown;
    private final Double metricValue;
    private final Double breachThreshold;

    private ExecutePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.policyName = builder.policyName;
        this.honorCooldown = builder.honorCooldown;
        this.metricValue = builder.metricValue;
        this.breachThreshold = builder.breachThreshold;
    }

    public final String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public final String policyName() {
        return this.policyName;
    }

    public final Boolean honorCooldown() {
        return this.honorCooldown;
    }

    public final Double metricValue() {
        return this.metricValue;
    }

    public final Double breachThreshold() {
        return this.breachThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.honorCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.breachThreshold());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutePolicyRequest)) {
            return false;
        }
        ExecutePolicyRequest other = (ExecutePolicyRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.honorCooldown(), other.honorCooldown()) && Objects.equals(this.metricValue(), other.metricValue()) && Objects.equals(this.breachThreshold(), other.breachThreshold());
    }

    public final String toString() {
        return ToString.builder((String)"ExecutePolicyRequest").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("PolicyName", (Object)this.policyName()).add("HonorCooldown", (Object)this.honorCooldown()).add("MetricValue", (Object)this.metricValue()).add("BreachThreshold", (Object)this.breachThreshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "PolicyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "HonorCooldown": {
                return Optional.ofNullable(clazz.cast(this.honorCooldown()));
            }
            case "MetricValue": {
                return Optional.ofNullable(clazz.cast(this.metricValue()));
            }
            case "BreachThreshold": {
                return Optional.ofNullable(clazz.cast(this.breachThreshold()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecutePolicyRequest, T> g) {
        return obj -> g.apply((ExecutePolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private String policyName;
        private Boolean honorCooldown;
        private Double metricValue;
        private Double breachThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutePolicyRequest model) {
            super(model);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.policyName(model.policyName);
            this.honorCooldown(model.honorCooldown);
            this.metricValue(model.metricValue);
            this.breachThreshold(model.breachThreshold);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final Boolean getHonorCooldown() {
            return this.honorCooldown;
        }

        public final void setHonorCooldown(Boolean honorCooldown) {
            this.honorCooldown = honorCooldown;
        }

        @Override
        public final Builder honorCooldown(Boolean honorCooldown) {
            this.honorCooldown = honorCooldown;
            return this;
        }

        public final Double getMetricValue() {
            return this.metricValue;
        }

        public final void setMetricValue(Double metricValue) {
            this.metricValue = metricValue;
        }

        @Override
        public final Builder metricValue(Double metricValue) {
            this.metricValue = metricValue;
            return this;
        }

        public final Double getBreachThreshold() {
            return this.breachThreshold;
        }

        public final void setBreachThreshold(Double breachThreshold) {
            this.breachThreshold = breachThreshold;
        }

        @Override
        public final Builder breachThreshold(Double breachThreshold) {
            this.breachThreshold = breachThreshold;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecutePolicyRequest build() {
            return new ExecutePolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExecutePolicyRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder policyName(String var1);

        public Builder honorCooldown(Boolean var1);

        public Builder metricValue(Double var1);

        public Builder breachThreshold(Double var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

