/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.autoscaling.AutoScalingAsyncClient;
import software.amazon.awssdk.services.autoscaling.AutoScalingAsyncClientBuilder;
import software.amazon.awssdk.services.autoscaling.AutoScalingServiceClientConfiguration;
import software.amazon.awssdk.services.autoscaling.DefaultAutoScalingAsyncClient;
import software.amazon.awssdk.services.autoscaling.DefaultAutoScalingBaseClientBuilder;
import software.amazon.awssdk.services.autoscaling.endpoints.AutoScalingEndpointProvider;

@SdkInternalApi
final class DefaultAutoScalingAsyncClientBuilder
extends DefaultAutoScalingBaseClientBuilder<AutoScalingAsyncClientBuilder, AutoScalingAsyncClient>
implements AutoScalingAsyncClientBuilder {
    DefaultAutoScalingAsyncClientBuilder() {
    }

    @Override
    public DefaultAutoScalingAsyncClientBuilder endpointProvider(AutoScalingEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AutoScalingAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultAutoScalingAsyncClientBuilder.validateClientOptions(clientConfiguration);
        AutoScalingServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultAutoScalingAsyncClient client = new DefaultAutoScalingAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private AutoScalingServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return AutoScalingServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

