/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.autoscaling.AutoScalingAsyncClient;
import software.amazon.awssdk.services.autoscaling.model.DescribeTrafficSourcesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeTrafficSourcesResponse;

public class DescribeTrafficSourcesPublisher
implements SdkPublisher<DescribeTrafficSourcesResponse> {
    private final AutoScalingAsyncClient client;
    private final DescribeTrafficSourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeTrafficSourcesPublisher(AutoScalingAsyncClient client, DescribeTrafficSourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeTrafficSourcesPublisher(AutoScalingAsyncClient client, DescribeTrafficSourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeTrafficSourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeTrafficSourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeTrafficSourcesResponseFetcher
    implements AsyncPageFetcher<DescribeTrafficSourcesResponse> {
        private DescribeTrafficSourcesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTrafficSourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeTrafficSourcesResponse> nextPage(DescribeTrafficSourcesResponse previousPage) {
            if (previousPage == null) {
                return DescribeTrafficSourcesPublisher.this.client.describeTrafficSources(DescribeTrafficSourcesPublisher.this.firstRequest);
            }
            return DescribeTrafficSourcesPublisher.this.client.describeTrafficSources((DescribeTrafficSourcesRequest)((Object)DescribeTrafficSourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

