/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerResponse;
import software.amazon.awssdk.services.auditmanager.model.ValidationErrorsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidateAssessmentReportIntegrityResponse
extends AuditManagerResponse
implements ToCopyableBuilder<Builder, ValidateAssessmentReportIntegrityResponse> {
    private static final SdkField<Boolean> SIGNATURE_VALID_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("signatureValid").getter(ValidateAssessmentReportIntegrityResponse.getter(ValidateAssessmentReportIntegrityResponse::signatureValid)).setter(ValidateAssessmentReportIntegrityResponse.setter(Builder::signatureValid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signatureValid").build()}).build();
    private static final SdkField<String> SIGNATURE_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("signatureAlgorithm").getter(ValidateAssessmentReportIntegrityResponse.getter(ValidateAssessmentReportIntegrityResponse::signatureAlgorithm)).setter(ValidateAssessmentReportIntegrityResponse.setter(Builder::signatureAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signatureAlgorithm").build()}).build();
    private static final SdkField<String> SIGNATURE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("signatureDateTime").getter(ValidateAssessmentReportIntegrityResponse.getter(ValidateAssessmentReportIntegrityResponse::signatureDateTime)).setter(ValidateAssessmentReportIntegrityResponse.setter(Builder::signatureDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signatureDateTime").build()}).build();
    private static final SdkField<String> SIGNATURE_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("signatureKeyId").getter(ValidateAssessmentReportIntegrityResponse.getter(ValidateAssessmentReportIntegrityResponse::signatureKeyId)).setter(ValidateAssessmentReportIntegrityResponse.setter(Builder::signatureKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signatureKeyId").build()}).build();
    private static final SdkField<List<String>> VALIDATION_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("validationErrors").getter(ValidateAssessmentReportIntegrityResponse.getter(ValidateAssessmentReportIntegrityResponse::validationErrors)).setter(ValidateAssessmentReportIntegrityResponse.setter(Builder::validationErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNATURE_VALID_FIELD, SIGNATURE_ALGORITHM_FIELD, SIGNATURE_DATE_TIME_FIELD, SIGNATURE_KEY_ID_FIELD, VALIDATION_ERRORS_FIELD));
    private final Boolean signatureValid;
    private final String signatureAlgorithm;
    private final String signatureDateTime;
    private final String signatureKeyId;
    private final List<String> validationErrors;

    private ValidateAssessmentReportIntegrityResponse(BuilderImpl builder) {
        super(builder);
        this.signatureValid = builder.signatureValid;
        this.signatureAlgorithm = builder.signatureAlgorithm;
        this.signatureDateTime = builder.signatureDateTime;
        this.signatureKeyId = builder.signatureKeyId;
        this.validationErrors = builder.validationErrors;
    }

    public final Boolean signatureValid() {
        return this.signatureValid;
    }

    public final String signatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public final String signatureDateTime() {
        return this.signatureDateTime;
    }

    public final String signatureKeyId() {
        return this.signatureKeyId;
    }

    public final boolean hasValidationErrors() {
        return this.validationErrors != null && !(this.validationErrors instanceof SdkAutoConstructList);
    }

    public final List<String> validationErrors() {
        return this.validationErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.signatureValid());
        hashCode = 31 * hashCode + Objects.hashCode(this.signatureAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.signatureDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.signatureKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidationErrors() ? this.validationErrors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateAssessmentReportIntegrityResponse)) {
            return false;
        }
        ValidateAssessmentReportIntegrityResponse other = (ValidateAssessmentReportIntegrityResponse)((Object)obj);
        return Objects.equals(this.signatureValid(), other.signatureValid()) && Objects.equals(this.signatureAlgorithm(), other.signatureAlgorithm()) && Objects.equals(this.signatureDateTime(), other.signatureDateTime()) && Objects.equals(this.signatureKeyId(), other.signatureKeyId()) && this.hasValidationErrors() == other.hasValidationErrors() && Objects.equals(this.validationErrors(), other.validationErrors());
    }

    public final String toString() {
        return ToString.builder((String)"ValidateAssessmentReportIntegrityResponse").add("SignatureValid", (Object)this.signatureValid()).add("SignatureAlgorithm", (Object)this.signatureAlgorithm()).add("SignatureDateTime", (Object)this.signatureDateTime()).add("SignatureKeyId", (Object)this.signatureKeyId()).add("ValidationErrors", this.hasValidationErrors() ? this.validationErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "signatureValid": {
                return Optional.ofNullable(clazz.cast(this.signatureValid()));
            }
            case "signatureAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.signatureAlgorithm()));
            }
            case "signatureDateTime": {
                return Optional.ofNullable(clazz.cast(this.signatureDateTime()));
            }
            case "signatureKeyId": {
                return Optional.ofNullable(clazz.cast(this.signatureKeyId()));
            }
            case "validationErrors": {
                return Optional.ofNullable(clazz.cast(this.validationErrors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidateAssessmentReportIntegrityResponse, T> g) {
        return obj -> g.apply((ValidateAssessmentReportIntegrityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerResponse.BuilderImpl
    implements Builder {
        private Boolean signatureValid;
        private String signatureAlgorithm;
        private String signatureDateTime;
        private String signatureKeyId;
        private List<String> validationErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateAssessmentReportIntegrityResponse model) {
            super(model);
            this.signatureValid(model.signatureValid);
            this.signatureAlgorithm(model.signatureAlgorithm);
            this.signatureDateTime(model.signatureDateTime);
            this.signatureKeyId(model.signatureKeyId);
            this.validationErrors(model.validationErrors);
        }

        public final Boolean getSignatureValid() {
            return this.signatureValid;
        }

        public final void setSignatureValid(Boolean signatureValid) {
            this.signatureValid = signatureValid;
        }

        @Override
        public final Builder signatureValid(Boolean signatureValid) {
            this.signatureValid = signatureValid;
            return this;
        }

        public final String getSignatureAlgorithm() {
            return this.signatureAlgorithm;
        }

        public final void setSignatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
        }

        @Override
        public final Builder signatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
            return this;
        }

        public final String getSignatureDateTime() {
            return this.signatureDateTime;
        }

        public final void setSignatureDateTime(String signatureDateTime) {
            this.signatureDateTime = signatureDateTime;
        }

        @Override
        public final Builder signatureDateTime(String signatureDateTime) {
            this.signatureDateTime = signatureDateTime;
            return this;
        }

        public final String getSignatureKeyId() {
            return this.signatureKeyId;
        }

        public final void setSignatureKeyId(String signatureKeyId) {
            this.signatureKeyId = signatureKeyId;
        }

        @Override
        public final Builder signatureKeyId(String signatureKeyId) {
            this.signatureKeyId = signatureKeyId;
            return this;
        }

        public final Collection<String> getValidationErrors() {
            if (this.validationErrors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.validationErrors;
        }

        public final void setValidationErrors(Collection<String> validationErrors) {
            this.validationErrors = ValidationErrorsCopier.copy(validationErrors);
        }

        @Override
        public final Builder validationErrors(Collection<String> validationErrors) {
            this.validationErrors = ValidationErrorsCopier.copy(validationErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationErrors(String ... validationErrors) {
            this.validationErrors(Arrays.asList(validationErrors));
            return this;
        }

        @Override
        public ValidateAssessmentReportIntegrityResponse build() {
            return new ValidateAssessmentReportIntegrityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AuditManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ValidateAssessmentReportIntegrityResponse> {
        public Builder signatureValid(Boolean var1);

        public Builder signatureAlgorithm(String var1);

        public Builder signatureDateTime(String var1);

        public Builder signatureKeyId(String var1);

        public Builder validationErrors(Collection<String> var1);

        public Builder validationErrors(String ... var1);
    }
}

