/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartAssessmentFrameworkShareRequest
extends AuditManagerRequest
implements ToCopyableBuilder<Builder, StartAssessmentFrameworkShareRequest> {
    private static final SdkField<String> FRAMEWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("frameworkId").getter(StartAssessmentFrameworkShareRequest.getter(StartAssessmentFrameworkShareRequest::frameworkId)).setter(StartAssessmentFrameworkShareRequest.setter(Builder::frameworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("frameworkId").build()}).build();
    private static final SdkField<String> DESTINATION_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationAccount").getter(StartAssessmentFrameworkShareRequest.getter(StartAssessmentFrameworkShareRequest::destinationAccount)).setter(StartAssessmentFrameworkShareRequest.setter(Builder::destinationAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationAccount").build()}).build();
    private static final SdkField<String> DESTINATION_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationRegion").getter(StartAssessmentFrameworkShareRequest.getter(StartAssessmentFrameworkShareRequest::destinationRegion)).setter(StartAssessmentFrameworkShareRequest.setter(Builder::destinationRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationRegion").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("comment").getter(StartAssessmentFrameworkShareRequest.getter(StartAssessmentFrameworkShareRequest::comment)).setter(StartAssessmentFrameworkShareRequest.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAMEWORK_ID_FIELD, DESTINATION_ACCOUNT_FIELD, DESTINATION_REGION_FIELD, COMMENT_FIELD));
    private final String frameworkId;
    private final String destinationAccount;
    private final String destinationRegion;
    private final String comment;

    private StartAssessmentFrameworkShareRequest(BuilderImpl builder) {
        super(builder);
        this.frameworkId = builder.frameworkId;
        this.destinationAccount = builder.destinationAccount;
        this.destinationRegion = builder.destinationRegion;
        this.comment = builder.comment;
    }

    public final String frameworkId() {
        return this.frameworkId;
    }

    public final String destinationAccount() {
        return this.destinationAccount;
    }

    public final String destinationRegion() {
        return this.destinationRegion;
    }

    public final String comment() {
        return this.comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAssessmentFrameworkShareRequest)) {
            return false;
        }
        StartAssessmentFrameworkShareRequest other = (StartAssessmentFrameworkShareRequest)((Object)obj);
        return Objects.equals(this.frameworkId(), other.frameworkId()) && Objects.equals(this.destinationAccount(), other.destinationAccount()) && Objects.equals(this.destinationRegion(), other.destinationRegion()) && Objects.equals(this.comment(), other.comment());
    }

    public final String toString() {
        return ToString.builder((String)"StartAssessmentFrameworkShareRequest").add("FrameworkId", (Object)this.frameworkId()).add("DestinationAccount", (Object)this.destinationAccount()).add("DestinationRegion", (Object)this.destinationRegion()).add("Comment", (Object)this.comment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "frameworkId": {
                return Optional.ofNullable(clazz.cast(this.frameworkId()));
            }
            case "destinationAccount": {
                return Optional.ofNullable(clazz.cast(this.destinationAccount()));
            }
            case "destinationRegion": {
                return Optional.ofNullable(clazz.cast(this.destinationRegion()));
            }
            case "comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartAssessmentFrameworkShareRequest, T> g) {
        return obj -> g.apply((StartAssessmentFrameworkShareRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerRequest.BuilderImpl
    implements Builder {
        private String frameworkId;
        private String destinationAccount;
        private String destinationRegion;
        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAssessmentFrameworkShareRequest model) {
            super(model);
            this.frameworkId(model.frameworkId);
            this.destinationAccount(model.destinationAccount);
            this.destinationRegion(model.destinationRegion);
            this.comment(model.comment);
        }

        public final String getFrameworkId() {
            return this.frameworkId;
        }

        public final void setFrameworkId(String frameworkId) {
            this.frameworkId = frameworkId;
        }

        @Override
        public final Builder frameworkId(String frameworkId) {
            this.frameworkId = frameworkId;
            return this;
        }

        public final String getDestinationAccount() {
            return this.destinationAccount;
        }

        public final void setDestinationAccount(String destinationAccount) {
            this.destinationAccount = destinationAccount;
        }

        @Override
        public final Builder destinationAccount(String destinationAccount) {
            this.destinationAccount = destinationAccount;
            return this;
        }

        public final String getDestinationRegion() {
            return this.destinationRegion;
        }

        public final void setDestinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
        }

        @Override
        public final Builder destinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
            return this;
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAssessmentFrameworkShareRequest build() {
            return new StartAssessmentFrameworkShareRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AuditManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartAssessmentFrameworkShareRequest> {
        public Builder frameworkId(String var1);

        public Builder destinationAccount(String var1);

        public Builder destinationRegion(String var1);

        public Builder comment(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

