/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCapacityAssignmentConfigurationResponse extends AthenaResponse implements
        ToCopyableBuilder<GetCapacityAssignmentConfigurationResponse.Builder, GetCapacityAssignmentConfigurationResponse> {
    private static final SdkField<CapacityAssignmentConfiguration> CAPACITY_ASSIGNMENT_CONFIGURATION_FIELD = SdkField
            .<CapacityAssignmentConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("CapacityAssignmentConfiguration")
            .getter(getter(GetCapacityAssignmentConfigurationResponse::capacityAssignmentConfiguration))
            .setter(setter(Builder::capacityAssignmentConfiguration))
            .constructor(CapacityAssignmentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityAssignmentConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CAPACITY_ASSIGNMENT_CONFIGURATION_FIELD));

    private final CapacityAssignmentConfiguration capacityAssignmentConfiguration;

    private GetCapacityAssignmentConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.capacityAssignmentConfiguration = builder.capacityAssignmentConfiguration;
    }

    /**
     * <p>
     * The requested capacity assignment configuration for the specified capacity reservation.
     * </p>
     * 
     * @return The requested capacity assignment configuration for the specified capacity reservation.
     */
    public final CapacityAssignmentConfiguration capacityAssignmentConfiguration() {
        return capacityAssignmentConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(capacityAssignmentConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCapacityAssignmentConfigurationResponse)) {
            return false;
        }
        GetCapacityAssignmentConfigurationResponse other = (GetCapacityAssignmentConfigurationResponse) obj;
        return Objects.equals(capacityAssignmentConfiguration(), other.capacityAssignmentConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCapacityAssignmentConfigurationResponse")
                .add("CapacityAssignmentConfiguration", capacityAssignmentConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityAssignmentConfiguration":
            return Optional.ofNullable(clazz.cast(capacityAssignmentConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCapacityAssignmentConfigurationResponse, T> g) {
        return obj -> g.apply((GetCapacityAssignmentConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCapacityAssignmentConfigurationResponse> {
        /**
         * <p>
         * The requested capacity assignment configuration for the specified capacity reservation.
         * </p>
         * 
         * @param capacityAssignmentConfiguration
         *        The requested capacity assignment configuration for the specified capacity reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityAssignmentConfiguration(CapacityAssignmentConfiguration capacityAssignmentConfiguration);

        /**
         * <p>
         * The requested capacity assignment configuration for the specified capacity reservation.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacityAssignmentConfiguration.Builder}
         * avoiding the need to create one manually via {@link CapacityAssignmentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityAssignmentConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #capacityAssignmentConfiguration(CapacityAssignmentConfiguration)}.
         * 
         * @param capacityAssignmentConfiguration
         *        a consumer that will call methods on {@link CapacityAssignmentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityAssignmentConfiguration(CapacityAssignmentConfiguration)
         */
        default Builder capacityAssignmentConfiguration(
                Consumer<CapacityAssignmentConfiguration.Builder> capacityAssignmentConfiguration) {
            return capacityAssignmentConfiguration(CapacityAssignmentConfiguration.builder()
                    .applyMutation(capacityAssignmentConfiguration).build());
        }
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private CapacityAssignmentConfiguration capacityAssignmentConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCapacityAssignmentConfigurationResponse model) {
            super(model);
            capacityAssignmentConfiguration(model.capacityAssignmentConfiguration);
        }

        public final CapacityAssignmentConfiguration.Builder getCapacityAssignmentConfiguration() {
            return capacityAssignmentConfiguration != null ? capacityAssignmentConfiguration.toBuilder() : null;
        }

        public final void setCapacityAssignmentConfiguration(
                CapacityAssignmentConfiguration.BuilderImpl capacityAssignmentConfiguration) {
            this.capacityAssignmentConfiguration = capacityAssignmentConfiguration != null ? capacityAssignmentConfiguration
                    .build() : null;
        }

        @Override
        public final Builder capacityAssignmentConfiguration(CapacityAssignmentConfiguration capacityAssignmentConfiguration) {
            this.capacityAssignmentConfiguration = capacityAssignmentConfiguration;
            return this;
        }

        @Override
        public GetCapacityAssignmentConfigurationResponse build() {
            return new GetCapacityAssignmentConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
