/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.CustomerContentEncryptionConfiguration;
import software.amazon.awssdk.services.athena.model.EngineVersion;
import software.amazon.awssdk.services.athena.model.ResultConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkGroupConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkGroupConfiguration> {
    private static final SdkField<ResultConfiguration> RESULT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResultConfiguration").getter(WorkGroupConfiguration.getter(WorkGroupConfiguration::resultConfiguration)).setter(WorkGroupConfiguration.setter(Builder::resultConfiguration)).constructor(ResultConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultConfiguration").build()}).build();
    private static final SdkField<Boolean> ENFORCE_WORK_GROUP_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnforceWorkGroupConfiguration").getter(WorkGroupConfiguration.getter(WorkGroupConfiguration::enforceWorkGroupConfiguration)).setter(WorkGroupConfiguration.setter(Builder::enforceWorkGroupConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnforceWorkGroupConfiguration").build()}).build();
    private static final SdkField<Boolean> PUBLISH_CLOUD_WATCH_METRICS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PublishCloudWatchMetricsEnabled").getter(WorkGroupConfiguration.getter(WorkGroupConfiguration::publishCloudWatchMetricsEnabled)).setter(WorkGroupConfiguration.setter(Builder::publishCloudWatchMetricsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishCloudWatchMetricsEnabled").build()}).build();
    private static final SdkField<Long> BYTES_SCANNED_CUTOFF_PER_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BytesScannedCutoffPerQuery").getter(WorkGroupConfiguration.getter(WorkGroupConfiguration::bytesScannedCutoffPerQuery)).setter(WorkGroupConfiguration.setter(Builder::bytesScannedCutoffPerQuery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesScannedCutoffPerQuery").build()}).build();
    private static final SdkField<Boolean> REQUESTER_PAYS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RequesterPaysEnabled").getter(WorkGroupConfiguration.getter(WorkGroupConfiguration::requesterPaysEnabled)).setter(WorkGroupConfiguration.setter(Builder::requesterPaysEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterPaysEnabled").build()}).build();
    private static final SdkField<EngineVersion> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EngineVersion").getter(WorkGroupConfiguration.getter(WorkGroupConfiguration::engineVersion)).setter(WorkGroupConfiguration.setter(Builder::engineVersion)).constructor(EngineVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> ADDITIONAL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdditionalConfiguration").getter(WorkGroupConfiguration.getter(WorkGroupConfiguration::additionalConfiguration)).setter(WorkGroupConfiguration.setter(Builder::additionalConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalConfiguration").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRole").getter(WorkGroupConfiguration.getter(WorkGroupConfiguration::executionRole)).setter(WorkGroupConfiguration.setter(Builder::executionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRole").build()}).build();
    private static final SdkField<CustomerContentEncryptionConfiguration> CUSTOMER_CONTENT_ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomerContentEncryptionConfiguration").getter(WorkGroupConfiguration.getter(WorkGroupConfiguration::customerContentEncryptionConfiguration)).setter(WorkGroupConfiguration.setter(Builder::customerContentEncryptionConfiguration)).constructor(CustomerContentEncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerContentEncryptionConfiguration").build()}).build();
    private static final SdkField<Boolean> ENABLE_MINIMUM_ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableMinimumEncryptionConfiguration").getter(WorkGroupConfiguration.getter(WorkGroupConfiguration::enableMinimumEncryptionConfiguration)).setter(WorkGroupConfiguration.setter(Builder::enableMinimumEncryptionConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableMinimumEncryptionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_CONFIGURATION_FIELD, ENFORCE_WORK_GROUP_CONFIGURATION_FIELD, PUBLISH_CLOUD_WATCH_METRICS_ENABLED_FIELD, BYTES_SCANNED_CUTOFF_PER_QUERY_FIELD, REQUESTER_PAYS_ENABLED_FIELD, ENGINE_VERSION_FIELD, ADDITIONAL_CONFIGURATION_FIELD, EXECUTION_ROLE_FIELD, CUSTOMER_CONTENT_ENCRYPTION_CONFIGURATION_FIELD, ENABLE_MINIMUM_ENCRYPTION_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final ResultConfiguration resultConfiguration;
    private final Boolean enforceWorkGroupConfiguration;
    private final Boolean publishCloudWatchMetricsEnabled;
    private final Long bytesScannedCutoffPerQuery;
    private final Boolean requesterPaysEnabled;
    private final EngineVersion engineVersion;
    private final String additionalConfiguration;
    private final String executionRole;
    private final CustomerContentEncryptionConfiguration customerContentEncryptionConfiguration;
    private final Boolean enableMinimumEncryptionConfiguration;

    private WorkGroupConfiguration(BuilderImpl builder) {
        this.resultConfiguration = builder.resultConfiguration;
        this.enforceWorkGroupConfiguration = builder.enforceWorkGroupConfiguration;
        this.publishCloudWatchMetricsEnabled = builder.publishCloudWatchMetricsEnabled;
        this.bytesScannedCutoffPerQuery = builder.bytesScannedCutoffPerQuery;
        this.requesterPaysEnabled = builder.requesterPaysEnabled;
        this.engineVersion = builder.engineVersion;
        this.additionalConfiguration = builder.additionalConfiguration;
        this.executionRole = builder.executionRole;
        this.customerContentEncryptionConfiguration = builder.customerContentEncryptionConfiguration;
        this.enableMinimumEncryptionConfiguration = builder.enableMinimumEncryptionConfiguration;
    }

    public final ResultConfiguration resultConfiguration() {
        return this.resultConfiguration;
    }

    public final Boolean enforceWorkGroupConfiguration() {
        return this.enforceWorkGroupConfiguration;
    }

    public final Boolean publishCloudWatchMetricsEnabled() {
        return this.publishCloudWatchMetricsEnabled;
    }

    public final Long bytesScannedCutoffPerQuery() {
        return this.bytesScannedCutoffPerQuery;
    }

    public final Boolean requesterPaysEnabled() {
        return this.requesterPaysEnabled;
    }

    public final EngineVersion engineVersion() {
        return this.engineVersion;
    }

    public final String additionalConfiguration() {
        return this.additionalConfiguration;
    }

    public final String executionRole() {
        return this.executionRole;
    }

    public final CustomerContentEncryptionConfiguration customerContentEncryptionConfiguration() {
        return this.customerContentEncryptionConfiguration;
    }

    public final Boolean enableMinimumEncryptionConfiguration() {
        return this.enableMinimumEncryptionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resultConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.enforceWorkGroupConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.publishCloudWatchMetricsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.bytesScannedCutoffPerQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterPaysEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerContentEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableMinimumEncryptionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkGroupConfiguration)) {
            return false;
        }
        WorkGroupConfiguration other = (WorkGroupConfiguration)obj;
        return Objects.equals(this.resultConfiguration(), other.resultConfiguration()) && Objects.equals(this.enforceWorkGroupConfiguration(), other.enforceWorkGroupConfiguration()) && Objects.equals(this.publishCloudWatchMetricsEnabled(), other.publishCloudWatchMetricsEnabled()) && Objects.equals(this.bytesScannedCutoffPerQuery(), other.bytesScannedCutoffPerQuery()) && Objects.equals(this.requesterPaysEnabled(), other.requesterPaysEnabled()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.additionalConfiguration(), other.additionalConfiguration()) && Objects.equals(this.executionRole(), other.executionRole()) && Objects.equals(this.customerContentEncryptionConfiguration(), other.customerContentEncryptionConfiguration()) && Objects.equals(this.enableMinimumEncryptionConfiguration(), other.enableMinimumEncryptionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"WorkGroupConfiguration").add("ResultConfiguration", (Object)this.resultConfiguration()).add("EnforceWorkGroupConfiguration", (Object)this.enforceWorkGroupConfiguration()).add("PublishCloudWatchMetricsEnabled", (Object)this.publishCloudWatchMetricsEnabled()).add("BytesScannedCutoffPerQuery", (Object)this.bytesScannedCutoffPerQuery()).add("RequesterPaysEnabled", (Object)this.requesterPaysEnabled()).add("EngineVersion", (Object)this.engineVersion()).add("AdditionalConfiguration", (Object)this.additionalConfiguration()).add("ExecutionRole", (Object)this.executionRole()).add("CustomerContentEncryptionConfiguration", (Object)this.customerContentEncryptionConfiguration()).add("EnableMinimumEncryptionConfiguration", (Object)this.enableMinimumEncryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResultConfiguration": {
                return Optional.ofNullable(clazz.cast(this.resultConfiguration()));
            }
            case "EnforceWorkGroupConfiguration": {
                return Optional.ofNullable(clazz.cast(this.enforceWorkGroupConfiguration()));
            }
            case "PublishCloudWatchMetricsEnabled": {
                return Optional.ofNullable(clazz.cast(this.publishCloudWatchMetricsEnabled()));
            }
            case "BytesScannedCutoffPerQuery": {
                return Optional.ofNullable(clazz.cast(this.bytesScannedCutoffPerQuery()));
            }
            case "RequesterPaysEnabled": {
                return Optional.ofNullable(clazz.cast(this.requesterPaysEnabled()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "AdditionalConfiguration": {
                return Optional.ofNullable(clazz.cast(this.additionalConfiguration()));
            }
            case "ExecutionRole": {
                return Optional.ofNullable(clazz.cast(this.executionRole()));
            }
            case "CustomerContentEncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.customerContentEncryptionConfiguration()));
            }
            case "EnableMinimumEncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.enableMinimumEncryptionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkGroupConfiguration, T> g) {
        return obj -> g.apply((WorkGroupConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ResultConfiguration resultConfiguration;
        private Boolean enforceWorkGroupConfiguration;
        private Boolean publishCloudWatchMetricsEnabled;
        private Long bytesScannedCutoffPerQuery;
        private Boolean requesterPaysEnabled;
        private EngineVersion engineVersion;
        private String additionalConfiguration;
        private String executionRole;
        private CustomerContentEncryptionConfiguration customerContentEncryptionConfiguration;
        private Boolean enableMinimumEncryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkGroupConfiguration model) {
            this.resultConfiguration(model.resultConfiguration);
            this.enforceWorkGroupConfiguration(model.enforceWorkGroupConfiguration);
            this.publishCloudWatchMetricsEnabled(model.publishCloudWatchMetricsEnabled);
            this.bytesScannedCutoffPerQuery(model.bytesScannedCutoffPerQuery);
            this.requesterPaysEnabled(model.requesterPaysEnabled);
            this.engineVersion(model.engineVersion);
            this.additionalConfiguration(model.additionalConfiguration);
            this.executionRole(model.executionRole);
            this.customerContentEncryptionConfiguration(model.customerContentEncryptionConfiguration);
            this.enableMinimumEncryptionConfiguration(model.enableMinimumEncryptionConfiguration);
        }

        public final ResultConfiguration.Builder getResultConfiguration() {
            return this.resultConfiguration != null ? this.resultConfiguration.toBuilder() : null;
        }

        public final void setResultConfiguration(ResultConfiguration.BuilderImpl resultConfiguration) {
            this.resultConfiguration = resultConfiguration != null ? resultConfiguration.build() : null;
        }

        @Override
        public final Builder resultConfiguration(ResultConfiguration resultConfiguration) {
            this.resultConfiguration = resultConfiguration;
            return this;
        }

        public final Boolean getEnforceWorkGroupConfiguration() {
            return this.enforceWorkGroupConfiguration;
        }

        public final void setEnforceWorkGroupConfiguration(Boolean enforceWorkGroupConfiguration) {
            this.enforceWorkGroupConfiguration = enforceWorkGroupConfiguration;
        }

        @Override
        public final Builder enforceWorkGroupConfiguration(Boolean enforceWorkGroupConfiguration) {
            this.enforceWorkGroupConfiguration = enforceWorkGroupConfiguration;
            return this;
        }

        public final Boolean getPublishCloudWatchMetricsEnabled() {
            return this.publishCloudWatchMetricsEnabled;
        }

        public final void setPublishCloudWatchMetricsEnabled(Boolean publishCloudWatchMetricsEnabled) {
            this.publishCloudWatchMetricsEnabled = publishCloudWatchMetricsEnabled;
        }

        @Override
        public final Builder publishCloudWatchMetricsEnabled(Boolean publishCloudWatchMetricsEnabled) {
            this.publishCloudWatchMetricsEnabled = publishCloudWatchMetricsEnabled;
            return this;
        }

        public final Long getBytesScannedCutoffPerQuery() {
            return this.bytesScannedCutoffPerQuery;
        }

        public final void setBytesScannedCutoffPerQuery(Long bytesScannedCutoffPerQuery) {
            this.bytesScannedCutoffPerQuery = bytesScannedCutoffPerQuery;
        }

        @Override
        public final Builder bytesScannedCutoffPerQuery(Long bytesScannedCutoffPerQuery) {
            this.bytesScannedCutoffPerQuery = bytesScannedCutoffPerQuery;
            return this;
        }

        public final Boolean getRequesterPaysEnabled() {
            return this.requesterPaysEnabled;
        }

        public final void setRequesterPaysEnabled(Boolean requesterPaysEnabled) {
            this.requesterPaysEnabled = requesterPaysEnabled;
        }

        @Override
        public final Builder requesterPaysEnabled(Boolean requesterPaysEnabled) {
            this.requesterPaysEnabled = requesterPaysEnabled;
            return this;
        }

        public final EngineVersion.Builder getEngineVersion() {
            return this.engineVersion != null ? this.engineVersion.toBuilder() : null;
        }

        public final void setEngineVersion(EngineVersion.BuilderImpl engineVersion) {
            this.engineVersion = engineVersion != null ? engineVersion.build() : null;
        }

        @Override
        public final Builder engineVersion(EngineVersion engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getAdditionalConfiguration() {
            return this.additionalConfiguration;
        }

        public final void setAdditionalConfiguration(String additionalConfiguration) {
            this.additionalConfiguration = additionalConfiguration;
        }

        @Override
        public final Builder additionalConfiguration(String additionalConfiguration) {
            this.additionalConfiguration = additionalConfiguration;
            return this;
        }

        public final String getExecutionRole() {
            return this.executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final CustomerContentEncryptionConfiguration.Builder getCustomerContentEncryptionConfiguration() {
            return this.customerContentEncryptionConfiguration != null ? this.customerContentEncryptionConfiguration.toBuilder() : null;
        }

        public final void setCustomerContentEncryptionConfiguration(CustomerContentEncryptionConfiguration.BuilderImpl customerContentEncryptionConfiguration) {
            this.customerContentEncryptionConfiguration = customerContentEncryptionConfiguration != null ? customerContentEncryptionConfiguration.build() : null;
        }

        @Override
        public final Builder customerContentEncryptionConfiguration(CustomerContentEncryptionConfiguration customerContentEncryptionConfiguration) {
            this.customerContentEncryptionConfiguration = customerContentEncryptionConfiguration;
            return this;
        }

        public final Boolean getEnableMinimumEncryptionConfiguration() {
            return this.enableMinimumEncryptionConfiguration;
        }

        public final void setEnableMinimumEncryptionConfiguration(Boolean enableMinimumEncryptionConfiguration) {
            this.enableMinimumEncryptionConfiguration = enableMinimumEncryptionConfiguration;
        }

        @Override
        public final Builder enableMinimumEncryptionConfiguration(Boolean enableMinimumEncryptionConfiguration) {
            this.enableMinimumEncryptionConfiguration = enableMinimumEncryptionConfiguration;
            return this;
        }

        public WorkGroupConfiguration build() {
            return new WorkGroupConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkGroupConfiguration> {
        public Builder resultConfiguration(ResultConfiguration var1);

        default public Builder resultConfiguration(Consumer<ResultConfiguration.Builder> resultConfiguration) {
            return this.resultConfiguration((ResultConfiguration)((ResultConfiguration.Builder)ResultConfiguration.builder().applyMutation(resultConfiguration)).build());
        }

        public Builder enforceWorkGroupConfiguration(Boolean var1);

        public Builder publishCloudWatchMetricsEnabled(Boolean var1);

        public Builder bytesScannedCutoffPerQuery(Long var1);

        public Builder requesterPaysEnabled(Boolean var1);

        public Builder engineVersion(EngineVersion var1);

        default public Builder engineVersion(Consumer<EngineVersion.Builder> engineVersion) {
            return this.engineVersion((EngineVersion)((EngineVersion.Builder)EngineVersion.builder().applyMutation(engineVersion)).build());
        }

        public Builder additionalConfiguration(String var1);

        public Builder executionRole(String var1);

        public Builder customerContentEncryptionConfiguration(CustomerContentEncryptionConfiguration var1);

        default public Builder customerContentEncryptionConfiguration(Consumer<CustomerContentEncryptionConfiguration.Builder> customerContentEncryptionConfiguration) {
            return this.customerContentEncryptionConfiguration((CustomerContentEncryptionConfiguration)((CustomerContentEncryptionConfiguration.Builder)CustomerContentEncryptionConfiguration.builder().applyMutation(customerContentEncryptionConfiguration)).build());
        }

        public Builder enableMinimumEncryptionConfiguration(Boolean var1);
    }
}

