/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.internal.UserAgentUtils;
import software.amazon.awssdk.services.athena.model.ListPreparedStatementsRequest;
import software.amazon.awssdk.services.athena.model.ListPreparedStatementsResponse;

public class ListPreparedStatementsIterable
implements SdkIterable<ListPreparedStatementsResponse> {
    private final AthenaClient client;
    private final ListPreparedStatementsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPreparedStatementsIterable(AthenaClient client, ListPreparedStatementsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPreparedStatementsResponseFetcher();
    }

    public Iterator<ListPreparedStatementsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListPreparedStatementsResponseFetcher
    implements SyncPageFetcher<ListPreparedStatementsResponse> {
        private ListPreparedStatementsResponseFetcher() {
        }

        public boolean hasNextPage(ListPreparedStatementsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPreparedStatementsResponse nextPage(ListPreparedStatementsResponse previousPage) {
            if (previousPage == null) {
                return ListPreparedStatementsIterable.this.client.listPreparedStatements(ListPreparedStatementsIterable.this.firstRequest);
            }
            return ListPreparedStatementsIterable.this.client.listPreparedStatements((ListPreparedStatementsRequest)((Object)ListPreparedStatementsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

