/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.SourceApiAssociationConfig;
import software.amazon.awssdk.services.appsync.model.SourceApiAssociationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceApiAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceApiAssociation> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associationId").getter(SourceApiAssociation.getter(SourceApiAssociation::associationId)).setter(SourceApiAssociation.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationId").build()}).build();
    private static final SdkField<String> ASSOCIATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associationArn").getter(SourceApiAssociation.getter(SourceApiAssociation::associationArn)).setter(SourceApiAssociation.setter(Builder::associationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationArn").build()}).build();
    private static final SdkField<String> SOURCE_API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceApiId").getter(SourceApiAssociation.getter(SourceApiAssociation::sourceApiId)).setter(SourceApiAssociation.setter(Builder::sourceApiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceApiId").build()}).build();
    private static final SdkField<String> SOURCE_API_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceApiArn").getter(SourceApiAssociation.getter(SourceApiAssociation::sourceApiArn)).setter(SourceApiAssociation.setter(Builder::sourceApiArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceApiArn").build()}).build();
    private static final SdkField<String> MERGED_API_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mergedApiArn").getter(SourceApiAssociation.getter(SourceApiAssociation::mergedApiArn)).setter(SourceApiAssociation.setter(Builder::mergedApiArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergedApiArn").build()}).build();
    private static final SdkField<String> MERGED_API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mergedApiId").getter(SourceApiAssociation.getter(SourceApiAssociation::mergedApiId)).setter(SourceApiAssociation.setter(Builder::mergedApiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergedApiId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(SourceApiAssociation.getter(SourceApiAssociation::description)).setter(SourceApiAssociation.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<SourceApiAssociationConfig> SOURCE_API_ASSOCIATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceApiAssociationConfig").getter(SourceApiAssociation.getter(SourceApiAssociation::sourceApiAssociationConfig)).setter(SourceApiAssociation.setter(Builder::sourceApiAssociationConfig)).constructor(SourceApiAssociationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceApiAssociationConfig").build()}).build();
    private static final SdkField<String> SOURCE_API_ASSOCIATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceApiAssociationStatus").getter(SourceApiAssociation.getter(SourceApiAssociation::sourceApiAssociationStatusAsString)).setter(SourceApiAssociation.setter(Builder::sourceApiAssociationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceApiAssociationStatus").build()}).build();
    private static final SdkField<String> SOURCE_API_ASSOCIATION_STATUS_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceApiAssociationStatusDetail").getter(SourceApiAssociation.getter(SourceApiAssociation::sourceApiAssociationStatusDetail)).setter(SourceApiAssociation.setter(Builder::sourceApiAssociationStatusDetail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceApiAssociationStatusDetail").build()}).build();
    private static final SdkField<Instant> LAST_SUCCESSFUL_MERGE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastSuccessfulMergeDate").getter(SourceApiAssociation.getter(SourceApiAssociation::lastSuccessfulMergeDate)).setter(SourceApiAssociation.setter(Builder::lastSuccessfulMergeDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSuccessfulMergeDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD, ASSOCIATION_ARN_FIELD, SOURCE_API_ID_FIELD, SOURCE_API_ARN_FIELD, MERGED_API_ARN_FIELD, MERGED_API_ID_FIELD, DESCRIPTION_FIELD, SOURCE_API_ASSOCIATION_CONFIG_FIELD, SOURCE_API_ASSOCIATION_STATUS_FIELD, SOURCE_API_ASSOCIATION_STATUS_DETAIL_FIELD, LAST_SUCCESSFUL_MERGE_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String associationId;
    private final String associationArn;
    private final String sourceApiId;
    private final String sourceApiArn;
    private final String mergedApiArn;
    private final String mergedApiId;
    private final String description;
    private final SourceApiAssociationConfig sourceApiAssociationConfig;
    private final String sourceApiAssociationStatus;
    private final String sourceApiAssociationStatusDetail;
    private final Instant lastSuccessfulMergeDate;

    private SourceApiAssociation(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.associationArn = builder.associationArn;
        this.sourceApiId = builder.sourceApiId;
        this.sourceApiArn = builder.sourceApiArn;
        this.mergedApiArn = builder.mergedApiArn;
        this.mergedApiId = builder.mergedApiId;
        this.description = builder.description;
        this.sourceApiAssociationConfig = builder.sourceApiAssociationConfig;
        this.sourceApiAssociationStatus = builder.sourceApiAssociationStatus;
        this.sourceApiAssociationStatusDetail = builder.sourceApiAssociationStatusDetail;
        this.lastSuccessfulMergeDate = builder.lastSuccessfulMergeDate;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final String associationArn() {
        return this.associationArn;
    }

    public final String sourceApiId() {
        return this.sourceApiId;
    }

    public final String sourceApiArn() {
        return this.sourceApiArn;
    }

    public final String mergedApiArn() {
        return this.mergedApiArn;
    }

    public final String mergedApiId() {
        return this.mergedApiId;
    }

    public final String description() {
        return this.description;
    }

    public final SourceApiAssociationConfig sourceApiAssociationConfig() {
        return this.sourceApiAssociationConfig;
    }

    public final SourceApiAssociationStatus sourceApiAssociationStatus() {
        return SourceApiAssociationStatus.fromValue(this.sourceApiAssociationStatus);
    }

    public final String sourceApiAssociationStatusAsString() {
        return this.sourceApiAssociationStatus;
    }

    public final String sourceApiAssociationStatusDetail() {
        return this.sourceApiAssociationStatusDetail;
    }

    public final Instant lastSuccessfulMergeDate() {
        return this.lastSuccessfulMergeDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceApiArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergedApiArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergedApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceApiAssociationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceApiAssociationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceApiAssociationStatusDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSuccessfulMergeDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceApiAssociation)) {
            return false;
        }
        SourceApiAssociation other = (SourceApiAssociation)obj;
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.associationArn(), other.associationArn()) && Objects.equals(this.sourceApiId(), other.sourceApiId()) && Objects.equals(this.sourceApiArn(), other.sourceApiArn()) && Objects.equals(this.mergedApiArn(), other.mergedApiArn()) && Objects.equals(this.mergedApiId(), other.mergedApiId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.sourceApiAssociationConfig(), other.sourceApiAssociationConfig()) && Objects.equals(this.sourceApiAssociationStatusAsString(), other.sourceApiAssociationStatusAsString()) && Objects.equals(this.sourceApiAssociationStatusDetail(), other.sourceApiAssociationStatusDetail()) && Objects.equals(this.lastSuccessfulMergeDate(), other.lastSuccessfulMergeDate());
    }

    public final String toString() {
        return ToString.builder((String)"SourceApiAssociation").add("AssociationId", (Object)this.associationId()).add("AssociationArn", (Object)this.associationArn()).add("SourceApiId", (Object)this.sourceApiId()).add("SourceApiArn", (Object)this.sourceApiArn()).add("MergedApiArn", (Object)this.mergedApiArn()).add("MergedApiId", (Object)this.mergedApiId()).add("Description", (Object)this.description()).add("SourceApiAssociationConfig", (Object)this.sourceApiAssociationConfig()).add("SourceApiAssociationStatus", (Object)this.sourceApiAssociationStatusAsString()).add("SourceApiAssociationStatusDetail", (Object)this.sourceApiAssociationStatusDetail()).add("LastSuccessfulMergeDate", (Object)this.lastSuccessfulMergeDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "associationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "associationArn": {
                return Optional.ofNullable(clazz.cast(this.associationArn()));
            }
            case "sourceApiId": {
                return Optional.ofNullable(clazz.cast(this.sourceApiId()));
            }
            case "sourceApiArn": {
                return Optional.ofNullable(clazz.cast(this.sourceApiArn()));
            }
            case "mergedApiArn": {
                return Optional.ofNullable(clazz.cast(this.mergedApiArn()));
            }
            case "mergedApiId": {
                return Optional.ofNullable(clazz.cast(this.mergedApiId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "sourceApiAssociationConfig": {
                return Optional.ofNullable(clazz.cast(this.sourceApiAssociationConfig()));
            }
            case "sourceApiAssociationStatus": {
                return Optional.ofNullable(clazz.cast(this.sourceApiAssociationStatusAsString()));
            }
            case "sourceApiAssociationStatusDetail": {
                return Optional.ofNullable(clazz.cast(this.sourceApiAssociationStatusDetail()));
            }
            case "lastSuccessfulMergeDate": {
                return Optional.ofNullable(clazz.cast(this.lastSuccessfulMergeDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceApiAssociation, T> g) {
        return obj -> g.apply((SourceApiAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String associationId;
        private String associationArn;
        private String sourceApiId;
        private String sourceApiArn;
        private String mergedApiArn;
        private String mergedApiId;
        private String description;
        private SourceApiAssociationConfig sourceApiAssociationConfig;
        private String sourceApiAssociationStatus;
        private String sourceApiAssociationStatusDetail;
        private Instant lastSuccessfulMergeDate;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceApiAssociation model) {
            this.associationId(model.associationId);
            this.associationArn(model.associationArn);
            this.sourceApiId(model.sourceApiId);
            this.sourceApiArn(model.sourceApiArn);
            this.mergedApiArn(model.mergedApiArn);
            this.mergedApiId(model.mergedApiId);
            this.description(model.description);
            this.sourceApiAssociationConfig(model.sourceApiAssociationConfig);
            this.sourceApiAssociationStatus(model.sourceApiAssociationStatus);
            this.sourceApiAssociationStatusDetail(model.sourceApiAssociationStatusDetail);
            this.lastSuccessfulMergeDate(model.lastSuccessfulMergeDate);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getAssociationArn() {
            return this.associationArn;
        }

        public final void setAssociationArn(String associationArn) {
            this.associationArn = associationArn;
        }

        @Override
        public final Builder associationArn(String associationArn) {
            this.associationArn = associationArn;
            return this;
        }

        public final String getSourceApiId() {
            return this.sourceApiId;
        }

        public final void setSourceApiId(String sourceApiId) {
            this.sourceApiId = sourceApiId;
        }

        @Override
        public final Builder sourceApiId(String sourceApiId) {
            this.sourceApiId = sourceApiId;
            return this;
        }

        public final String getSourceApiArn() {
            return this.sourceApiArn;
        }

        public final void setSourceApiArn(String sourceApiArn) {
            this.sourceApiArn = sourceApiArn;
        }

        @Override
        public final Builder sourceApiArn(String sourceApiArn) {
            this.sourceApiArn = sourceApiArn;
            return this;
        }

        public final String getMergedApiArn() {
            return this.mergedApiArn;
        }

        public final void setMergedApiArn(String mergedApiArn) {
            this.mergedApiArn = mergedApiArn;
        }

        @Override
        public final Builder mergedApiArn(String mergedApiArn) {
            this.mergedApiArn = mergedApiArn;
            return this;
        }

        public final String getMergedApiId() {
            return this.mergedApiId;
        }

        public final void setMergedApiId(String mergedApiId) {
            this.mergedApiId = mergedApiId;
        }

        @Override
        public final Builder mergedApiId(String mergedApiId) {
            this.mergedApiId = mergedApiId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final SourceApiAssociationConfig.Builder getSourceApiAssociationConfig() {
            return this.sourceApiAssociationConfig != null ? this.sourceApiAssociationConfig.toBuilder() : null;
        }

        public final void setSourceApiAssociationConfig(SourceApiAssociationConfig.BuilderImpl sourceApiAssociationConfig) {
            this.sourceApiAssociationConfig = sourceApiAssociationConfig != null ? sourceApiAssociationConfig.build() : null;
        }

        @Override
        public final Builder sourceApiAssociationConfig(SourceApiAssociationConfig sourceApiAssociationConfig) {
            this.sourceApiAssociationConfig = sourceApiAssociationConfig;
            return this;
        }

        public final String getSourceApiAssociationStatus() {
            return this.sourceApiAssociationStatus;
        }

        public final void setSourceApiAssociationStatus(String sourceApiAssociationStatus) {
            this.sourceApiAssociationStatus = sourceApiAssociationStatus;
        }

        @Override
        public final Builder sourceApiAssociationStatus(String sourceApiAssociationStatus) {
            this.sourceApiAssociationStatus = sourceApiAssociationStatus;
            return this;
        }

        @Override
        public final Builder sourceApiAssociationStatus(SourceApiAssociationStatus sourceApiAssociationStatus) {
            this.sourceApiAssociationStatus(sourceApiAssociationStatus == null ? null : sourceApiAssociationStatus.toString());
            return this;
        }

        public final String getSourceApiAssociationStatusDetail() {
            return this.sourceApiAssociationStatusDetail;
        }

        public final void setSourceApiAssociationStatusDetail(String sourceApiAssociationStatusDetail) {
            this.sourceApiAssociationStatusDetail = sourceApiAssociationStatusDetail;
        }

        @Override
        public final Builder sourceApiAssociationStatusDetail(String sourceApiAssociationStatusDetail) {
            this.sourceApiAssociationStatusDetail = sourceApiAssociationStatusDetail;
            return this;
        }

        public final Instant getLastSuccessfulMergeDate() {
            return this.lastSuccessfulMergeDate;
        }

        public final void setLastSuccessfulMergeDate(Instant lastSuccessfulMergeDate) {
            this.lastSuccessfulMergeDate = lastSuccessfulMergeDate;
        }

        @Override
        public final Builder lastSuccessfulMergeDate(Instant lastSuccessfulMergeDate) {
            this.lastSuccessfulMergeDate = lastSuccessfulMergeDate;
            return this;
        }

        public SourceApiAssociation build() {
            return new SourceApiAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceApiAssociation> {
        public Builder associationId(String var1);

        public Builder associationArn(String var1);

        public Builder sourceApiId(String var1);

        public Builder sourceApiArn(String var1);

        public Builder mergedApiArn(String var1);

        public Builder mergedApiId(String var1);

        public Builder description(String var1);

        public Builder sourceApiAssociationConfig(SourceApiAssociationConfig var1);

        default public Builder sourceApiAssociationConfig(Consumer<SourceApiAssociationConfig.Builder> sourceApiAssociationConfig) {
            return this.sourceApiAssociationConfig((SourceApiAssociationConfig)((SourceApiAssociationConfig.Builder)SourceApiAssociationConfig.builder().applyMutation(sourceApiAssociationConfig)).build());
        }

        public Builder sourceApiAssociationStatus(String var1);

        public Builder sourceApiAssociationStatus(SourceApiAssociationStatus var1);

        public Builder sourceApiAssociationStatusDetail(String var1);

        public Builder lastSuccessfulMergeDate(Instant var1);
    }
}

