/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.AccessEndpoint;
import software.amazon.awssdk.services.appstream.model.AccessEndpointListCopier;
import software.amazon.awssdk.services.appstream.model.AppBlockBuilderPlatformType;
import software.amazon.awssdk.services.appstream.model.AppBlockBuilderState;
import software.amazon.awssdk.services.appstream.model.AppBlockBuilderStateChangeReason;
import software.amazon.awssdk.services.appstream.model.ResourceError;
import software.amazon.awssdk.services.appstream.model.ResourceErrorsCopier;
import software.amazon.awssdk.services.appstream.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppBlockBuilder
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppBlockBuilder> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(AppBlockBuilder.getter(AppBlockBuilder::arn)).setter(AppBlockBuilder.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AppBlockBuilder.getter(AppBlockBuilder::name)).setter(AppBlockBuilder.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(AppBlockBuilder.getter(AppBlockBuilder::displayName)).setter(AppBlockBuilder.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(AppBlockBuilder.getter(AppBlockBuilder::description)).setter(AppBlockBuilder.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Platform").getter(AppBlockBuilder.getter(AppBlockBuilder::platformAsString)).setter(AppBlockBuilder.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(AppBlockBuilder.getter(AppBlockBuilder::instanceType)).setter(AppBlockBuilder.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<Boolean> ENABLE_DEFAULT_INTERNET_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableDefaultInternetAccess").getter(AppBlockBuilder.getter(AppBlockBuilder::enableDefaultInternetAccess)).setter(AppBlockBuilder.setter(Builder::enableDefaultInternetAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDefaultInternetAccess").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(AppBlockBuilder.getter(AppBlockBuilder::iamRoleArn)).setter(AppBlockBuilder.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(AppBlockBuilder.getter(AppBlockBuilder::vpcConfig)).setter(AppBlockBuilder.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(AppBlockBuilder.getter(AppBlockBuilder::stateAsString)).setter(AppBlockBuilder.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(AppBlockBuilder.getter(AppBlockBuilder::createdTime)).setter(AppBlockBuilder.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<List<ResourceError>> APP_BLOCK_BUILDER_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AppBlockBuilderErrors").getter(AppBlockBuilder.getter(AppBlockBuilder::appBlockBuilderErrors)).setter(AppBlockBuilder.setter(Builder::appBlockBuilderErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppBlockBuilderErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AppBlockBuilderStateChangeReason> STATE_CHANGE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StateChangeReason").getter(AppBlockBuilder.getter(AppBlockBuilder::stateChangeReason)).setter(AppBlockBuilder.setter(Builder::stateChangeReason)).constructor(AppBlockBuilderStateChangeReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateChangeReason").build()}).build();
    private static final SdkField<List<AccessEndpoint>> ACCESS_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccessEndpoints").getter(AppBlockBuilder.getter(AppBlockBuilder::accessEndpoints)).setter(AppBlockBuilder.setter(Builder::accessEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, PLATFORM_FIELD, INSTANCE_TYPE_FIELD, ENABLE_DEFAULT_INTERNET_ACCESS_FIELD, IAM_ROLE_ARN_FIELD, VPC_CONFIG_FIELD, STATE_FIELD, CREATED_TIME_FIELD, APP_BLOCK_BUILDER_ERRORS_FIELD, STATE_CHANGE_REASON_FIELD, ACCESS_ENDPOINTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String displayName;
    private final String description;
    private final String platform;
    private final String instanceType;
    private final Boolean enableDefaultInternetAccess;
    private final String iamRoleArn;
    private final VpcConfig vpcConfig;
    private final String state;
    private final Instant createdTime;
    private final List<ResourceError> appBlockBuilderErrors;
    private final AppBlockBuilderStateChangeReason stateChangeReason;
    private final List<AccessEndpoint> accessEndpoints;

    private AppBlockBuilder(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.platform = builder.platform;
        this.instanceType = builder.instanceType;
        this.enableDefaultInternetAccess = builder.enableDefaultInternetAccess;
        this.iamRoleArn = builder.iamRoleArn;
        this.vpcConfig = builder.vpcConfig;
        this.state = builder.state;
        this.createdTime = builder.createdTime;
        this.appBlockBuilderErrors = builder.appBlockBuilderErrors;
        this.stateChangeReason = builder.stateChangeReason;
        this.accessEndpoints = builder.accessEndpoints;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String description() {
        return this.description;
    }

    public final AppBlockBuilderPlatformType platform() {
        return AppBlockBuilderPlatformType.fromValue(this.platform);
    }

    public final String platformAsString() {
        return this.platform;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final Boolean enableDefaultInternetAccess() {
        return this.enableDefaultInternetAccess;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final AppBlockBuilderState state() {
        return AppBlockBuilderState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final boolean hasAppBlockBuilderErrors() {
        return this.appBlockBuilderErrors != null && !(this.appBlockBuilderErrors instanceof SdkAutoConstructList);
    }

    public final List<ResourceError> appBlockBuilderErrors() {
        return this.appBlockBuilderErrors;
    }

    public final AppBlockBuilderStateChangeReason stateChangeReason() {
        return this.stateChangeReason;
    }

    public final boolean hasAccessEndpoints() {
        return this.accessEndpoints != null && !(this.accessEndpoints instanceof SdkAutoConstructList);
    }

    public final List<AccessEndpoint> accessEndpoints() {
        return this.accessEndpoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableDefaultInternetAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppBlockBuilderErrors() ? this.appBlockBuilderErrors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stateChangeReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessEndpoints() ? this.accessEndpoints() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppBlockBuilder)) {
            return false;
        }
        AppBlockBuilder other = (AppBlockBuilder)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.platformAsString(), other.platformAsString()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.enableDefaultInternetAccess(), other.enableDefaultInternetAccess()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.createdTime(), other.createdTime()) && this.hasAppBlockBuilderErrors() == other.hasAppBlockBuilderErrors() && Objects.equals(this.appBlockBuilderErrors(), other.appBlockBuilderErrors()) && Objects.equals(this.stateChangeReason(), other.stateChangeReason()) && this.hasAccessEndpoints() == other.hasAccessEndpoints() && Objects.equals(this.accessEndpoints(), other.accessEndpoints());
    }

    public final String toString() {
        return ToString.builder((String)"AppBlockBuilder").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("DisplayName", (Object)this.displayName()).add("Description", (Object)this.description()).add("Platform", (Object)this.platformAsString()).add("InstanceType", (Object)this.instanceType()).add("EnableDefaultInternetAccess", (Object)this.enableDefaultInternetAccess()).add("IamRoleArn", (Object)this.iamRoleArn()).add("VpcConfig", (Object)this.vpcConfig()).add("State", (Object)this.stateAsString()).add("CreatedTime", (Object)this.createdTime()).add("AppBlockBuilderErrors", this.hasAppBlockBuilderErrors() ? this.appBlockBuilderErrors() : null).add("StateChangeReason", (Object)this.stateChangeReason()).add("AccessEndpoints", this.hasAccessEndpoints() ? this.accessEndpoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "EnableDefaultInternetAccess": {
                return Optional.ofNullable(clazz.cast(this.enableDefaultInternetAccess()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "AppBlockBuilderErrors": {
                return Optional.ofNullable(clazz.cast(this.appBlockBuilderErrors()));
            }
            case "StateChangeReason": {
                return Optional.ofNullable(clazz.cast(this.stateChangeReason()));
            }
            case "AccessEndpoints": {
                return Optional.ofNullable(clazz.cast(this.accessEndpoints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppBlockBuilder, T> g) {
        return obj -> g.apply((AppBlockBuilder)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String displayName;
        private String description;
        private String platform;
        private String instanceType;
        private Boolean enableDefaultInternetAccess;
        private String iamRoleArn;
        private VpcConfig vpcConfig;
        private String state;
        private Instant createdTime;
        private List<ResourceError> appBlockBuilderErrors = DefaultSdkAutoConstructList.getInstance();
        private AppBlockBuilderStateChangeReason stateChangeReason;
        private List<AccessEndpoint> accessEndpoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AppBlockBuilder model) {
            this.arn(model.arn);
            this.name(model.name);
            this.displayName(model.displayName);
            this.description(model.description);
            this.platform(model.platform);
            this.instanceType(model.instanceType);
            this.enableDefaultInternetAccess(model.enableDefaultInternetAccess);
            this.iamRoleArn(model.iamRoleArn);
            this.vpcConfig(model.vpcConfig);
            this.state(model.state);
            this.createdTime(model.createdTime);
            this.appBlockBuilderErrors(model.appBlockBuilderErrors);
            this.stateChangeReason(model.stateChangeReason);
            this.accessEndpoints(model.accessEndpoints);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(AppBlockBuilderPlatformType platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final Boolean getEnableDefaultInternetAccess() {
            return this.enableDefaultInternetAccess;
        }

        public final void setEnableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
        }

        @Override
        public final Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AppBlockBuilderState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final List<ResourceError.Builder> getAppBlockBuilderErrors() {
            List<ResourceError.Builder> result = ResourceErrorsCopier.copyToBuilder(this.appBlockBuilderErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppBlockBuilderErrors(Collection<ResourceError.BuilderImpl> appBlockBuilderErrors) {
            this.appBlockBuilderErrors = ResourceErrorsCopier.copyFromBuilder(appBlockBuilderErrors);
        }

        @Override
        public final Builder appBlockBuilderErrors(Collection<ResourceError> appBlockBuilderErrors) {
            this.appBlockBuilderErrors = ResourceErrorsCopier.copy(appBlockBuilderErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appBlockBuilderErrors(ResourceError ... appBlockBuilderErrors) {
            this.appBlockBuilderErrors(Arrays.asList(appBlockBuilderErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appBlockBuilderErrors(Consumer<ResourceError.Builder> ... appBlockBuilderErrors) {
            this.appBlockBuilderErrors(Stream.of(appBlockBuilderErrors).map(c -> (ResourceError)((ResourceError.Builder)ResourceError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AppBlockBuilderStateChangeReason.Builder getStateChangeReason() {
            return this.stateChangeReason != null ? this.stateChangeReason.toBuilder() : null;
        }

        public final void setStateChangeReason(AppBlockBuilderStateChangeReason.BuilderImpl stateChangeReason) {
            this.stateChangeReason = stateChangeReason != null ? stateChangeReason.build() : null;
        }

        @Override
        public final Builder stateChangeReason(AppBlockBuilderStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final List<AccessEndpoint.Builder> getAccessEndpoints() {
            List<AccessEndpoint.Builder> result = AccessEndpointListCopier.copyToBuilder(this.accessEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessEndpoints(Collection<AccessEndpoint.BuilderImpl> accessEndpoints) {
            this.accessEndpoints = AccessEndpointListCopier.copyFromBuilder(accessEndpoints);
        }

        @Override
        public final Builder accessEndpoints(Collection<AccessEndpoint> accessEndpoints) {
            this.accessEndpoints = AccessEndpointListCopier.copy(accessEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessEndpoints(AccessEndpoint ... accessEndpoints) {
            this.accessEndpoints(Arrays.asList(accessEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessEndpoints(Consumer<AccessEndpoint.Builder> ... accessEndpoints) {
            this.accessEndpoints(Stream.of(accessEndpoints).map(c -> (AccessEndpoint)((AccessEndpoint.Builder)AccessEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AppBlockBuilder build() {
            return new AppBlockBuilder(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppBlockBuilder> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder platform(String var1);

        public Builder platform(AppBlockBuilderPlatformType var1);

        public Builder instanceType(String var1);

        public Builder enableDefaultInternetAccess(Boolean var1);

        public Builder iamRoleArn(String var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder state(String var1);

        public Builder state(AppBlockBuilderState var1);

        public Builder createdTime(Instant var1);

        public Builder appBlockBuilderErrors(Collection<ResourceError> var1);

        public Builder appBlockBuilderErrors(ResourceError ... var1);

        public Builder appBlockBuilderErrors(Consumer<ResourceError.Builder> ... var1);

        public Builder stateChangeReason(AppBlockBuilderStateChangeReason var1);

        default public Builder stateChangeReason(Consumer<AppBlockBuilderStateChangeReason.Builder> stateChangeReason) {
            return this.stateChangeReason((AppBlockBuilderStateChangeReason)((AppBlockBuilderStateChangeReason.Builder)AppBlockBuilderStateChangeReason.builder().applyMutation(stateChangeReason)).build());
        }

        public Builder accessEndpoints(Collection<AccessEndpoint> var1);

        public Builder accessEndpoints(AccessEndpoint ... var1);

        public Builder accessEndpoints(Consumer<AccessEndpoint.Builder> ... var1);
    }
}

