/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the capacity for a fleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComputeCapacity implements SdkPojo, Serializable, ToCopyableBuilder<ComputeCapacity.Builder, ComputeCapacity> {
    private static final SdkField<Integer> DESIRED_INSTANCES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DesiredInstances").getter(getter(ComputeCapacity::desiredInstances))
            .setter(setter(Builder::desiredInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredInstances").build()).build();

    private static final SdkField<Integer> DESIRED_SESSIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DesiredSessions").getter(getter(ComputeCapacity::desiredSessions))
            .setter(setter(Builder::desiredSessions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredSessions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESIRED_INSTANCES_FIELD,
            DESIRED_SESSIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer desiredInstances;

    private final Integer desiredSessions;

    private ComputeCapacity(BuilderImpl builder) {
        this.desiredInstances = builder.desiredInstances;
        this.desiredSessions = builder.desiredSessions;
    }

    /**
     * <p>
     * The desired number of streaming instances.
     * </p>
     * 
     * @return The desired number of streaming instances.
     */
    public final Integer desiredInstances() {
        return desiredInstances;
    }

    /**
     * <p>
     * The desired number of user sessions for a multi-session fleet. This is not allowed for single-session fleets.
     * </p>
     * <p>
     * When you create a fleet, you must set either the DesiredSessions or DesiredInstances attribute, based on the type
     * of fleet you create. You can’t define both attributes or leave both attributes blank.
     * </p>
     * 
     * @return The desired number of user sessions for a multi-session fleet. This is not allowed for single-session
     *         fleets.</p>
     *         <p>
     *         When you create a fleet, you must set either the DesiredSessions or DesiredInstances attribute, based on
     *         the type of fleet you create. You can’t define both attributes or leave both attributes blank.
     */
    public final Integer desiredSessions() {
        return desiredSessions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(desiredInstances());
        hashCode = 31 * hashCode + Objects.hashCode(desiredSessions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeCapacity)) {
            return false;
        }
        ComputeCapacity other = (ComputeCapacity) obj;
        return Objects.equals(desiredInstances(), other.desiredInstances())
                && Objects.equals(desiredSessions(), other.desiredSessions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComputeCapacity").add("DesiredInstances", desiredInstances())
                .add("DesiredSessions", desiredSessions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DesiredInstances":
            return Optional.ofNullable(clazz.cast(desiredInstances()));
        case "DesiredSessions":
            return Optional.ofNullable(clazz.cast(desiredSessions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComputeCapacity, T> g) {
        return obj -> g.apply((ComputeCapacity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComputeCapacity> {
        /**
         * <p>
         * The desired number of streaming instances.
         * </p>
         * 
         * @param desiredInstances
         *        The desired number of streaming instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredInstances(Integer desiredInstances);

        /**
         * <p>
         * The desired number of user sessions for a multi-session fleet. This is not allowed for single-session fleets.
         * </p>
         * <p>
         * When you create a fleet, you must set either the DesiredSessions or DesiredInstances attribute, based on the
         * type of fleet you create. You can’t define both attributes or leave both attributes blank.
         * </p>
         * 
         * @param desiredSessions
         *        The desired number of user sessions for a multi-session fleet. This is not allowed for single-session
         *        fleets.</p>
         *        <p>
         *        When you create a fleet, you must set either the DesiredSessions or DesiredInstances attribute, based
         *        on the type of fleet you create. You can’t define both attributes or leave both attributes blank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredSessions(Integer desiredSessions);
    }

    static final class BuilderImpl implements Builder {
        private Integer desiredInstances;

        private Integer desiredSessions;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeCapacity model) {
            desiredInstances(model.desiredInstances);
            desiredSessions(model.desiredSessions);
        }

        public final Integer getDesiredInstances() {
            return desiredInstances;
        }

        public final void setDesiredInstances(Integer desiredInstances) {
            this.desiredInstances = desiredInstances;
        }

        @Override
        public final Builder desiredInstances(Integer desiredInstances) {
            this.desiredInstances = desiredInstances;
            return this;
        }

        public final Integer getDesiredSessions() {
            return desiredSessions;
        }

        public final void setDesiredSessions(Integer desiredSessions) {
            this.desiredSessions = desiredSessions;
        }

        @Override
        public final Builder desiredSessions(Integer desiredSessions) {
            this.desiredSessions = desiredSessions;
            return this;
        }

        @Override
        public ComputeCapacity build() {
            return new ComputeCapacity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
