/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.HttpRetryPolicy;
import software.amazon.awssdk.services.appmesh.model.HttpRouteAction;
import software.amazon.awssdk.services.appmesh.model.HttpRouteMatch;
import software.amazon.awssdk.services.appmesh.model.HttpTimeout;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HttpRoute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HttpRoute> {
    private static final SdkField<HttpRouteAction> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("action").getter(HttpRoute.getter(HttpRoute::action)).setter(HttpRoute.setter(Builder::action)).constructor(HttpRouteAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<HttpRouteMatch> MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("match").getter(HttpRoute.getter(HttpRoute::match)).setter(HttpRoute.setter(Builder::match)).constructor(HttpRouteMatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("match").build()}).build();
    private static final SdkField<HttpRetryPolicy> RETRY_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retryPolicy").getter(HttpRoute.getter(HttpRoute::retryPolicy)).setter(HttpRoute.setter(Builder::retryPolicy)).constructor(HttpRetryPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryPolicy").build()}).build();
    private static final SdkField<HttpTimeout> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timeout").getter(HttpRoute.getter(HttpRoute::timeout)).setter(HttpRoute.setter(Builder::timeout)).constructor(HttpTimeout::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeout").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, MATCH_FIELD, RETRY_POLICY_FIELD, TIMEOUT_FIELD));
    private static final long serialVersionUID = 1L;
    private final HttpRouteAction action;
    private final HttpRouteMatch match;
    private final HttpRetryPolicy retryPolicy;
    private final HttpTimeout timeout;

    private HttpRoute(BuilderImpl builder) {
        this.action = builder.action;
        this.match = builder.match;
        this.retryPolicy = builder.retryPolicy;
        this.timeout = builder.timeout;
    }

    public final HttpRouteAction action() {
        return this.action;
    }

    public final HttpRouteMatch match() {
        return this.match;
    }

    public final HttpRetryPolicy retryPolicy() {
        return this.retryPolicy;
    }

    public final HttpTimeout timeout() {
        return this.timeout;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.match());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpRoute)) {
            return false;
        }
        HttpRoute other = (HttpRoute)obj;
        return Objects.equals(this.action(), other.action()) && Objects.equals(this.match(), other.match()) && Objects.equals(this.retryPolicy(), other.retryPolicy()) && Objects.equals(this.timeout(), other.timeout());
    }

    public final String toString() {
        return ToString.builder((String)"HttpRoute").add("Action", (Object)this.action()).add("Match", (Object)this.match()).add("RetryPolicy", (Object)this.retryPolicy()).add("Timeout", (Object)this.timeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "match": {
                return Optional.ofNullable(clazz.cast(this.match()));
            }
            case "retryPolicy": {
                return Optional.ofNullable(clazz.cast(this.retryPolicy()));
            }
            case "timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HttpRoute, T> g) {
        return obj -> g.apply((HttpRoute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private HttpRouteAction action;
        private HttpRouteMatch match;
        private HttpRetryPolicy retryPolicy;
        private HttpTimeout timeout;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpRoute model) {
            this.action(model.action);
            this.match(model.match);
            this.retryPolicy(model.retryPolicy);
            this.timeout(model.timeout);
        }

        public final HttpRouteAction.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        public final void setAction(HttpRouteAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(HttpRouteAction action) {
            this.action = action;
            return this;
        }

        public final HttpRouteMatch.Builder getMatch() {
            return this.match != null ? this.match.toBuilder() : null;
        }

        public final void setMatch(HttpRouteMatch.BuilderImpl match) {
            this.match = match != null ? match.build() : null;
        }

        @Override
        public final Builder match(HttpRouteMatch match) {
            this.match = match;
            return this;
        }

        public final HttpRetryPolicy.Builder getRetryPolicy() {
            return this.retryPolicy != null ? this.retryPolicy.toBuilder() : null;
        }

        public final void setRetryPolicy(HttpRetryPolicy.BuilderImpl retryPolicy) {
            this.retryPolicy = retryPolicy != null ? retryPolicy.build() : null;
        }

        @Override
        public final Builder retryPolicy(HttpRetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public final HttpTimeout.Builder getTimeout() {
            return this.timeout != null ? this.timeout.toBuilder() : null;
        }

        public final void setTimeout(HttpTimeout.BuilderImpl timeout) {
            this.timeout = timeout != null ? timeout.build() : null;
        }

        @Override
        public final Builder timeout(HttpTimeout timeout) {
            this.timeout = timeout;
            return this;
        }

        public HttpRoute build() {
            return new HttpRoute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HttpRoute> {
        public Builder action(HttpRouteAction var1);

        default public Builder action(Consumer<HttpRouteAction.Builder> action) {
            return this.action((HttpRouteAction)((HttpRouteAction.Builder)HttpRouteAction.builder().applyMutation(action)).build());
        }

        public Builder match(HttpRouteMatch var1);

        default public Builder match(Consumer<HttpRouteMatch.Builder> match) {
            return this.match((HttpRouteMatch)((HttpRouteMatch.Builder)HttpRouteMatch.builder().applyMutation(match)).build());
        }

        public Builder retryPolicy(HttpRetryPolicy var1);

        default public Builder retryPolicy(Consumer<HttpRetryPolicy.Builder> retryPolicy) {
            return this.retryPolicy((HttpRetryPolicy)((HttpRetryPolicy.Builder)HttpRetryPolicy.builder().applyMutation(retryPolicy)).build());
        }

        public Builder timeout(HttpTimeout var1);

        default public Builder timeout(Consumer<HttpTimeout.Builder> timeout) {
            return this.timeout((HttpTimeout)((HttpTimeout.Builder)HttpTimeout.builder().applyMutation(timeout)).build());
        }
    }
}

