/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateApplicationRequest extends ApplicationInsightsRequest implements
        ToCopyableBuilder<CreateApplicationRequest.Builder, CreateApplicationRequest> {
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceGroupName").getter(getter(CreateApplicationRequest::resourceGroupName))
            .setter(setter(Builder::resourceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()).build();

    private static final SdkField<Boolean> OPS_CENTER_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("OpsCenterEnabled").getter(getter(CreateApplicationRequest::opsCenterEnabled))
            .setter(setter(Builder::opsCenterEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsCenterEnabled").build()).build();

    private static final SdkField<Boolean> CWE_MONITOR_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CWEMonitorEnabled").getter(getter(CreateApplicationRequest::cweMonitorEnabled))
            .setter(setter(Builder::cweMonitorEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CWEMonitorEnabled").build()).build();

    private static final SdkField<String> OPS_ITEM_SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpsItemSNSTopicArn").getter(getter(CreateApplicationRequest::opsItemSNSTopicArn))
            .setter(setter(Builder::opsItemSNSTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemSNSTopicArn").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateApplicationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> AUTO_CONFIG_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoConfigEnabled").getter(getter(CreateApplicationRequest::autoConfigEnabled))
            .setter(setter(Builder::autoConfigEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoConfigEnabled").build()).build();

    private static final SdkField<Boolean> AUTO_CREATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoCreate").getter(getter(CreateApplicationRequest::autoCreate)).setter(setter(Builder::autoCreate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoCreate").build()).build();

    private static final SdkField<String> GROUPING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupingType").getter(getter(CreateApplicationRequest::groupingTypeAsString))
            .setter(setter(Builder::groupingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupingType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_NAME_FIELD,
            OPS_CENTER_ENABLED_FIELD, CWE_MONITOR_ENABLED_FIELD, OPS_ITEM_SNS_TOPIC_ARN_FIELD, TAGS_FIELD,
            AUTO_CONFIG_ENABLED_FIELD, AUTO_CREATE_FIELD, GROUPING_TYPE_FIELD));

    private final String resourceGroupName;

    private final Boolean opsCenterEnabled;

    private final Boolean cweMonitorEnabled;

    private final String opsItemSNSTopicArn;

    private final List<Tag> tags;

    private final Boolean autoConfigEnabled;

    private final Boolean autoCreate;

    private final String groupingType;

    private CreateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.resourceGroupName = builder.resourceGroupName;
        this.opsCenterEnabled = builder.opsCenterEnabled;
        this.cweMonitorEnabled = builder.cweMonitorEnabled;
        this.opsItemSNSTopicArn = builder.opsItemSNSTopicArn;
        this.tags = builder.tags;
        this.autoConfigEnabled = builder.autoConfigEnabled;
        this.autoCreate = builder.autoCreate;
        this.groupingType = builder.groupingType;
    }

    /**
     * <p>
     * The name of the resource group.
     * </p>
     * 
     * @return The name of the resource group.
     */
    public final String resourceGroupName() {
        return resourceGroupName;
    }

    /**
     * <p>
     * When set to <code>true</code>, creates opsItems for any problems detected on an application.
     * </p>
     * 
     * @return When set to <code>true</code>, creates opsItems for any problems detected on an application.
     */
    public final Boolean opsCenterEnabled() {
        return opsCenterEnabled;
    }

    /**
     * <p>
     * Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as
     * <code>instance terminated</code>, <code>failed deployment</code>, and others.
     * </p>
     * 
     * @return Indicates whether Application Insights can listen to CloudWatch events for the application resources,
     *         such as <code>instance terminated</code>, <code>failed deployment</code>, and others.
     */
    public final Boolean cweMonitorEnabled() {
        return cweMonitorEnabled;
    }

    /**
     * <p>
     * The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to receive
     * notifications for updates to the opsItem.
     * </p>
     * 
     * @return The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to
     *         receive notifications for updates to the opsItem.
     */
    public final String opsItemSNSTopicArn() {
        return opsItemSNSTopicArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of tags to add to the application. tag key (<code>Key</code>) and an associated tag value (
     * <code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256
     * characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return List of tags to add to the application. tag key (<code>Key</code>) and an associated tag value (
     *         <code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value
     *         is 256 characters.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Indicates whether Application Insights automatically configures unmonitored resources in the resource group.
     * </p>
     * 
     * @return Indicates whether Application Insights automatically configures unmonitored resources in the resource
     *         group.
     */
    public final Boolean autoConfigEnabled() {
        return autoConfigEnabled;
    }

    /**
     * <p>
     * Configures all of the resources in the resource group by applying the recommended configurations.
     * </p>
     * 
     * @return Configures all of the resources in the resource group by applying the recommended configurations.
     */
    public final Boolean autoCreate() {
        return autoCreate;
    }

    /**
     * <p>
     * Application Insights can create applications based on a resource group or on an account. To create an
     * account-based application using all of the resources in the account, set this parameter to
     * <code>ACCOUNT_BASED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupingType} will
     * return {@link GroupingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupingTypeAsString}.
     * </p>
     * 
     * @return Application Insights can create applications based on a resource group or on an account. To create an
     *         account-based application using all of the resources in the account, set this parameter to
     *         <code>ACCOUNT_BASED</code>.
     * @see GroupingType
     */
    public final GroupingType groupingType() {
        return GroupingType.fromValue(groupingType);
    }

    /**
     * <p>
     * Application Insights can create applications based on a resource group or on an account. To create an
     * account-based application using all of the resources in the account, set this parameter to
     * <code>ACCOUNT_BASED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupingType} will
     * return {@link GroupingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupingTypeAsString}.
     * </p>
     * 
     * @return Application Insights can create applications based on a resource group or on an account. To create an
     *         account-based application using all of the resources in the account, set this parameter to
     *         <code>ACCOUNT_BASED</code>.
     * @see GroupingType
     */
    public final String groupingTypeAsString() {
        return groupingType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(opsCenterEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(cweMonitorEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(opsItemSNSTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(autoConfigEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(autoCreate());
        hashCode = 31 * hashCode + Objects.hashCode(groupingTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest) obj;
        return Objects.equals(resourceGroupName(), other.resourceGroupName())
                && Objects.equals(opsCenterEnabled(), other.opsCenterEnabled())
                && Objects.equals(cweMonitorEnabled(), other.cweMonitorEnabled())
                && Objects.equals(opsItemSNSTopicArn(), other.opsItemSNSTopicArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(autoConfigEnabled(), other.autoConfigEnabled())
                && Objects.equals(autoCreate(), other.autoCreate())
                && Objects.equals(groupingTypeAsString(), other.groupingTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateApplicationRequest").add("ResourceGroupName", resourceGroupName())
                .add("OpsCenterEnabled", opsCenterEnabled()).add("CWEMonitorEnabled", cweMonitorEnabled())
                .add("OpsItemSNSTopicArn", opsItemSNSTopicArn()).add("Tags", hasTags() ? tags() : null)
                .add("AutoConfigEnabled", autoConfigEnabled()).add("AutoCreate", autoCreate())
                .add("GroupingType", groupingTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceGroupName":
            return Optional.ofNullable(clazz.cast(resourceGroupName()));
        case "OpsCenterEnabled":
            return Optional.ofNullable(clazz.cast(opsCenterEnabled()));
        case "CWEMonitorEnabled":
            return Optional.ofNullable(clazz.cast(cweMonitorEnabled()));
        case "OpsItemSNSTopicArn":
            return Optional.ofNullable(clazz.cast(opsItemSNSTopicArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "AutoConfigEnabled":
            return Optional.ofNullable(clazz.cast(autoConfigEnabled()));
        case "AutoCreate":
            return Optional.ofNullable(clazz.cast(autoCreate()));
        case "GroupingType":
            return Optional.ofNullable(clazz.cast(groupingTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationRequest, T> g) {
        return obj -> g.apply((CreateApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationInsightsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateApplicationRequest> {
        /**
         * <p>
         * The name of the resource group.
         * </p>
         * 
         * @param resourceGroupName
         *        The name of the resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroupName(String resourceGroupName);

        /**
         * <p>
         * When set to <code>true</code>, creates opsItems for any problems detected on an application.
         * </p>
         * 
         * @param opsCenterEnabled
         *        When set to <code>true</code>, creates opsItems for any problems detected on an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opsCenterEnabled(Boolean opsCenterEnabled);

        /**
         * <p>
         * Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as
         * <code>instance terminated</code>, <code>failed deployment</code>, and others.
         * </p>
         * 
         * @param cweMonitorEnabled
         *        Indicates whether Application Insights can listen to CloudWatch events for the application resources,
         *        such as <code>instance terminated</code>, <code>failed deployment</code>, and others.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cweMonitorEnabled(Boolean cweMonitorEnabled);

        /**
         * <p>
         * The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you to
         * receive notifications for updates to the opsItem.
         * </p>
         * 
         * @param opsItemSNSTopicArn
         *        The SNS topic provided to Application Insights that is associated to the created opsItem. Allows you
         *        to receive notifications for updates to the opsItem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opsItemSNSTopicArn(String opsItemSNSTopicArn);

        /**
         * <p>
         * List of tags to add to the application. tag key (<code>Key</code>) and an associated tag value (
         * <code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value is
         * 256 characters.
         * </p>
         * 
         * @param tags
         *        List of tags to add to the application. tag key (<code>Key</code>) and an associated tag value (
         *        <code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag
         *        value is 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * List of tags to add to the application. tag key (<code>Key</code>) and an associated tag value (
         * <code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value is
         * 256 characters.
         * </p>
         * 
         * @param tags
         *        List of tags to add to the application. tag key (<code>Key</code>) and an associated tag value (
         *        <code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag
         *        value is 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * List of tags to add to the application. tag key (<code>Key</code>) and an associated tag value (
         * <code>Value</code>). The maximum length of a tag key is 128 characters. The maximum length of a tag value is
         * 256 characters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationinsights.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.applicationinsights.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationinsights.model.Tag.Builder#build()} is called immediately
         * and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationinsights.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Indicates whether Application Insights automatically configures unmonitored resources in the resource group.
         * </p>
         * 
         * @param autoConfigEnabled
         *        Indicates whether Application Insights automatically configures unmonitored resources in the resource
         *        group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoConfigEnabled(Boolean autoConfigEnabled);

        /**
         * <p>
         * Configures all of the resources in the resource group by applying the recommended configurations.
         * </p>
         * 
         * @param autoCreate
         *        Configures all of the resources in the resource group by applying the recommended configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoCreate(Boolean autoCreate);

        /**
         * <p>
         * Application Insights can create applications based on a resource group or on an account. To create an
         * account-based application using all of the resources in the account, set this parameter to
         * <code>ACCOUNT_BASED</code>.
         * </p>
         * 
         * @param groupingType
         *        Application Insights can create applications based on a resource group or on an account. To create an
         *        account-based application using all of the resources in the account, set this parameter to
         *        <code>ACCOUNT_BASED</code>.
         * @see GroupingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupingType
         */
        Builder groupingType(String groupingType);

        /**
         * <p>
         * Application Insights can create applications based on a resource group or on an account. To create an
         * account-based application using all of the resources in the account, set this parameter to
         * <code>ACCOUNT_BASED</code>.
         * </p>
         * 
         * @param groupingType
         *        Application Insights can create applications based on a resource group or on an account. To create an
         *        account-based application using all of the resources in the account, set this parameter to
         *        <code>ACCOUNT_BASED</code>.
         * @see GroupingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupingType
         */
        Builder groupingType(GroupingType groupingType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationInsightsRequest.BuilderImpl implements Builder {
        private String resourceGroupName;

        private Boolean opsCenterEnabled;

        private Boolean cweMonitorEnabled;

        private String opsItemSNSTopicArn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Boolean autoConfigEnabled;

        private Boolean autoCreate;

        private String groupingType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationRequest model) {
            super(model);
            resourceGroupName(model.resourceGroupName);
            opsCenterEnabled(model.opsCenterEnabled);
            cweMonitorEnabled(model.cweMonitorEnabled);
            opsItemSNSTopicArn(model.opsItemSNSTopicArn);
            tags(model.tags);
            autoConfigEnabled(model.autoConfigEnabled);
            autoCreate(model.autoCreate);
            groupingType(model.groupingType);
        }

        public final String getResourceGroupName() {
            return resourceGroupName;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final Boolean getOpsCenterEnabled() {
            return opsCenterEnabled;
        }

        public final void setOpsCenterEnabled(Boolean opsCenterEnabled) {
            this.opsCenterEnabled = opsCenterEnabled;
        }

        @Override
        public final Builder opsCenterEnabled(Boolean opsCenterEnabled) {
            this.opsCenterEnabled = opsCenterEnabled;
            return this;
        }

        public final Boolean getCweMonitorEnabled() {
            return cweMonitorEnabled;
        }

        public final void setCweMonitorEnabled(Boolean cweMonitorEnabled) {
            this.cweMonitorEnabled = cweMonitorEnabled;
        }

        @Override
        public final Builder cweMonitorEnabled(Boolean cweMonitorEnabled) {
            this.cweMonitorEnabled = cweMonitorEnabled;
            return this;
        }

        public final String getOpsItemSNSTopicArn() {
            return opsItemSNSTopicArn;
        }

        public final void setOpsItemSNSTopicArn(String opsItemSNSTopicArn) {
            this.opsItemSNSTopicArn = opsItemSNSTopicArn;
        }

        @Override
        public final Builder opsItemSNSTopicArn(String opsItemSNSTopicArn) {
            this.opsItemSNSTopicArn = opsItemSNSTopicArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getAutoConfigEnabled() {
            return autoConfigEnabled;
        }

        public final void setAutoConfigEnabled(Boolean autoConfigEnabled) {
            this.autoConfigEnabled = autoConfigEnabled;
        }

        @Override
        public final Builder autoConfigEnabled(Boolean autoConfigEnabled) {
            this.autoConfigEnabled = autoConfigEnabled;
            return this;
        }

        public final Boolean getAutoCreate() {
            return autoCreate;
        }

        public final void setAutoCreate(Boolean autoCreate) {
            this.autoCreate = autoCreate;
        }

        @Override
        public final Builder autoCreate(Boolean autoCreate) {
            this.autoCreate = autoCreate;
            return this;
        }

        public final String getGroupingType() {
            return groupingType;
        }

        public final void setGroupingType(String groupingType) {
            this.groupingType = groupingType;
        }

        @Override
        public final Builder groupingType(String groupingType) {
            this.groupingType = groupingType;
            return this;
        }

        @Override
        public final Builder groupingType(GroupingType groupingType) {
            this.groupingType(groupingType == null ? null : groupingType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationRequest build() {
            return new CreateApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
