/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.applicationdiscovery.ApplicationDiscoveryAsyncClient;
import software.amazon.awssdk.services.applicationdiscovery.ApplicationDiscoveryAsyncClientBuilder;
import software.amazon.awssdk.services.applicationdiscovery.ApplicationDiscoveryServiceClientConfiguration;
import software.amazon.awssdk.services.applicationdiscovery.DefaultApplicationDiscoveryAsyncClient;
import software.amazon.awssdk.services.applicationdiscovery.DefaultApplicationDiscoveryBaseClientBuilder;
import software.amazon.awssdk.services.applicationdiscovery.endpoints.ApplicationDiscoveryEndpointProvider;

@SdkInternalApi
final class DefaultApplicationDiscoveryAsyncClientBuilder
extends DefaultApplicationDiscoveryBaseClientBuilder<ApplicationDiscoveryAsyncClientBuilder, ApplicationDiscoveryAsyncClient>
implements ApplicationDiscoveryAsyncClientBuilder {
    DefaultApplicationDiscoveryAsyncClientBuilder() {
    }

    @Override
    public DefaultApplicationDiscoveryAsyncClientBuilder endpointProvider(ApplicationDiscoveryEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ApplicationDiscoveryAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultApplicationDiscoveryAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        ApplicationDiscoveryServiceClientConfiguration serviceClientConfiguration = ApplicationDiscoveryServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultApplicationDiscoveryAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

