/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterScalableTargetRequest extends ApplicationAutoScalingRequest implements
        ToCopyableBuilder<RegisterScalableTargetRequest.Builder, RegisterScalableTargetRequest> {
    private static final SdkField<String> SERVICE_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceNamespace").getter(getter(RegisterScalableTargetRequest::serviceNamespaceAsString))
            .setter(setter(Builder::serviceNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNamespace").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(RegisterScalableTargetRequest::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> SCALABLE_DIMENSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScalableDimension").getter(getter(RegisterScalableTargetRequest::scalableDimensionAsString))
            .setter(setter(Builder::scalableDimension))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalableDimension").build()).build();

    private static final SdkField<Integer> MIN_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinCapacity").getter(getter(RegisterScalableTargetRequest::minCapacity))
            .setter(setter(Builder::minCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinCapacity").build()).build();

    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxCapacity").getter(getter(RegisterScalableTargetRequest::maxCapacity))
            .setter(setter(Builder::maxCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleARN").getter(getter(RegisterScalableTargetRequest::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final SdkField<SuspendedState> SUSPENDED_STATE_FIELD = SdkField
            .<SuspendedState> builder(MarshallingType.SDK_POJO).memberName("SuspendedState")
            .getter(getter(RegisterScalableTargetRequest::suspendedState)).setter(setter(Builder::suspendedState))
            .constructor(SuspendedState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuspendedState").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(RegisterScalableTargetRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAMESPACE_FIELD,
            RESOURCE_ID_FIELD, SCALABLE_DIMENSION_FIELD, MIN_CAPACITY_FIELD, MAX_CAPACITY_FIELD, ROLE_ARN_FIELD,
            SUSPENDED_STATE_FIELD, TAGS_FIELD));

    private final String serviceNamespace;

    private final String resourceId;

    private final String scalableDimension;

    private final Integer minCapacity;

    private final Integer maxCapacity;

    private final String roleARN;

    private final SuspendedState suspendedState;

    private final Map<String, String> tags;

    private RegisterScalableTargetRequest(BuilderImpl builder) {
        super(builder);
        this.serviceNamespace = builder.serviceNamespace;
        this.resourceId = builder.resourceId;
        this.scalableDimension = builder.scalableDimension;
        this.minCapacity = builder.minCapacity;
        this.maxCapacity = builder.maxCapacity;
        this.roleARN = builder.roleARN;
        this.suspendedState = builder.suspendedState;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The namespace of the Amazon Web Services service that provides the resource. For a resource provided by your own
     * application or service, use <code>custom-resource</code> instead.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceNamespace}
     * will return {@link ServiceNamespace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #serviceNamespaceAsString}.
     * </p>
     * 
     * @return The namespace of the Amazon Web Services service that provides the resource. For a resource provided by
     *         your own application or service, use <code>custom-resource</code> instead.
     * @see ServiceNamespace
     */
    public final ServiceNamespace serviceNamespace() {
        return ServiceNamespace.fromValue(serviceNamespace);
    }

    /**
     * <p>
     * The namespace of the Amazon Web Services service that provides the resource. For a resource provided by your own
     * application or service, use <code>custom-resource</code> instead.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceNamespace}
     * will return {@link ServiceNamespace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #serviceNamespaceAsString}.
     * </p>
     * 
     * @return The namespace of the Amazon Web Services service that provides the resource. For a resource provided by
     *         your own application or service, use <code>custom-resource</code> instead.
     * @see ServiceNamespace
     */
    public final String serviceNamespaceAsString() {
        return serviceNamespace;
    }

    /**
     * <p>
     * The identifier of the resource that is associated with the scalable target. This string consists of the resource
     * type and unique identifier.
     * </p>
     * <ul>
     * <li>
     * <p>
     * ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and service
     * name. Example: <code>service/default/sample-webapp</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet
     * request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and
     * instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name.
     * Example: <code>fleet/sample-fleet</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name. Example:
     * <code>table/my-table</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the index
     * name. Example: <code>table/my-table/index/my-table-index</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name.
     * Example: <code>cluster:my-db-cluster</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the resource
     * ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Custom resources are not supported with a resource type. This parameter must specify the <code>OutputValue</code>
     * from the CloudFormation template stack used to access the resources. The unique identifier is defined by the
     * service provider. More information is available in our <a
     * href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified using
     * the endpoint ARN. Example:
     * <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using the
     * endpoint ARN. Example: <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the
     * function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example:
     * <code>function:my-function:prod</code> or <code>function:my-function:1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name.
     * Example: <code>keyspace/mykeyspace/table/mytable</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example:
     * <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique
     * identifier is the replication group name. Example: <code>replication-group/mycluster</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name.
     * Example: <code>cluster:mycluster</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * SageMaker Serverless endpoint - The resource type is <code>variant</code> and the unique identifier is the
     * resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * SageMaker inference component - The resource type is <code>inference-component</code> and the unique identifier
     * is the resource ID. Example: <code>inference-component/my-inference-component</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier of the resource that is associated with the scalable target. This string consists of the
     *         resource type and unique identifier.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and
     *         service name. Example: <code>service/default/sample-webapp</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot
     *         Fleet request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID
     *         and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet
     *         name. Example: <code>fleet/sample-fleet</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name.
     *         Example: <code>table/my-table</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is
     *         the index name. Example: <code>table/my-table/index/my-table-index</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster
     *         name. Example: <code>cluster:my-db-cluster</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the
     *         resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Custom resources are not supported with a resource type. This parameter must specify the
     *         <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique
     *         identifier is defined by the service provider. More information is available in our <a
     *         href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Comprehend document classification endpoint - The resource type and unique identifier are
     *         specified using the endpoint ARN. Example:
     *         <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified
     *         using the endpoint ARN. Example:
     *         <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is
     *         the function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example:
     *         <code>function:my-function:prod</code> or <code>function:my-function:1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table
     *         name. Example: <code>keyspace/mykeyspace/table/mytable</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN.
     *         Example:
     *         <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique
     *         identifier is the replication group name. Example: <code>replication-group/mycluster</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster
     *         name. Example: <code>cluster:mycluster</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SageMaker Serverless endpoint - The resource type is <code>variant</code> and the unique identifier is
     *         the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SageMaker inference component - The resource type is <code>inference-component</code> and the unique
     *         identifier is the resource ID. Example: <code>inference-component/my-inference-component</code>.
     *         </p>
     *         </li>
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The scalable dimension associated with the scalable target. This string consists of the service namespace,
     * resource type, and scaling property.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary
     * index.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary
     * index.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for
     * Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for a SageMaker model endpoint
     * variant.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by
     * your own application or service.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an
     * Amazon Comprehend document classification endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for an
     * Amazon Comprehend entity recognizer endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon MSK
     * cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache
     * replication group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon
     * ElastiCache replication group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sagemaker:variant:DesiredProvisionedConcurrency</code> - The provisioned concurrency for a SageMaker
     * Serverless endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sagemaker:inference-component:DesiredCopyCount</code> - The number of copies across an endpoint for a
     * SageMaker inference component.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scalableDimension}
     * will return {@link ScalableDimension#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scalableDimensionAsString}.
     * </p>
     * 
     * @return The scalable dimension associated with the scalable target. This string consists of the service
     *         namespace, resource type, and scaling property.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global
     *         secondary index.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global
     *         secondary index.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster.
     *         Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for a SageMaker model
     *         endpoint variant.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource
     *         provided by your own application or service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference
     *         units for an Amazon Comprehend document classification endpoint.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units
     *         for an Amazon Comprehend entity recognizer endpoint.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces
     *         table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces
     *         table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an
     *         Amazon MSK cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon
     *         ElastiCache replication group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon
     *         ElastiCache replication group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB
     *         cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sagemaker:variant:DesiredProvisionedConcurrency</code> - The provisioned concurrency for a
     *         SageMaker Serverless endpoint.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sagemaker:inference-component:DesiredCopyCount</code> - The number of copies across an endpoint for
     *         a SageMaker inference component.
     *         </p>
     *         </li>
     * @see ScalableDimension
     */
    public final ScalableDimension scalableDimension() {
        return ScalableDimension.fromValue(scalableDimension);
    }

    /**
     * <p>
     * The scalable dimension associated with the scalable target. This string consists of the service namespace,
     * resource type, and scaling property.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary
     * index.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global secondary
     * index.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available for
     * Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for a SageMaker model endpoint
     * variant.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by
     * your own application or service.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units for an
     * Amazon Comprehend document classification endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for an
     * Amazon Comprehend entity recognizer endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon MSK
     * cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache
     * replication group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon
     * ElastiCache replication group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sagemaker:variant:DesiredProvisionedConcurrency</code> - The provisioned concurrency for a SageMaker
     * Serverless endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sagemaker:inference-component:DesiredCopyCount</code> - The number of copies across an endpoint for a
     * SageMaker inference component.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scalableDimension}
     * will return {@link ScalableDimension#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scalableDimensionAsString}.
     * </p>
     * 
     * @return The scalable dimension associated with the scalable target. This string consists of the service
     *         namespace, resource type, and scaling property.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global
     *         secondary index.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global
     *         secondary index.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster.
     *         Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for a SageMaker model
     *         endpoint variant.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource
     *         provided by your own application or service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference
     *         units for an Amazon Comprehend document classification endpoint.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units
     *         for an Amazon Comprehend entity recognizer endpoint.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces
     *         table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces
     *         table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an
     *         Amazon MSK cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon
     *         ElastiCache replication group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon
     *         ElastiCache replication group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB
     *         cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sagemaker:variant:DesiredProvisionedConcurrency</code> - The provisioned concurrency for a
     *         SageMaker Serverless endpoint.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sagemaker:inference-component:DesiredCopyCount</code> - The number of copies across an endpoint for
     *         a SageMaker inference component.
     *         </p>
     *         </li>
     * @see ScalableDimension
     */
    public final String scalableDimensionAsString() {
        return scalableDimension;
    }

    /**
     * <p>
     * The minimum value that you plan to scale in to. When a scaling policy is in effect, Application Auto Scaling can
     * scale in (contract) as needed to the minimum capacity limit in response to changing demand. This property is
     * required when registering a new scalable target.
     * </p>
     * <p>
     * For the following resources, the minimum value allowed is 0.
     * </p>
     * <ul>
     * <li>
     * <p>
     * AppStream 2.0 fleets
     * </p>
     * </li>
     * <li>
     * <p>
     * Aurora DB clusters
     * </p>
     * </li>
     * <li>
     * <p>
     * ECS services
     * </p>
     * </li>
     * <li>
     * <p>
     * EMR clusters
     * </p>
     * </li>
     * <li>
     * <p>
     * Lambda provisioned concurrency
     * </p>
     * </li>
     * <li>
     * <p>
     * SageMaker endpoint variants
     * </p>
     * </li>
     * <li>
     * <p>
     * SageMaker Serverless endpoint provisioned concurrency
     * </p>
     * </li>
     * <li>
     * <p>
     * Spot Fleets
     * </p>
     * </li>
     * <li>
     * <p>
     * custom resources
     * </p>
     * </li>
     * </ul>
     * <p>
     * It's strongly recommended that you specify a value greater than 0. A value greater than 0 means that data points
     * are continuously reported to CloudWatch that scaling policies can use to scale on a metric like average CPU
     * utilization.
     * </p>
     * <p>
     * For all other resources, the minimum allowed value depends on the type of resource that you are using. If you
     * provide a value that is lower than what a resource can accept, an error occurs. In which case, the error message
     * will provide the minimum value that the resource can accept.
     * </p>
     * 
     * @return The minimum value that you plan to scale in to. When a scaling policy is in effect, Application Auto
     *         Scaling can scale in (contract) as needed to the minimum capacity limit in response to changing demand.
     *         This property is required when registering a new scalable target.</p>
     *         <p>
     *         For the following resources, the minimum value allowed is 0.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         AppStream 2.0 fleets
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Aurora DB clusters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ECS services
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EMR clusters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Lambda provisioned concurrency
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SageMaker endpoint variants
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SageMaker Serverless endpoint provisioned concurrency
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Spot Fleets
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         custom resources
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         It's strongly recommended that you specify a value greater than 0. A value greater than 0 means that data
     *         points are continuously reported to CloudWatch that scaling policies can use to scale on a metric like
     *         average CPU utilization.
     *         </p>
     *         <p>
     *         For all other resources, the minimum allowed value depends on the type of resource that you are using. If
     *         you provide a value that is lower than what a resource can accept, an error occurs. In which case, the
     *         error message will provide the minimum value that the resource can accept.
     */
    public final Integer minCapacity() {
        return minCapacity;
    }

    /**
     * <p>
     * The maximum value that you plan to scale out to. When a scaling policy is in effect, Application Auto Scaling can
     * scale out (expand) as needed to the maximum capacity limit in response to changing demand. This property is
     * required when registering a new scalable target.
     * </p>
     * <p>
     * Although you can specify a large maximum capacity, note that service quotas might impose lower limits. Each
     * service has its own default quotas for the maximum capacity of the resource. If you want to specify a higher
     * limit, you can request an increase. For more information, consult the documentation for that service. For
     * information about the default quotas for each service, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-service-information.html">Service endpoints and
     * quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @return The maximum value that you plan to scale out to. When a scaling policy is in effect, Application Auto
     *         Scaling can scale out (expand) as needed to the maximum capacity limit in response to changing demand.
     *         This property is required when registering a new scalable target.</p>
     *         <p>
     *         Although you can specify a large maximum capacity, note that service quotas might impose lower limits.
     *         Each service has its own default quotas for the maximum capacity of the resource. If you want to specify
     *         a higher limit, you can request an increase. For more information, consult the documentation for that
     *         service. For information about the default quotas for each service, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-service-information.html">Service endpoints and
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     */
    public final Integer maxCapacity() {
        return maxCapacity;
    }

    /**
     * <p>
     * This parameter is required for services that do not support service-linked roles (such as Amazon EMR), and it
     * must specify the ARN of an IAM role that allows Application Auto Scaling to modify the scalable target on your
     * behalf.
     * </p>
     * <p>
     * If the service supports service-linked roles, Application Auto Scaling uses a service-linked role, which it
     * creates if it does not yet exist. For more information, see <a href=
     * "https://docs.aws.amazon.com/autoscaling/application/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-roles"
     * >Application Auto Scaling IAM roles</a>.
     * </p>
     * 
     * @return This parameter is required for services that do not support service-linked roles (such as Amazon EMR),
     *         and it must specify the ARN of an IAM role that allows Application Auto Scaling to modify the scalable
     *         target on your behalf. </p>
     *         <p>
     *         If the service supports service-linked roles, Application Auto Scaling uses a service-linked role, which
     *         it creates if it does not yet exist. For more information, see <a href=
     *         "https://docs.aws.amazon.com/autoscaling/application/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-roles"
     *         >Application Auto Scaling IAM roles</a>.
     */
    public final String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * An embedded object that contains attributes and attribute values that are used to suspend and resume automatic
     * scaling. Setting the value of an attribute to <code>true</code> suspends the specified scaling activities.
     * Setting it to <code>false</code> (default) resumes the specified scaling activities.
     * </p>
     * <p>
     * <b>Suspension Outcomes</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>DynamicScalingInSuspended</code>, while a suspension is in effect, all scale-in activities that are
     * triggered by a scaling policy are suspended.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>DynamicScalingOutSuspended</code>, while a suspension is in effect, all scale-out activities that are
     * triggered by a scaling policy are suspended.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>ScheduledScalingSuspended</code>, while a suspension is in effect, all scaling activities that involve
     * scheduled actions are suspended.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-suspend-resume-scaling.html"
     * >Suspending and resuming scaling</a> in the <i>Application Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return An embedded object that contains attributes and attribute values that are used to suspend and resume
     *         automatic scaling. Setting the value of an attribute to <code>true</code> suspends the specified scaling
     *         activities. Setting it to <code>false</code> (default) resumes the specified scaling activities. </p>
     *         <p>
     *         <b>Suspension Outcomes</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For <code>DynamicScalingInSuspended</code>, while a suspension is in effect, all scale-in activities that
     *         are triggered by a scaling policy are suspended.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <code>DynamicScalingOutSuspended</code>, while a suspension is in effect, all scale-out activities
     *         that are triggered by a scaling policy are suspended.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <code>ScheduledScalingSuspended</code>, while a suspension is in effect, all scaling activities that
     *         involve scheduled actions are suspended.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-suspend-resume-scaling.html"
     *         >Suspending and resuming scaling</a> in the <i>Application Auto Scaling User Guide</i>.
     */
    public final SuspendedState suspendedState() {
        return suspendedState;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Assigns one or more tags to the scalable target. Use this parameter to tag the scalable target when it is
     * created. To tag an existing scalable target, use the <a>TagResource</a> operation.
     * </p>
     * <p>
     * Each tag consists of a tag key and a tag value. Both the tag key and the tag value are required. You cannot have
     * more than one tag on a scalable target with the same tag key.
     * </p>
     * <p>
     * Use tags to control access to a scalable target. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/application/userguide/resource-tagging-support.html">Tagging
     * support for Application Auto Scaling</a> in the <i>Application Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Assigns one or more tags to the scalable target. Use this parameter to tag the scalable target when it is
     *         created. To tag an existing scalable target, use the <a>TagResource</a> operation.</p>
     *         <p>
     *         Each tag consists of a tag key and a tag value. Both the tag key and the tag value are required. You
     *         cannot have more than one tag on a scalable target with the same tag key.
     *         </p>
     *         <p>
     *         Use tags to control access to a scalable target. For more information, see <a
     *         href="https://docs.aws.amazon.com/autoscaling/application/userguide/resource-tagging-support.html"
     *         >Tagging support for Application Auto Scaling</a> in the <i>Application Auto Scaling User Guide</i>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceNamespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(scalableDimensionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(minCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(suspendedState());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterScalableTargetRequest)) {
            return false;
        }
        RegisterScalableTargetRequest other = (RegisterScalableTargetRequest) obj;
        return Objects.equals(serviceNamespaceAsString(), other.serviceNamespaceAsString())
                && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(scalableDimensionAsString(), other.scalableDimensionAsString())
                && Objects.equals(minCapacity(), other.minCapacity()) && Objects.equals(maxCapacity(), other.maxCapacity())
                && Objects.equals(roleARN(), other.roleARN()) && Objects.equals(suspendedState(), other.suspendedState())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterScalableTargetRequest").add("ServiceNamespace", serviceNamespaceAsString())
                .add("ResourceId", resourceId()).add("ScalableDimension", scalableDimensionAsString())
                .add("MinCapacity", minCapacity()).add("MaxCapacity", maxCapacity()).add("RoleARN", roleARN())
                .add("SuspendedState", suspendedState()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceNamespace":
            return Optional.ofNullable(clazz.cast(serviceNamespaceAsString()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ScalableDimension":
            return Optional.ofNullable(clazz.cast(scalableDimensionAsString()));
        case "MinCapacity":
            return Optional.ofNullable(clazz.cast(minCapacity()));
        case "MaxCapacity":
            return Optional.ofNullable(clazz.cast(maxCapacity()));
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "SuspendedState":
            return Optional.ofNullable(clazz.cast(suspendedState()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterScalableTargetRequest, T> g) {
        return obj -> g.apply((RegisterScalableTargetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationAutoScalingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RegisterScalableTargetRequest> {
        /**
         * <p>
         * The namespace of the Amazon Web Services service that provides the resource. For a resource provided by your
         * own application or service, use <code>custom-resource</code> instead.
         * </p>
         * 
         * @param serviceNamespace
         *        The namespace of the Amazon Web Services service that provides the resource. For a resource provided
         *        by your own application or service, use <code>custom-resource</code> instead.
         * @see ServiceNamespace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceNamespace
         */
        Builder serviceNamespace(String serviceNamespace);

        /**
         * <p>
         * The namespace of the Amazon Web Services service that provides the resource. For a resource provided by your
         * own application or service, use <code>custom-resource</code> instead.
         * </p>
         * 
         * @param serviceNamespace
         *        The namespace of the Amazon Web Services service that provides the resource. For a resource provided
         *        by your own application or service, use <code>custom-resource</code> instead.
         * @see ServiceNamespace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceNamespace
         */
        Builder serviceNamespace(ServiceNamespace serviceNamespace);

        /**
         * <p>
         * The identifier of the resource that is associated with the scalable target. This string consists of the
         * resource type and unique identifier.
         * </p>
         * <ul>
         * <li>
         * <p>
         * ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name and
         * service name. Example: <code>service/default/sample-webapp</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the Spot Fleet
         * request ID. Example: <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster ID and
         * instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet name.
         * Example: <code>fleet/sample-fleet</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name.
         * Example: <code>table/my-table</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is the
         * index name. Example: <code>table/my-table/index/my-table-index</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name.
         * Example: <code>cluster:my-db-cluster</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is the
         * resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Custom resources are not supported with a resource type. This parameter must specify the
         * <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The unique
         * identifier is defined by the service provider. More information is available in our <a
         * href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Comprehend document classification endpoint - The resource type and unique identifier are specified
         * using the endpoint ARN. Example:
         * <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified using
         * the endpoint ARN. Example:
         * <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier is the
         * function name with a function version or alias name suffix that is not <code>$LATEST</code>. Example:
         * <code>function:my-function:prod</code> or <code>function:my-function:1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the table name.
         * Example: <code>keyspace/mykeyspace/table/mytable</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN. Example:
         * <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code>
         * .
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the unique
         * identifier is the replication group name. Example: <code>replication-group/mycluster</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster name.
         * Example: <code>cluster:mycluster</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * SageMaker Serverless endpoint - The resource type is <code>variant</code> and the unique identifier is the
         * resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * SageMaker inference component - The resource type is <code>inference-component</code> and the unique
         * identifier is the resource ID. Example: <code>inference-component/my-inference-component</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceId
         *        The identifier of the resource that is associated with the scalable target. This string consists of
         *        the resource type and unique identifier.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ECS service - The resource type is <code>service</code> and the unique identifier is the cluster name
         *        and service name. Example: <code>service/default/sample-webapp</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Spot Fleet - The resource type is <code>spot-fleet-request</code> and the unique identifier is the
         *        Spot Fleet request ID. Example:
         *        <code>spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EMR cluster - The resource type is <code>instancegroup</code> and the unique identifier is the cluster
         *        ID and instance group ID. Example: <code>instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AppStream 2.0 fleet - The resource type is <code>fleet</code> and the unique identifier is the fleet
         *        name. Example: <code>fleet/sample-fleet</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DynamoDB table - The resource type is <code>table</code> and the unique identifier is the table name.
         *        Example: <code>table/my-table</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DynamoDB global secondary index - The resource type is <code>index</code> and the unique identifier is
         *        the index name. Example: <code>table/my-table/index/my-table-index</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Aurora DB cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster
         *        name. Example: <code>cluster:my-db-cluster</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SageMaker endpoint variant - The resource type is <code>variant</code> and the unique identifier is
         *        the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Custom resources are not supported with a resource type. This parameter must specify the
         *        <code>OutputValue</code> from the CloudFormation template stack used to access the resources. The
         *        unique identifier is defined by the service provider. More information is available in our <a
         *        href="https://github.com/aws/aws-auto-scaling-custom-resource">GitHub repository</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Comprehend document classification endpoint - The resource type and unique identifier are
         *        specified using the endpoint ARN. Example:
         *        <code>arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Comprehend entity recognizer endpoint - The resource type and unique identifier are specified
         *        using the endpoint ARN. Example:
         *        <code>arn:aws:comprehend:us-west-2:123456789012:entity-recognizer-endpoint/EXAMPLE</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Lambda provisioned concurrency - The resource type is <code>function</code> and the unique identifier
         *        is the function name with a function version or alias name suffix that is not <code>$LATEST</code>.
         *        Example: <code>function:my-function:prod</code> or <code>function:my-function:1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Keyspaces table - The resource type is <code>table</code> and the unique identifier is the
         *        table name. Example: <code>keyspace/mykeyspace/table/mytable</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon MSK cluster - The resource type and unique identifier are specified using the cluster ARN.
         *        Example:
         *        <code>arn:aws:kafka:us-east-1:123456789012:cluster/demo-cluster-1/6357e0b2-0e6a-4b86-a0b4-70df934c2e31-5</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon ElastiCache replication group - The resource type is <code>replication-group</code> and the
         *        unique identifier is the replication group name. Example: <code>replication-group/mycluster</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Neptune cluster - The resource type is <code>cluster</code> and the unique identifier is the cluster
         *        name. Example: <code>cluster:mycluster</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SageMaker Serverless endpoint - The resource type is <code>variant</code> and the unique identifier is
         *        the resource ID. Example: <code>endpoint/my-end-point/variant/KMeansClustering</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SageMaker inference component - The resource type is <code>inference-component</code> and the unique
         *        identifier is the resource ID. Example: <code>inference-component/my-inference-component</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The scalable dimension associated with the scalable target. This string consists of the service namespace,
         * resource type, and scaling property.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary
         * index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global
         * secondary index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available
         * for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for a SageMaker model
         * endpoint variant.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by
         * your own application or service.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units
         * for an Amazon Comprehend document classification endpoint.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for
         * an Amazon Comprehend entity recognizer endpoint.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces
         * table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon
         * MSK cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache
         * replication group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon
         * ElastiCache replication group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sagemaker:variant:DesiredProvisionedConcurrency</code> - The provisioned concurrency for a SageMaker
         * Serverless endpoint.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sagemaker:inference-component:DesiredCopyCount</code> - The number of copies across an endpoint for a
         * SageMaker inference component.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scalableDimension
         *        The scalable dimension associated with the scalable target. This string consists of the service
         *        namespace, resource type, and scaling property.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance
         *        Group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global
         *        secondary index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global
         *        secondary index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster.
         *        Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for a SageMaker
         *        model endpoint variant.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource
         *        provided by your own application or service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference
         *        units for an Amazon Comprehend document classification endpoint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference
         *        units for an Amazon Comprehend entity recognizer endpoint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda
         *        function.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces
         *        table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon
         *        Keyspaces table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an
         *        Amazon MSK cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon
         *        ElastiCache replication group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an
         *        Amazon ElastiCache replication group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB
         *        cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sagemaker:variant:DesiredProvisionedConcurrency</code> - The provisioned concurrency for a
         *        SageMaker Serverless endpoint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sagemaker:inference-component:DesiredCopyCount</code> - The number of copies across an endpoint
         *        for a SageMaker inference component.
         *        </p>
         *        </li>
         * @see ScalableDimension
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalableDimension
         */
        Builder scalableDimension(String scalableDimension);

        /**
         * <p>
         * The scalable dimension associated with the scalable target. This string consists of the service namespace,
         * resource type, and scaling property.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance Group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global secondary
         * index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global
         * secondary index.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster. Available
         * for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for a SageMaker model
         * endpoint variant.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource provided by
         * your own application or service.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference units
         * for an Amazon Comprehend document classification endpoint.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference units for
         * an Amazon Comprehend entity recognizer endpoint.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda function.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon Keyspaces
         * table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an Amazon
         * MSK cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon ElastiCache
         * replication group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an Amazon
         * ElastiCache replication group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sagemaker:variant:DesiredProvisionedConcurrency</code> - The provisioned concurrency for a SageMaker
         * Serverless endpoint.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sagemaker:inference-component:DesiredCopyCount</code> - The number of copies across an endpoint for a
         * SageMaker inference component.
         * </p>
         * </li>
         * </ul>
         * 
         * @param scalableDimension
         *        The scalable dimension associated with the scalable target. This string consists of the service
         *        namespace, resource type, and scaling property.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ecs:service:DesiredCount</code> - The desired task count of an ECS service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elasticmapreduce:instancegroup:InstanceCount</code> - The instance count of an EMR Instance
         *        Group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ec2:spot-fleet-request:TargetCapacity</code> - The target capacity of a Spot Fleet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>appstream:fleet:DesiredCapacity</code> - The desired capacity of an AppStream 2.0 fleet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dynamodb:table:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dynamodb:table:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dynamodb:index:ReadCapacityUnits</code> - The provisioned read capacity for a DynamoDB global
         *        secondary index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dynamodb:index:WriteCapacityUnits</code> - The provisioned write capacity for a DynamoDB global
         *        secondary index.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>rds:cluster:ReadReplicaCount</code> - The count of Aurora Replicas in an Aurora DB cluster.
         *        Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sagemaker:variant:DesiredInstanceCount</code> - The number of EC2 instances for a SageMaker
         *        model endpoint variant.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>custom-resource:ResourceType:Property</code> - The scalable dimension for a custom resource
         *        provided by your own application or service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>comprehend:document-classifier-endpoint:DesiredInferenceUnits</code> - The number of inference
         *        units for an Amazon Comprehend document classification endpoint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>comprehend:entity-recognizer-endpoint:DesiredInferenceUnits</code> - The number of inference
         *        units for an Amazon Comprehend entity recognizer endpoint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>lambda:function:ProvisionedConcurrency</code> - The provisioned concurrency for a Lambda
         *        function.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cassandra:table:ReadCapacityUnits</code> - The provisioned read capacity for an Amazon Keyspaces
         *        table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cassandra:table:WriteCapacityUnits</code> - The provisioned write capacity for an Amazon
         *        Keyspaces table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>kafka:broker-storage:VolumeSize</code> - The provisioned volume size (in GiB) for brokers in an
         *        Amazon MSK cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elasticache:replication-group:NodeGroups</code> - The number of node groups for an Amazon
         *        ElastiCache replication group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>elasticache:replication-group:Replicas</code> - The number of replicas per node group for an
         *        Amazon ElastiCache replication group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>neptune:cluster:ReadReplicaCount</code> - The count of read replicas in an Amazon Neptune DB
         *        cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sagemaker:variant:DesiredProvisionedConcurrency</code> - The provisioned concurrency for a
         *        SageMaker Serverless endpoint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sagemaker:inference-component:DesiredCopyCount</code> - The number of copies across an endpoint
         *        for a SageMaker inference component.
         *        </p>
         *        </li>
         * @see ScalableDimension
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalableDimension
         */
        Builder scalableDimension(ScalableDimension scalableDimension);

        /**
         * <p>
         * The minimum value that you plan to scale in to. When a scaling policy is in effect, Application Auto Scaling
         * can scale in (contract) as needed to the minimum capacity limit in response to changing demand. This property
         * is required when registering a new scalable target.
         * </p>
         * <p>
         * For the following resources, the minimum value allowed is 0.
         * </p>
         * <ul>
         * <li>
         * <p>
         * AppStream 2.0 fleets
         * </p>
         * </li>
         * <li>
         * <p>
         * Aurora DB clusters
         * </p>
         * </li>
         * <li>
         * <p>
         * ECS services
         * </p>
         * </li>
         * <li>
         * <p>
         * EMR clusters
         * </p>
         * </li>
         * <li>
         * <p>
         * Lambda provisioned concurrency
         * </p>
         * </li>
         * <li>
         * <p>
         * SageMaker endpoint variants
         * </p>
         * </li>
         * <li>
         * <p>
         * SageMaker Serverless endpoint provisioned concurrency
         * </p>
         * </li>
         * <li>
         * <p>
         * Spot Fleets
         * </p>
         * </li>
         * <li>
         * <p>
         * custom resources
         * </p>
         * </li>
         * </ul>
         * <p>
         * It's strongly recommended that you specify a value greater than 0. A value greater than 0 means that data
         * points are continuously reported to CloudWatch that scaling policies can use to scale on a metric like
         * average CPU utilization.
         * </p>
         * <p>
         * For all other resources, the minimum allowed value depends on the type of resource that you are using. If you
         * provide a value that is lower than what a resource can accept, an error occurs. In which case, the error
         * message will provide the minimum value that the resource can accept.
         * </p>
         * 
         * @param minCapacity
         *        The minimum value that you plan to scale in to. When a scaling policy is in effect, Application Auto
         *        Scaling can scale in (contract) as needed to the minimum capacity limit in response to changing
         *        demand. This property is required when registering a new scalable target.</p>
         *        <p>
         *        For the following resources, the minimum value allowed is 0.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        AppStream 2.0 fleets
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Aurora DB clusters
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ECS services
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EMR clusters
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Lambda provisioned concurrency
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SageMaker endpoint variants
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SageMaker Serverless endpoint provisioned concurrency
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Spot Fleets
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        custom resources
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        It's strongly recommended that you specify a value greater than 0. A value greater than 0 means that
         *        data points are continuously reported to CloudWatch that scaling policies can use to scale on a metric
         *        like average CPU utilization.
         *        </p>
         *        <p>
         *        For all other resources, the minimum allowed value depends on the type of resource that you are using.
         *        If you provide a value that is lower than what a resource can accept, an error occurs. In which case,
         *        the error message will provide the minimum value that the resource can accept.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minCapacity(Integer minCapacity);

        /**
         * <p>
         * The maximum value that you plan to scale out to. When a scaling policy is in effect, Application Auto Scaling
         * can scale out (expand) as needed to the maximum capacity limit in response to changing demand. This property
         * is required when registering a new scalable target.
         * </p>
         * <p>
         * Although you can specify a large maximum capacity, note that service quotas might impose lower limits. Each
         * service has its own default quotas for the maximum capacity of the resource. If you want to specify a higher
         * limit, you can request an increase. For more information, consult the documentation for that service. For
         * information about the default quotas for each service, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-service-information.html">Service endpoints and
         * quotas</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param maxCapacity
         *        The maximum value that you plan to scale out to. When a scaling policy is in effect, Application Auto
         *        Scaling can scale out (expand) as needed to the maximum capacity limit in response to changing demand.
         *        This property is required when registering a new scalable target.</p>
         *        <p>
         *        Although you can specify a large maximum capacity, note that service quotas might impose lower limits.
         *        Each service has its own default quotas for the maximum capacity of the resource. If you want to
         *        specify a higher limit, you can request an increase. For more information, consult the documentation
         *        for that service. For information about the default quotas for each service, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-service-information.html">Service endpoints
         *        and quotas</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCapacity(Integer maxCapacity);

        /**
         * <p>
         * This parameter is required for services that do not support service-linked roles (such as Amazon EMR), and it
         * must specify the ARN of an IAM role that allows Application Auto Scaling to modify the scalable target on
         * your behalf.
         * </p>
         * <p>
         * If the service supports service-linked roles, Application Auto Scaling uses a service-linked role, which it
         * creates if it does not yet exist. For more information, see <a href=
         * "https://docs.aws.amazon.com/autoscaling/application/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-roles"
         * >Application Auto Scaling IAM roles</a>.
         * </p>
         * 
         * @param roleARN
         *        This parameter is required for services that do not support service-linked roles (such as Amazon EMR),
         *        and it must specify the ARN of an IAM role that allows Application Auto Scaling to modify the scalable
         *        target on your behalf. </p>
         *        <p>
         *        If the service supports service-linked roles, Application Auto Scaling uses a service-linked role,
         *        which it creates if it does not yet exist. For more information, see <a href=
         *        "https://docs.aws.amazon.com/autoscaling/application/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-roles"
         *        >Application Auto Scaling IAM roles</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * An embedded object that contains attributes and attribute values that are used to suspend and resume
         * automatic scaling. Setting the value of an attribute to <code>true</code> suspends the specified scaling
         * activities. Setting it to <code>false</code> (default) resumes the specified scaling activities.
         * </p>
         * <p>
         * <b>Suspension Outcomes</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * For <code>DynamicScalingInSuspended</code>, while a suspension is in effect, all scale-in activities that are
         * triggered by a scaling policy are suspended.
         * </p>
         * </li>
         * <li>
         * <p>
         * For <code>DynamicScalingOutSuspended</code>, while a suspension is in effect, all scale-out activities that
         * are triggered by a scaling policy are suspended.
         * </p>
         * </li>
         * <li>
         * <p>
         * For <code>ScheduledScalingSuspended</code>, while a suspension is in effect, all scaling activities that
         * involve scheduled actions are suspended.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-suspend-resume-scaling.html"
         * >Suspending and resuming scaling</a> in the <i>Application Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param suspendedState
         *        An embedded object that contains attributes and attribute values that are used to suspend and resume
         *        automatic scaling. Setting the value of an attribute to <code>true</code> suspends the specified
         *        scaling activities. Setting it to <code>false</code> (default) resumes the specified scaling
         *        activities. </p>
         *        <p>
         *        <b>Suspension Outcomes</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For <code>DynamicScalingInSuspended</code>, while a suspension is in effect, all scale-in activities
         *        that are triggered by a scaling policy are suspended.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For <code>DynamicScalingOutSuspended</code>, while a suspension is in effect, all scale-out activities
         *        that are triggered by a scaling policy are suspended.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For <code>ScheduledScalingSuspended</code>, while a suspension is in effect, all scaling activities
         *        that involve scheduled actions are suspended.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-suspend-resume-scaling.html"
         *        >Suspending and resuming scaling</a> in the <i>Application Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suspendedState(SuspendedState suspendedState);

        /**
         * <p>
         * An embedded object that contains attributes and attribute values that are used to suspend and resume
         * automatic scaling. Setting the value of an attribute to <code>true</code> suspends the specified scaling
         * activities. Setting it to <code>false</code> (default) resumes the specified scaling activities.
         * </p>
         * <p>
         * <b>Suspension Outcomes</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * For <code>DynamicScalingInSuspended</code>, while a suspension is in effect, all scale-in activities that are
         * triggered by a scaling policy are suspended.
         * </p>
         * </li>
         * <li>
         * <p>
         * For <code>DynamicScalingOutSuspended</code>, while a suspension is in effect, all scale-out activities that
         * are triggered by a scaling policy are suspended.
         * </p>
         * </li>
         * <li>
         * <p>
         * For <code>ScheduledScalingSuspended</code>, while a suspension is in effect, all scaling activities that
         * involve scheduled actions are suspended.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-suspend-resume-scaling.html"
         * >Suspending and resuming scaling</a> in the <i>Application Auto Scaling User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link SuspendedState.Builder} avoiding the need
         * to create one manually via {@link SuspendedState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SuspendedState.Builder#build()} is called immediately and its
         * result is passed to {@link #suspendedState(SuspendedState)}.
         * 
         * @param suspendedState
         *        a consumer that will call methods on {@link SuspendedState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suspendedState(SuspendedState)
         */
        default Builder suspendedState(Consumer<SuspendedState.Builder> suspendedState) {
            return suspendedState(SuspendedState.builder().applyMutation(suspendedState).build());
        }

        /**
         * <p>
         * Assigns one or more tags to the scalable target. Use this parameter to tag the scalable target when it is
         * created. To tag an existing scalable target, use the <a>TagResource</a> operation.
         * </p>
         * <p>
         * Each tag consists of a tag key and a tag value. Both the tag key and the tag value are required. You cannot
         * have more than one tag on a scalable target with the same tag key.
         * </p>
         * <p>
         * Use tags to control access to a scalable target. For more information, see <a
         * href="https://docs.aws.amazon.com/autoscaling/application/userguide/resource-tagging-support.html">Tagging
         * support for Application Auto Scaling</a> in the <i>Application Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param tags
         *        Assigns one or more tags to the scalable target. Use this parameter to tag the scalable target when it
         *        is created. To tag an existing scalable target, use the <a>TagResource</a> operation.</p>
         *        <p>
         *        Each tag consists of a tag key and a tag value. Both the tag key and the tag value are required. You
         *        cannot have more than one tag on a scalable target with the same tag key.
         *        </p>
         *        <p>
         *        Use tags to control access to a scalable target. For more information, see <a
         *        href="https://docs.aws.amazon.com/autoscaling/application/userguide/resource-tagging-support.html"
         *        >Tagging support for Application Auto Scaling</a> in the <i>Application Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationAutoScalingRequest.BuilderImpl implements Builder {
        private String serviceNamespace;

        private String resourceId;

        private String scalableDimension;

        private Integer minCapacity;

        private Integer maxCapacity;

        private String roleARN;

        private SuspendedState suspendedState;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterScalableTargetRequest model) {
            super(model);
            serviceNamespace(model.serviceNamespace);
            resourceId(model.resourceId);
            scalableDimension(model.scalableDimension);
            minCapacity(model.minCapacity);
            maxCapacity(model.maxCapacity);
            roleARN(model.roleARN);
            suspendedState(model.suspendedState);
            tags(model.tags);
        }

        public final String getServiceNamespace() {
            return serviceNamespace;
        }

        public final void setServiceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
        }

        @Override
        public final Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        @Override
        public final Builder serviceNamespace(ServiceNamespace serviceNamespace) {
            this.serviceNamespace(serviceNamespace == null ? null : serviceNamespace.toString());
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getScalableDimension() {
            return scalableDimension;
        }

        public final void setScalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
        }

        @Override
        public final Builder scalableDimension(String scalableDimension) {
            this.scalableDimension = scalableDimension;
            return this;
        }

        @Override
        public final Builder scalableDimension(ScalableDimension scalableDimension) {
            this.scalableDimension(scalableDimension == null ? null : scalableDimension.toString());
            return this;
        }

        public final Integer getMinCapacity() {
            return minCapacity;
        }

        public final void setMinCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
        }

        @Override
        public final Builder minCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        public final Integer getMaxCapacity() {
            return maxCapacity;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final SuspendedState.Builder getSuspendedState() {
            return suspendedState != null ? suspendedState.toBuilder() : null;
        }

        public final void setSuspendedState(SuspendedState.BuilderImpl suspendedState) {
            this.suspendedState = suspendedState != null ? suspendedState.build() : null;
        }

        @Override
        public final Builder suspendedState(SuspendedState suspendedState) {
            this.suspendedState = suspendedState;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterScalableTargetRequest build() {
            return new RegisterScalableTargetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
