/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationautoscaling.ApplicationAutoScalingAsyncClient;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalableTargetsRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalableTargetsResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalableTarget;

public class DescribeScalableTargetsPublisher
implements SdkPublisher<DescribeScalableTargetsResponse> {
    private final ApplicationAutoScalingAsyncClient client;
    private final DescribeScalableTargetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeScalableTargetsPublisher(ApplicationAutoScalingAsyncClient client, DescribeScalableTargetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeScalableTargetsPublisher(ApplicationAutoScalingAsyncClient client, DescribeScalableTargetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeScalableTargetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeScalableTargetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ScalableTarget> scalableTargets() {
        Function<DescribeScalableTargetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.scalableTargets() != null) {
                return response.scalableTargets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeScalableTargetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeScalableTargetsResponseFetcher
    implements AsyncPageFetcher<DescribeScalableTargetsResponse> {
        private DescribeScalableTargetsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeScalableTargetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeScalableTargetsResponse> nextPage(DescribeScalableTargetsResponse previousPage) {
            if (previousPage == null) {
                return DescribeScalableTargetsPublisher.this.client.describeScalableTargets(DescribeScalableTargetsPublisher.this.firstRequest);
            }
            return DescribeScalableTargetsPublisher.this.client.describeScalableTargets((DescribeScalableTargetsRequest)((Object)DescribeScalableTargetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

