/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appflow.AppflowAsyncClient;
import software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsRequest;
import software.amazon.awssdk.services.appflow.model.DescribeFlowExecutionRecordsResponse;

public class DescribeFlowExecutionRecordsPublisher
implements SdkPublisher<DescribeFlowExecutionRecordsResponse> {
    private final AppflowAsyncClient client;
    private final DescribeFlowExecutionRecordsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeFlowExecutionRecordsPublisher(AppflowAsyncClient client, DescribeFlowExecutionRecordsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeFlowExecutionRecordsPublisher(AppflowAsyncClient client, DescribeFlowExecutionRecordsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeFlowExecutionRecordsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeFlowExecutionRecordsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeFlowExecutionRecordsResponseFetcher
    implements AsyncPageFetcher<DescribeFlowExecutionRecordsResponse> {
        private DescribeFlowExecutionRecordsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFlowExecutionRecordsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeFlowExecutionRecordsResponse> nextPage(DescribeFlowExecutionRecordsResponse previousPage) {
            if (previousPage == null) {
                return DescribeFlowExecutionRecordsPublisher.this.client.describeFlowExecutionRecords(DescribeFlowExecutionRecordsPublisher.this.firstRequest);
            }
            return DescribeFlowExecutionRecordsPublisher.this.client.describeFlowExecutionRecords((DescribeFlowExecutionRecordsRequest)((Object)DescribeFlowExecutionRecordsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

