/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FileType {
    CSV("CSV"),
    JSON("JSON"),
    PARQUET("PARQUET"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FileType> VALUE_MAP;
    private final String value;

    private FileType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FileType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FileType> knownValues() {
        EnumSet<FileType> knownValues = EnumSet.allOf(FileType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FileType.class, FileType::toString);
    }
}

