/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.AppflowResponse;
import software.amazon.awssdk.services.appflow.model.FlowStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartFlowResponse
extends AppflowResponse
implements ToCopyableBuilder<Builder, StartFlowResponse> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowArn").getter(StartFlowResponse.getter(StartFlowResponse::flowArn)).setter(StartFlowResponse.setter(Builder::flowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()}).build();
    private static final SdkField<String> FLOW_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowStatus").getter(StartFlowResponse.getter(StartFlowResponse::flowStatusAsString)).setter(StartFlowResponse.setter(Builder::flowStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowStatus").build()}).build();
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionId").getter(StartFlowResponse.getter(StartFlowResponse::executionId)).setter(StartFlowResponse.setter(Builder::executionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD, FLOW_STATUS_FIELD, EXECUTION_ID_FIELD));
    private final String flowArn;
    private final String flowStatus;
    private final String executionId;

    private StartFlowResponse(BuilderImpl builder) {
        super(builder);
        this.flowArn = builder.flowArn;
        this.flowStatus = builder.flowStatus;
        this.executionId = builder.executionId;
    }

    public final String flowArn() {
        return this.flowArn;
    }

    public final FlowStatus flowStatus() {
        return FlowStatus.fromValue(this.flowStatus);
    }

    public final String flowStatusAsString() {
        return this.flowStatus;
    }

    public final String executionId() {
        return this.executionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartFlowResponse)) {
            return false;
        }
        StartFlowResponse other = (StartFlowResponse)((Object)obj);
        return Objects.equals(this.flowArn(), other.flowArn()) && Objects.equals(this.flowStatusAsString(), other.flowStatusAsString()) && Objects.equals(this.executionId(), other.executionId());
    }

    public final String toString() {
        return ToString.builder((String)"StartFlowResponse").add("FlowArn", (Object)this.flowArn()).add("FlowStatus", (Object)this.flowStatusAsString()).add("ExecutionId", (Object)this.executionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "flowArn": {
                return Optional.ofNullable(clazz.cast(this.flowArn()));
            }
            case "flowStatus": {
                return Optional.ofNullable(clazz.cast(this.flowStatusAsString()));
            }
            case "executionId": {
                return Optional.ofNullable(clazz.cast(this.executionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartFlowResponse, T> g) {
        return obj -> g.apply((StartFlowResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppflowResponse.BuilderImpl
    implements Builder {
        private String flowArn;
        private String flowStatus;
        private String executionId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartFlowResponse model) {
            super(model);
            this.flowArn(model.flowArn);
            this.flowStatus(model.flowStatus);
            this.executionId(model.executionId);
        }

        public final String getFlowArn() {
            return this.flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final String getFlowStatus() {
            return this.flowStatus;
        }

        public final void setFlowStatus(String flowStatus) {
            this.flowStatus = flowStatus;
        }

        @Override
        public final Builder flowStatus(String flowStatus) {
            this.flowStatus = flowStatus;
            return this;
        }

        @Override
        public final Builder flowStatus(FlowStatus flowStatus) {
            this.flowStatus(flowStatus == null ? null : flowStatus.toString());
            return this;
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        @Override
        public StartFlowResponse build() {
            return new StartFlowResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppflowResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartFlowResponse> {
        public Builder flowArn(String var1);

        public Builder flowStatus(String var1);

        public Builder flowStatus(FlowStatus var1);

        public Builder executionId(String var1);
    }
}

