/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateExtensionAssociationRequest extends AppConfigRequest implements
        ToCopyableBuilder<CreateExtensionAssociationRequest.Builder, CreateExtensionAssociationRequest> {
    private static final SdkField<String> EXTENSION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExtensionIdentifier").getter(getter(CreateExtensionAssociationRequest::extensionIdentifier))
            .setter(setter(Builder::extensionIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtensionIdentifier").build())
            .build();

    private static final SdkField<Integer> EXTENSION_VERSION_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ExtensionVersionNumber").getter(getter(CreateExtensionAssociationRequest::extensionVersionNumber))
            .setter(setter(Builder::extensionVersionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtensionVersionNumber").build())
            .build();

    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceIdentifier").getter(getter(CreateExtensionAssociationRequest::resourceIdentifier))
            .setter(setter(Builder::resourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifier").build())
            .build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(CreateExtensionAssociationRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateExtensionAssociationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTENSION_IDENTIFIER_FIELD,
            EXTENSION_VERSION_NUMBER_FIELD, RESOURCE_IDENTIFIER_FIELD, PARAMETERS_FIELD, TAGS_FIELD));

    private final String extensionIdentifier;

    private final Integer extensionVersionNumber;

    private final String resourceIdentifier;

    private final Map<String, String> parameters;

    private final Map<String, String> tags;

    private CreateExtensionAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.extensionIdentifier = builder.extensionIdentifier;
        this.extensionVersionNumber = builder.extensionVersionNumber;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.parameters = builder.parameters;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name, the ID, or the Amazon Resource Name (ARN) of the extension.
     * </p>
     * 
     * @return The name, the ID, or the Amazon Resource Name (ARN) of the extension.
     */
    public final String extensionIdentifier() {
        return extensionIdentifier;
    }

    /**
     * <p>
     * The version number of the extension. If not specified, AppConfig uses the maximum version of the extension.
     * </p>
     * 
     * @return The version number of the extension. If not specified, AppConfig uses the maximum version of the
     *         extension.
     */
    public final Integer extensionVersionNumber() {
        return extensionVersionNumber;
    }

    /**
     * <p>
     * The ARN of an application, configuration profile, or environment.
     * </p>
     * 
     * @return The ARN of an application, configuration profile, or environment.
     */
    public final String resourceIdentifier() {
        return resourceIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The parameter names and values defined in the extensions. Extension parameters marked <code>Required</code> must
     * be entered for this field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The parameter names and values defined in the extensions. Extension parameters marked
     *         <code>Required</code> must be entered for this field.
     */
    public final Map<String, String> parameters() {
        return parameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Adds one or more tags for the specified extension association. Tags are metadata that help you categorize
     * resources in different ways, for example, by purpose, owner, or environment. Each tag consists of a key and an
     * optional value, both of which you define.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Adds one or more tags for the specified extension association. Tags are metadata that help you categorize
     *         resources in different ways, for example, by purpose, owner, or environment. Each tag consists of a key
     *         and an optional value, both of which you define.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(extensionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(extensionVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExtensionAssociationRequest)) {
            return false;
        }
        CreateExtensionAssociationRequest other = (CreateExtensionAssociationRequest) obj;
        return Objects.equals(extensionIdentifier(), other.extensionIdentifier())
                && Objects.equals(extensionVersionNumber(), other.extensionVersionNumber())
                && Objects.equals(resourceIdentifier(), other.resourceIdentifier()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateExtensionAssociationRequest").add("ExtensionIdentifier", extensionIdentifier())
                .add("ExtensionVersionNumber", extensionVersionNumber()).add("ResourceIdentifier", resourceIdentifier())
                .add("Parameters", hasParameters() ? parameters() : null).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExtensionIdentifier":
            return Optional.ofNullable(clazz.cast(extensionIdentifier()));
        case "ExtensionVersionNumber":
            return Optional.ofNullable(clazz.cast(extensionVersionNumber()));
        case "ResourceIdentifier":
            return Optional.ofNullable(clazz.cast(resourceIdentifier()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateExtensionAssociationRequest, T> g) {
        return obj -> g.apply((CreateExtensionAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateExtensionAssociationRequest> {
        /**
         * <p>
         * The name, the ID, or the Amazon Resource Name (ARN) of the extension.
         * </p>
         * 
         * @param extensionIdentifier
         *        The name, the ID, or the Amazon Resource Name (ARN) of the extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extensionIdentifier(String extensionIdentifier);

        /**
         * <p>
         * The version number of the extension. If not specified, AppConfig uses the maximum version of the extension.
         * </p>
         * 
         * @param extensionVersionNumber
         *        The version number of the extension. If not specified, AppConfig uses the maximum version of the
         *        extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extensionVersionNumber(Integer extensionVersionNumber);

        /**
         * <p>
         * The ARN of an application, configuration profile, or environment.
         * </p>
         * 
         * @param resourceIdentifier
         *        The ARN of an application, configuration profile, or environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(String resourceIdentifier);

        /**
         * <p>
         * The parameter names and values defined in the extensions. Extension parameters marked <code>Required</code>
         * must be entered for this field.
         * </p>
         * 
         * @param parameters
         *        The parameter names and values defined in the extensions. Extension parameters marked
         *        <code>Required</code> must be entered for this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);

        /**
         * <p>
         * Adds one or more tags for the specified extension association. Tags are metadata that help you categorize
         * resources in different ways, for example, by purpose, owner, or environment. Each tag consists of a key and
         * an optional value, both of which you define.
         * </p>
         * 
         * @param tags
         *        Adds one or more tags for the specified extension association. Tags are metadata that help you
         *        categorize resources in different ways, for example, by purpose, owner, or environment. Each tag
         *        consists of a key and an optional value, both of which you define.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppConfigRequest.BuilderImpl implements Builder {
        private String extensionIdentifier;

        private Integer extensionVersionNumber;

        private String resourceIdentifier;

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExtensionAssociationRequest model) {
            super(model);
            extensionIdentifier(model.extensionIdentifier);
            extensionVersionNumber(model.extensionVersionNumber);
            resourceIdentifier(model.resourceIdentifier);
            parameters(model.parameters);
            tags(model.tags);
        }

        public final String getExtensionIdentifier() {
            return extensionIdentifier;
        }

        public final void setExtensionIdentifier(String extensionIdentifier) {
            this.extensionIdentifier = extensionIdentifier;
        }

        @Override
        public final Builder extensionIdentifier(String extensionIdentifier) {
            this.extensionIdentifier = extensionIdentifier;
            return this;
        }

        public final Integer getExtensionVersionNumber() {
            return extensionVersionNumber;
        }

        public final void setExtensionVersionNumber(Integer extensionVersionNumber) {
            this.extensionVersionNumber = extensionVersionNumber;
        }

        @Override
        public final Builder extensionVersionNumber(Integer extensionVersionNumber) {
            this.extensionVersionNumber = extensionVersionNumber;
            return this;
        }

        public final String getResourceIdentifier() {
            return resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParameterValueMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParameterValueMapCopier.copy(parameters);
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateExtensionAssociationRequest build() {
            return new CreateExtensionAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
