/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appconfig.AppConfigAsyncClient;
import software.amazon.awssdk.services.appconfig.internal.UserAgentUtils;
import software.amazon.awssdk.services.appconfig.model.ListExtensionAssociationsRequest;
import software.amazon.awssdk.services.appconfig.model.ListExtensionAssociationsResponse;

public class ListExtensionAssociationsPublisher
implements SdkPublisher<ListExtensionAssociationsResponse> {
    private final AppConfigAsyncClient client;
    private final ListExtensionAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListExtensionAssociationsPublisher(AppConfigAsyncClient client, ListExtensionAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListExtensionAssociationsPublisher(AppConfigAsyncClient client, ListExtensionAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListExtensionAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListExtensionAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListExtensionAssociationsResponseFetcher
    implements AsyncPageFetcher<ListExtensionAssociationsResponse> {
        private ListExtensionAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListExtensionAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListExtensionAssociationsResponse> nextPage(ListExtensionAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListExtensionAssociationsPublisher.this.client.listExtensionAssociations(ListExtensionAssociationsPublisher.this.firstRequest);
            }
            return ListExtensionAssociationsPublisher.this.client.listExtensionAssociations((ListExtensionAssociationsRequest)((Object)ListExtensionAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

