/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appconfig.AppConfigAsyncClient;
import software.amazon.awssdk.services.appconfig.model.ListDeploymentStrategiesRequest;
import software.amazon.awssdk.services.appconfig.model.ListDeploymentStrategiesResponse;

public class ListDeploymentStrategiesPublisher
implements SdkPublisher<ListDeploymentStrategiesResponse> {
    private final AppConfigAsyncClient client;
    private final ListDeploymentStrategiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDeploymentStrategiesPublisher(AppConfigAsyncClient client, ListDeploymentStrategiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDeploymentStrategiesPublisher(AppConfigAsyncClient client, ListDeploymentStrategiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDeploymentStrategiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDeploymentStrategiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListDeploymentStrategiesResponseFetcher
    implements AsyncPageFetcher<ListDeploymentStrategiesResponse> {
        private ListDeploymentStrategiesResponseFetcher() {
        }

        public boolean hasNextPage(ListDeploymentStrategiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDeploymentStrategiesResponse> nextPage(ListDeploymentStrategiesResponse previousPage) {
            if (previousPage == null) {
                return ListDeploymentStrategiesPublisher.this.client.listDeploymentStrategies(ListDeploymentStrategiesPublisher.this.firstRequest);
            }
            return ListDeploymentStrategiesPublisher.this.client.listDeploymentStrategies((ListDeploymentStrategiesRequest)((Object)ListDeploymentStrategiesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

