/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateModelResponse extends ApiGatewayV2Response implements
        ToCopyableBuilder<CreateModelResponse.Builder, CreateModelResponse> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(CreateModelResponse::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateModelResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelId").getter(getter(CreateModelResponse::modelId)).setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateModelResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SCHEMA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Schema")
            .getter(getter(CreateModelResponse::schema)).setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD,
            DESCRIPTION_FIELD, MODEL_ID_FIELD, NAME_FIELD, SCHEMA_FIELD));

    private final String contentType;

    private final String description;

    private final String modelId;

    private final String name;

    private final String schema;

    private CreateModelResponse(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.description = builder.description;
        this.modelId = builder.modelId;
        this.name = builder.name;
        this.schema = builder.schema;
    }

    /**
     * <p>
     * The content-type for the model, for example, "application/json".
     * </p>
     * 
     * @return The content-type for the model, for example, "application/json".
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * The description of the model.
     * </p>
     * 
     * @return The description of the model.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The model identifier.
     * </p>
     * 
     * @return The model identifier.
     */
    public final String modelId() {
        return modelId;
    }

    /**
     * <p>
     * The name of the model. Must be alphanumeric.
     * </p>
     * 
     * @return The name of the model. Must be alphanumeric.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The schema for the model. For application/json models, this should be JSON schema draft 4 model.
     * </p>
     * 
     * @return The schema for the model. For application/json models, this should be JSON schema draft 4 model.
     */
    public final String schema() {
        return schema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelResponse)) {
            return false;
        }
        CreateModelResponse other = (CreateModelResponse) obj;
        return Objects.equals(contentType(), other.contentType()) && Objects.equals(description(), other.description())
                && Objects.equals(modelId(), other.modelId()) && Objects.equals(name(), other.name())
                && Objects.equals(schema(), other.schema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateModelResponse").add("ContentType", contentType()).add("Description", description())
                .add("ModelId", modelId()).add("Name", name()).add("Schema", schema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ModelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Schema":
            return Optional.ofNullable(clazz.cast(schema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateModelResponse, T> g) {
        return obj -> g.apply((CreateModelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayV2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateModelResponse> {
        /**
         * <p>
         * The content-type for the model, for example, "application/json".
         * </p>
         * 
         * @param contentType
         *        The content-type for the model, for example, "application/json".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The description of the model.
         * </p>
         * 
         * @param description
         *        The description of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The model identifier.
         * </p>
         * 
         * @param modelId
         *        The model identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);

        /**
         * <p>
         * The name of the model. Must be alphanumeric.
         * </p>
         * 
         * @param name
         *        The name of the model. Must be alphanumeric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The schema for the model. For application/json models, this should be JSON schema draft 4 model.
         * </p>
         * 
         * @param schema
         *        The schema for the model. For application/json models, this should be JSON schema draft 4 model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(String schema);
    }

    static final class BuilderImpl extends ApiGatewayV2Response.BuilderImpl implements Builder {
        private String contentType;

        private String description;

        private String modelId;

        private String name;

        private String schema;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelResponse model) {
            super(model);
            contentType(model.contentType);
            description(model.description);
            modelId(model.modelId);
            name(model.name);
            schema(model.schema);
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getModelId() {
            return modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSchema() {
            return schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public CreateModelResponse build() {
            return new CreateModelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
