/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Creates a new DomainName resource to represent a domain name.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDomainNameRequest extends ApiGatewayV2Request implements
        ToCopyableBuilder<CreateDomainNameRequest.Builder, CreateDomainNameRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(CreateDomainNameRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()).build();

    private static final SdkField<List<DomainNameConfiguration>> DOMAIN_NAME_CONFIGURATIONS_FIELD = SdkField
            .<List<DomainNameConfiguration>> builder(MarshallingType.LIST)
            .memberName("DomainNameConfigurations")
            .getter(getter(CreateDomainNameRequest::domainNameConfigurations))
            .setter(setter(Builder::domainNameConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainNameConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DomainNameConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(DomainNameConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MutualTlsAuthenticationInput> MUTUAL_TLS_AUTHENTICATION_FIELD = SdkField
            .<MutualTlsAuthenticationInput> builder(MarshallingType.SDK_POJO).memberName("MutualTlsAuthentication")
            .getter(getter(CreateDomainNameRequest::mutualTlsAuthentication)).setter(setter(Builder::mutualTlsAuthentication))
            .constructor(MutualTlsAuthenticationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mutualTlsAuthentication").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateDomainNameRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            DOMAIN_NAME_CONFIGURATIONS_FIELD, MUTUAL_TLS_AUTHENTICATION_FIELD, TAGS_FIELD));

    private final String domainName;

    private final List<DomainNameConfiguration> domainNameConfigurations;

    private final MutualTlsAuthenticationInput mutualTlsAuthentication;

    private final Map<String, String> tags;

    private CreateDomainNameRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.domainNameConfigurations = builder.domainNameConfigurations;
        this.mutualTlsAuthentication = builder.mutualTlsAuthentication;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The domain name.
     * </p>
     * 
     * @return The domain name.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * For responses, this returns true if the service returned a value for the DomainNameConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDomainNameConfigurations() {
        return domainNameConfigurations != null && !(domainNameConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The domain name configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomainNameConfigurations} method.
     * </p>
     * 
     * @return The domain name configurations.
     */
    public final List<DomainNameConfiguration> domainNameConfigurations() {
        return domainNameConfigurations;
    }

    /**
     * <p>
     * The mutual TLS authentication configuration for a custom domain name.
     * </p>
     * 
     * @return The mutual TLS authentication configuration for a custom domain name.
     */
    public final MutualTlsAuthenticationInput mutualTlsAuthentication() {
        return mutualTlsAuthentication;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The collection of tags associated with a domain name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The collection of tags associated with a domain name.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(hasDomainNameConfigurations() ? domainNameConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(mutualTlsAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainNameRequest)) {
            return false;
        }
        CreateDomainNameRequest other = (CreateDomainNameRequest) obj;
        return Objects.equals(domainName(), other.domainName())
                && hasDomainNameConfigurations() == other.hasDomainNameConfigurations()
                && Objects.equals(domainNameConfigurations(), other.domainNameConfigurations())
                && Objects.equals(mutualTlsAuthentication(), other.mutualTlsAuthentication()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDomainNameRequest").add("DomainName", domainName())
                .add("DomainNameConfigurations", hasDomainNameConfigurations() ? domainNameConfigurations() : null)
                .add("MutualTlsAuthentication", mutualTlsAuthentication()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "DomainNameConfigurations":
            return Optional.ofNullable(clazz.cast(domainNameConfigurations()));
        case "MutualTlsAuthentication":
            return Optional.ofNullable(clazz.cast(mutualTlsAuthentication()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDomainNameRequest, T> g) {
        return obj -> g.apply((CreateDomainNameRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayV2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateDomainNameRequest> {
        /**
         * <p>
         * The domain name.
         * </p>
         * 
         * @param domainName
         *        The domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The domain name configurations.
         * </p>
         * 
         * @param domainNameConfigurations
         *        The domain name configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainNameConfigurations(Collection<DomainNameConfiguration> domainNameConfigurations);

        /**
         * <p>
         * The domain name configurations.
         * </p>
         * 
         * @param domainNameConfigurations
         *        The domain name configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainNameConfigurations(DomainNameConfiguration... domainNameConfigurations);

        /**
         * <p>
         * The domain name configurations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.apigatewayv2.model.DomainNameConfiguration.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.apigatewayv2.model.DomainNameConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.apigatewayv2.model.DomainNameConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #domainNameConfigurations(List<DomainNameConfiguration>)}.
         * 
         * @param domainNameConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.apigatewayv2.model.DomainNameConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainNameConfigurations(java.util.Collection<DomainNameConfiguration>)
         */
        Builder domainNameConfigurations(Consumer<DomainNameConfiguration.Builder>... domainNameConfigurations);

        /**
         * <p>
         * The mutual TLS authentication configuration for a custom domain name.
         * </p>
         * 
         * @param mutualTlsAuthentication
         *        The mutual TLS authentication configuration for a custom domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mutualTlsAuthentication(MutualTlsAuthenticationInput mutualTlsAuthentication);

        /**
         * <p>
         * The mutual TLS authentication configuration for a custom domain name.
         * </p>
         * This is a convenience method that creates an instance of the {@link MutualTlsAuthenticationInput.Builder}
         * avoiding the need to create one manually via {@link MutualTlsAuthenticationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MutualTlsAuthenticationInput.Builder#build()} is called
         * immediately and its result is passed to {@link #mutualTlsAuthentication(MutualTlsAuthenticationInput)}.
         * 
         * @param mutualTlsAuthentication
         *        a consumer that will call methods on {@link MutualTlsAuthenticationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mutualTlsAuthentication(MutualTlsAuthenticationInput)
         */
        default Builder mutualTlsAuthentication(Consumer<MutualTlsAuthenticationInput.Builder> mutualTlsAuthentication) {
            return mutualTlsAuthentication(MutualTlsAuthenticationInput.builder().applyMutation(mutualTlsAuthentication).build());
        }

        /**
         * <p>
         * The collection of tags associated with a domain name.
         * </p>
         * 
         * @param tags
         *        The collection of tags associated with a domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayV2Request.BuilderImpl implements Builder {
        private String domainName;

        private List<DomainNameConfiguration> domainNameConfigurations = DefaultSdkAutoConstructList.getInstance();

        private MutualTlsAuthenticationInput mutualTlsAuthentication;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainNameRequest model) {
            super(model);
            domainName(model.domainName);
            domainNameConfigurations(model.domainNameConfigurations);
            mutualTlsAuthentication(model.mutualTlsAuthentication);
            tags(model.tags);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final List<DomainNameConfiguration.Builder> getDomainNameConfigurations() {
            List<DomainNameConfiguration.Builder> result = DomainNameConfigurationsCopier
                    .copyToBuilder(this.domainNameConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainNameConfigurations(Collection<DomainNameConfiguration.BuilderImpl> domainNameConfigurations) {
            this.domainNameConfigurations = DomainNameConfigurationsCopier.copyFromBuilder(domainNameConfigurations);
        }

        @Override
        public final Builder domainNameConfigurations(Collection<DomainNameConfiguration> domainNameConfigurations) {
            this.domainNameConfigurations = DomainNameConfigurationsCopier.copy(domainNameConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainNameConfigurations(DomainNameConfiguration... domainNameConfigurations) {
            domainNameConfigurations(Arrays.asList(domainNameConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainNameConfigurations(Consumer<DomainNameConfiguration.Builder>... domainNameConfigurations) {
            domainNameConfigurations(Stream.of(domainNameConfigurations)
                    .map(c -> DomainNameConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final MutualTlsAuthenticationInput.Builder getMutualTlsAuthentication() {
            return mutualTlsAuthentication != null ? mutualTlsAuthentication.toBuilder() : null;
        }

        public final void setMutualTlsAuthentication(MutualTlsAuthenticationInput.BuilderImpl mutualTlsAuthentication) {
            this.mutualTlsAuthentication = mutualTlsAuthentication != null ? mutualTlsAuthentication.build() : null;
        }

        @Override
        public final Builder mutualTlsAuthentication(MutualTlsAuthenticationInput mutualTlsAuthentication) {
            this.mutualTlsAuthentication = mutualTlsAuthentication;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDomainNameRequest build() {
            return new CreateDomainNameRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
