/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigateway.ApiGatewayClient;
import software.amazon.awssdk.services.apigateway.internal.UserAgentUtils;
import software.amazon.awssdk.services.apigateway.model.DomainName;
import software.amazon.awssdk.services.apigateway.model.GetDomainNamesRequest;
import software.amazon.awssdk.services.apigateway.model.GetDomainNamesResponse;

public class GetDomainNamesIterable
implements SdkIterable<GetDomainNamesResponse> {
    private final ApiGatewayClient client;
    private final GetDomainNamesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetDomainNamesIterable(ApiGatewayClient client, GetDomainNamesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetDomainNamesResponseFetcher();
    }

    public Iterator<GetDomainNamesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DomainName> items() {
        Function<GetDomainNamesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetDomainNamesResponseFetcher
    implements SyncPageFetcher<GetDomainNamesResponse> {
        private GetDomainNamesResponseFetcher() {
        }

        public boolean hasNextPage(GetDomainNamesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.position());
        }

        public GetDomainNamesResponse nextPage(GetDomainNamesResponse previousPage) {
            if (previousPage == null) {
                return GetDomainNamesIterable.this.client.getDomainNames(GetDomainNamesIterable.this.firstRequest);
            }
            return GetDomainNamesIterable.this.client.getDomainNames((GetDomainNamesRequest)((Object)GetDomainNamesIterable.this.firstRequest.toBuilder().position(previousPage.position()).build()));
        }
    }
}

