/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Dependency package that may be required for the project code to run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodegenDependency implements SdkPojo, Serializable,
        ToCopyableBuilder<CodegenDependency.Builder, CodegenDependency> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CodegenDependency::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SUPPORTED_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("supportedVersion").getter(getter(CodegenDependency::supportedVersion))
            .setter(setter(Builder::supportedVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedVersion").build()).build();

    private static final SdkField<Boolean> IS_SEM_VER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isSemVer").getter(getter(CodegenDependency::isSemVer)).setter(setter(Builder::isSemVer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isSemVer").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(CodegenDependency::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            SUPPORTED_VERSION_FIELD, IS_SEM_VER_FIELD, REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String supportedVersion;

    private final Boolean isSemVer;

    private final String reason;

    private CodegenDependency(BuilderImpl builder) {
        this.name = builder.name;
        this.supportedVersion = builder.supportedVersion;
        this.isSemVer = builder.isSemVer;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * Name of the dependency package.
     * </p>
     * 
     * @return Name of the dependency package.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Indicates the version of the supported dependency package.
     * </p>
     * 
     * @return Indicates the version of the supported dependency package.
     */
    public final String supportedVersion() {
        return supportedVersion;
    }

    /**
     * <p>
     * Determines if the dependency package is using Semantic versioning. If set to true, it indicates that the
     * dependency package uses Semantic versioning.
     * </p>
     * 
     * @return Determines if the dependency package is using Semantic versioning. If set to true, it indicates that the
     *         dependency package uses Semantic versioning.
     */
    public final Boolean isSemVer() {
        return isSemVer;
    }

    /**
     * <p>
     * Indicates the reason to include the dependency package in your project code.
     * </p>
     * 
     * @return Indicates the reason to include the dependency package in your project code.
     */
    public final String reason() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(supportedVersion());
        hashCode = 31 * hashCode + Objects.hashCode(isSemVer());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodegenDependency)) {
            return false;
        }
        CodegenDependency other = (CodegenDependency) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(supportedVersion(), other.supportedVersion())
                && Objects.equals(isSemVer(), other.isSemVer()) && Objects.equals(reason(), other.reason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodegenDependency").add("Name", name()).add("SupportedVersion", supportedVersion())
                .add("IsSemVer", isSemVer()).add("Reason", reason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "supportedVersion":
            return Optional.ofNullable(clazz.cast(supportedVersion()));
        case "isSemVer":
            return Optional.ofNullable(clazz.cast(isSemVer()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodegenDependency, T> g) {
        return obj -> g.apply((CodegenDependency) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodegenDependency> {
        /**
         * <p>
         * Name of the dependency package.
         * </p>
         * 
         * @param name
         *        Name of the dependency package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Indicates the version of the supported dependency package.
         * </p>
         * 
         * @param supportedVersion
         *        Indicates the version of the supported dependency package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedVersion(String supportedVersion);

        /**
         * <p>
         * Determines if the dependency package is using Semantic versioning. If set to true, it indicates that the
         * dependency package uses Semantic versioning.
         * </p>
         * 
         * @param isSemVer
         *        Determines if the dependency package is using Semantic versioning. If set to true, it indicates that
         *        the dependency package uses Semantic versioning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isSemVer(Boolean isSemVer);

        /**
         * <p>
         * Indicates the reason to include the dependency package in your project code.
         * </p>
         * 
         * @param reason
         *        Indicates the reason to include the dependency package in your project code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String supportedVersion;

        private Boolean isSemVer;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(CodegenDependency model) {
            name(model.name);
            supportedVersion(model.supportedVersion);
            isSemVer(model.isSemVer);
            reason(model.reason);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSupportedVersion() {
            return supportedVersion;
        }

        public final void setSupportedVersion(String supportedVersion) {
            this.supportedVersion = supportedVersion;
        }

        @Override
        public final Builder supportedVersion(String supportedVersion) {
            this.supportedVersion = supportedVersion;
            return this;
        }

        public final Boolean getIsSemVer() {
            return isSemVer;
        }

        public final void setIsSemVer(Boolean isSemVer) {
            this.isSemVer = isSemVer;
        }

        @Override
        public final Builder isSemVer(Boolean isSemVer) {
            this.isSemVer = isSemVer;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public CodegenDependency build() {
            return new CodegenDependency(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
