/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EmailSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EmailSettings> {
    private static final SdkField<String> EMAIL_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailMessage").getter(EmailSettings.getter(EmailSettings::emailMessage)).setter(EmailSettings.setter(Builder::emailMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailMessage").build()}).build();
    private static final SdkField<String> EMAIL_SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailSubject").getter(EmailSettings.getter(EmailSettings::emailSubject)).setter(EmailSettings.setter(Builder::emailSubject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailSubject").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_MESSAGE_FIELD, EMAIL_SUBJECT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String emailMessage;
    private final String emailSubject;

    private EmailSettings(BuilderImpl builder) {
        this.emailMessage = builder.emailMessage;
        this.emailSubject = builder.emailSubject;
    }

    public final String emailMessage() {
        return this.emailMessage;
    }

    public final String emailSubject() {
        return this.emailSubject;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.emailMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailSubject());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailSettings)) {
            return false;
        }
        EmailSettings other = (EmailSettings)obj;
        return Objects.equals(this.emailMessage(), other.emailMessage()) && Objects.equals(this.emailSubject(), other.emailSubject());
    }

    public final String toString() {
        return ToString.builder((String)"EmailSettings").add("EmailMessage", (Object)this.emailMessage()).add("EmailSubject", (Object)this.emailSubject()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EmailMessage": {
                return Optional.ofNullable(clazz.cast(this.emailMessage()));
            }
            case "EmailSubject": {
                return Optional.ofNullable(clazz.cast(this.emailSubject()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmailSettings, T> g) {
        return obj -> g.apply((EmailSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String emailMessage;
        private String emailSubject;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailSettings model) {
            this.emailMessage(model.emailMessage);
            this.emailSubject(model.emailSubject);
        }

        public final String getEmailMessage() {
            return this.emailMessage;
        }

        public final void setEmailMessage(String emailMessage) {
            this.emailMessage = emailMessage;
        }

        @Override
        public final Builder emailMessage(String emailMessage) {
            this.emailMessage = emailMessage;
            return this;
        }

        public final String getEmailSubject() {
            return this.emailSubject;
        }

        public final void setEmailSubject(String emailSubject) {
            this.emailSubject = emailSubject;
        }

        @Override
        public final Builder emailSubject(String emailSubject) {
            this.emailSubject = emailSubject;
            return this;
        }

        public EmailSettings build() {
            return new EmailSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EmailSettings> {
        public Builder emailMessage(String var1);

        public Builder emailSubject(String var1);
    }
}

