/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amp.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the status of a namespace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleGroupsNamespaceStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleGroupsNamespaceStatus.Builder, RuleGroupsNamespaceStatus> {
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusCode").getter(getter(RuleGroupsNamespaceStatus::statusCodeAsString))
            .setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(RuleGroupsNamespaceStatus::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_CODE_FIELD,
            STATUS_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String statusCodeValue;

    private final String statusReason;

    private RuleGroupsNamespaceStatus(BuilderImpl builder) {
        this.statusCodeValue = builder.statusCodeValue;
        this.statusReason = builder.statusReason;
    }

    /**
     * <p>
     * Status code of this namespace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link RuleGroupsNamespaceStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return Status code of this namespace.
     * @see RuleGroupsNamespaceStatusCode
     */
    public final RuleGroupsNamespaceStatusCode statusCode() {
        return RuleGroupsNamespaceStatusCode.fromValue(statusCodeValue);
    }

    /**
     * <p>
     * Status code of this namespace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link RuleGroupsNamespaceStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return Status code of this namespace.
     * @see RuleGroupsNamespaceStatusCode
     */
    public final String statusCodeAsString() {
        return statusCodeValue;
    }

    /**
     * <p>
     * The reason for failure if any.
     * </p>
     * 
     * @return The reason for failure if any.
     */
    public final String statusReason() {
        return statusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupsNamespaceStatus)) {
            return false;
        }
        RuleGroupsNamespaceStatus other = (RuleGroupsNamespaceStatus) obj;
        return Objects.equals(statusCodeAsString(), other.statusCodeAsString())
                && Objects.equals(statusReason(), other.statusReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleGroupsNamespaceStatus").add("StatusCode", statusCodeAsString())
                .add("StatusReason", statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "statusCode":
            return Optional.ofNullable(clazz.cast(statusCodeAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleGroupsNamespaceStatus, T> g) {
        return obj -> g.apply((RuleGroupsNamespaceStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleGroupsNamespaceStatus> {
        /**
         * <p>
         * Status code of this namespace.
         * </p>
         * 
         * @param statusCodeValue
         *        Status code of this namespace.
         * @see RuleGroupsNamespaceStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleGroupsNamespaceStatusCode
         */
        Builder statusCode(String statusCodeValue);

        /**
         * <p>
         * Status code of this namespace.
         * </p>
         * 
         * @param statusCodeValue
         *        Status code of this namespace.
         * @see RuleGroupsNamespaceStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleGroupsNamespaceStatusCode
         */
        Builder statusCode(RuleGroupsNamespaceStatusCode statusCodeValue);

        /**
         * <p>
         * The reason for failure if any.
         * </p>
         * 
         * @param statusReason
         *        The reason for failure if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);
    }

    static final class BuilderImpl implements Builder {
        private String statusCodeValue;

        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupsNamespaceStatus model) {
            statusCode(model.statusCodeValue);
            statusReason(model.statusReason);
        }

        public final String getStatusCode() {
            return statusCodeValue;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        @Override
        public final Builder statusCode(RuleGroupsNamespaceStatusCode statusCodeValue) {
            this.statusCode(statusCodeValue == null ? null : statusCodeValue.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public RuleGroupsNamespaceStatus build() {
            return new RuleGroupsNamespaceStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
