/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessAsyncClient;
import software.amazon.awssdk.services.alexaforbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.ListGatewayGroupsResponse;

public class ListGatewayGroupsPublisher
implements SdkPublisher<ListGatewayGroupsResponse> {
    private final AlexaForBusinessAsyncClient client;
    private final ListGatewayGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGatewayGroupsPublisher(AlexaForBusinessAsyncClient client, ListGatewayGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGatewayGroupsPublisher(AlexaForBusinessAsyncClient client, ListGatewayGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGatewayGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGatewayGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListGatewayGroupsResponseFetcher
    implements AsyncPageFetcher<ListGatewayGroupsResponse> {
        private ListGatewayGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListGatewayGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGatewayGroupsResponse> nextPage(ListGatewayGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListGatewayGroupsPublisher.this.client.listGatewayGroups(ListGatewayGroupsPublisher.this.firstRequest);
            }
            return ListGatewayGroupsPublisher.this.client.listGatewayGroups((ListGatewayGroupsRequest)((Object)ListGatewayGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

