/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.PhoneNumber;
import software.amazon.awssdk.services.alexaforbusiness.model.PhoneNumberListCopier;
import software.amazon.awssdk.services.alexaforbusiness.model.SipAddress;
import software.amazon.awssdk.services.alexaforbusiness.model.SipAddressListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateContactRequest
extends AlexaForBusinessRequest
implements ToCopyableBuilder<Builder, UpdateContactRequest> {
    private static final SdkField<String> CONTACT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactArn").getter(UpdateContactRequest.getter(UpdateContactRequest::contactArn)).setter(UpdateContactRequest.setter(Builder::contactArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactArn").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(UpdateContactRequest.getter(UpdateContactRequest::displayName)).setter(UpdateContactRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirstName").getter(UpdateContactRequest.getter(UpdateContactRequest::firstName)).setter(UpdateContactRequest.setter(Builder::firstName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()}).build();
    private static final SdkField<String> LAST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastName").getter(UpdateContactRequest.getter(UpdateContactRequest::lastName)).setter(UpdateContactRequest.setter(Builder::lastName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()}).build();
    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumber").getter(UpdateContactRequest.getter(UpdateContactRequest::phoneNumber)).setter(UpdateContactRequest.setter(Builder::phoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()}).build();
    private static final SdkField<List<PhoneNumber>> PHONE_NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PhoneNumbers").getter(UpdateContactRequest.getter(UpdateContactRequest::phoneNumbers)).setter(UpdateContactRequest.setter(Builder::phoneNumbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumbers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhoneNumber::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SipAddress>> SIP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SipAddresses").getter(UpdateContactRequest.getter(UpdateContactRequest::sipAddresses)).setter(UpdateContactRequest.setter(Builder::sipAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SipAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SipAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ARN_FIELD, DISPLAY_NAME_FIELD, FIRST_NAME_FIELD, LAST_NAME_FIELD, PHONE_NUMBER_FIELD, PHONE_NUMBERS_FIELD, SIP_ADDRESSES_FIELD));
    private final String contactArn;
    private final String displayName;
    private final String firstName;
    private final String lastName;
    private final String phoneNumber;
    private final List<PhoneNumber> phoneNumbers;
    private final List<SipAddress> sipAddresses;

    private UpdateContactRequest(BuilderImpl builder) {
        super(builder);
        this.contactArn = builder.contactArn;
        this.displayName = builder.displayName;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.phoneNumber = builder.phoneNumber;
        this.phoneNumbers = builder.phoneNumbers;
        this.sipAddresses = builder.sipAddresses;
    }

    public final String contactArn() {
        return this.contactArn;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String firstName() {
        return this.firstName;
    }

    public final String lastName() {
        return this.lastName;
    }

    public final String phoneNumber() {
        return this.phoneNumber;
    }

    public final boolean hasPhoneNumbers() {
        return this.phoneNumbers != null && !(this.phoneNumbers instanceof SdkAutoConstructList);
    }

    public final List<PhoneNumber> phoneNumbers() {
        return this.phoneNumbers;
    }

    public final boolean hasSipAddresses() {
        return this.sipAddresses != null && !(this.sipAddresses instanceof SdkAutoConstructList);
    }

    public final List<SipAddress> sipAddresses() {
        return this.sipAddresses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contactArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastName());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhoneNumbers() ? this.phoneNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSipAddresses() ? this.sipAddresses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContactRequest)) {
            return false;
        }
        UpdateContactRequest other = (UpdateContactRequest)((Object)obj);
        return Objects.equals(this.contactArn(), other.contactArn()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.firstName(), other.firstName()) && Objects.equals(this.lastName(), other.lastName()) && Objects.equals(this.phoneNumber(), other.phoneNumber()) && this.hasPhoneNumbers() == other.hasPhoneNumbers() && Objects.equals(this.phoneNumbers(), other.phoneNumbers()) && this.hasSipAddresses() == other.hasSipAddresses() && Objects.equals(this.sipAddresses(), other.sipAddresses());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateContactRequest").add("ContactArn", (Object)this.contactArn()).add("DisplayName", (Object)this.displayName()).add("FirstName", (Object)this.firstName()).add("LastName", (Object)this.lastName()).add("PhoneNumber", (Object)(this.phoneNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("PhoneNumbers", this.hasPhoneNumbers() ? this.phoneNumbers() : null).add("SipAddresses", this.hasSipAddresses() ? this.sipAddresses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactArn": {
                return Optional.ofNullable(clazz.cast(this.contactArn()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "FirstName": {
                return Optional.ofNullable(clazz.cast(this.firstName()));
            }
            case "LastName": {
                return Optional.ofNullable(clazz.cast(this.lastName()));
            }
            case "PhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.phoneNumber()));
            }
            case "PhoneNumbers": {
                return Optional.ofNullable(clazz.cast(this.phoneNumbers()));
            }
            case "SipAddresses": {
                return Optional.ofNullable(clazz.cast(this.sipAddresses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateContactRequest, T> g) {
        return obj -> g.apply((UpdateContactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessRequest.BuilderImpl
    implements Builder {
        private String contactArn;
        private String displayName;
        private String firstName;
        private String lastName;
        private String phoneNumber;
        private List<PhoneNumber> phoneNumbers = DefaultSdkAutoConstructList.getInstance();
        private List<SipAddress> sipAddresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContactRequest model) {
            super(model);
            this.contactArn(model.contactArn);
            this.displayName(model.displayName);
            this.firstName(model.firstName);
            this.lastName(model.lastName);
            this.phoneNumber(model.phoneNumber);
            this.phoneNumbers(model.phoneNumbers);
            this.sipAddresses(model.sipAddresses);
        }

        public final String getContactArn() {
            return this.contactArn;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getFirstName() {
            return this.firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getLastName() {
            return this.lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final String getPhoneNumber() {
            return this.phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final List<PhoneNumber.Builder> getPhoneNumbers() {
            List<PhoneNumber.Builder> result = PhoneNumberListCopier.copyToBuilder(this.phoneNumbers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhoneNumbers(Collection<PhoneNumber.BuilderImpl> phoneNumbers) {
            this.phoneNumbers = PhoneNumberListCopier.copyFromBuilder(phoneNumbers);
        }

        @Override
        public final Builder phoneNumbers(Collection<PhoneNumber> phoneNumbers) {
            this.phoneNumbers = PhoneNumberListCopier.copy(phoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumbers(PhoneNumber ... phoneNumbers) {
            this.phoneNumbers(Arrays.asList(phoneNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumbers(Consumer<PhoneNumber.Builder> ... phoneNumbers) {
            this.phoneNumbers(Stream.of(phoneNumbers).map(c -> (PhoneNumber)((PhoneNumber.Builder)PhoneNumber.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SipAddress.Builder> getSipAddresses() {
            List<SipAddress.Builder> result = SipAddressListCopier.copyToBuilder(this.sipAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSipAddresses(Collection<SipAddress.BuilderImpl> sipAddresses) {
            this.sipAddresses = SipAddressListCopier.copyFromBuilder(sipAddresses);
        }

        @Override
        public final Builder sipAddresses(Collection<SipAddress> sipAddresses) {
            this.sipAddresses = SipAddressListCopier.copy(sipAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sipAddresses(SipAddress ... sipAddresses) {
            this.sipAddresses(Arrays.asList(sipAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sipAddresses(Consumer<SipAddress.Builder> ... sipAddresses) {
            this.sipAddresses(Stream.of(sipAddresses).map(c -> (SipAddress)((SipAddress.Builder)SipAddress.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContactRequest build() {
            return new UpdateContactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateContactRequest> {
        public Builder contactArn(String var1);

        public Builder displayName(String var1);

        public Builder firstName(String var1);

        public Builder lastName(String var1);

        public Builder phoneNumber(String var1);

        public Builder phoneNumbers(Collection<PhoneNumber> var1);

        public Builder phoneNumbers(PhoneNumber ... var1);

        public Builder phoneNumbers(Consumer<PhoneNumber.Builder> ... var1);

        public Builder sipAddresses(Collection<SipAddress> var1);

        public Builder sipAddresses(SipAddress ... var1);

        public Builder sipAddresses(Consumer<SipAddress.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

