/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGatewayGroupRequest extends AlexaForBusinessRequest implements
        ToCopyableBuilder<UpdateGatewayGroupRequest.Builder, UpdateGatewayGroupRequest> {
    private static final SdkField<String> GATEWAY_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayGroupArn").getter(getter(UpdateGatewayGroupRequest::gatewayGroupArn))
            .setter(setter(Builder::gatewayGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayGroupArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateGatewayGroupRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateGatewayGroupRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_GROUP_ARN_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD));

    private final String gatewayGroupArn;

    private final String name;

    private final String description;

    private UpdateGatewayGroupRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayGroupArn = builder.gatewayGroupArn;
        this.name = builder.name;
        this.description = builder.description;
    }

    /**
     * <p>
     * The ARN of the gateway group to update.
     * </p>
     * 
     * @return The ARN of the gateway group to update.
     */
    public final String gatewayGroupArn() {
        return gatewayGroupArn;
    }

    /**
     * <p>
     * The updated name of the gateway group.
     * </p>
     * 
     * @return The updated name of the gateway group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The updated description of the gateway group.
     * </p>
     * 
     * @return The updated description of the gateway group.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGatewayGroupRequest)) {
            return false;
        }
        UpdateGatewayGroupRequest other = (UpdateGatewayGroupRequest) obj;
        return Objects.equals(gatewayGroupArn(), other.gatewayGroupArn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGatewayGroupRequest").add("GatewayGroupArn", gatewayGroupArn()).add("Name", name())
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayGroupArn":
            return Optional.ofNullable(clazz.cast(gatewayGroupArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGatewayGroupRequest, T> g) {
        return obj -> g.apply((UpdateGatewayGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateGatewayGroupRequest> {
        /**
         * <p>
         * The ARN of the gateway group to update.
         * </p>
         * 
         * @param gatewayGroupArn
         *        The ARN of the gateway group to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayGroupArn(String gatewayGroupArn);

        /**
         * <p>
         * The updated name of the gateway group.
         * </p>
         * 
         * @param name
         *        The updated name of the gateway group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The updated description of the gateway group.
         * </p>
         * 
         * @param description
         *        The updated description of the gateway group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AlexaForBusinessRequest.BuilderImpl implements Builder {
        private String gatewayGroupArn;

        private String name;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGatewayGroupRequest model) {
            super(model);
            gatewayGroupArn(model.gatewayGroupArn);
            name(model.name);
            description(model.description);
        }

        public final String getGatewayGroupArn() {
            return gatewayGroupArn;
        }

        public final void setGatewayGroupArn(String gatewayGroupArn) {
            this.gatewayGroupArn = gatewayGroupArn;
        }

        @Override
        public final Builder gatewayGroupArn(String gatewayGroupArn) {
            this.gatewayGroupArn = gatewayGroupArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGatewayGroupRequest build() {
            return new UpdateGatewayGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
