/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBusinessReportSchedulesResponse extends AlexaForBusinessResponse implements
        ToCopyableBuilder<ListBusinessReportSchedulesResponse.Builder, ListBusinessReportSchedulesResponse> {
    private static final SdkField<List<BusinessReportSchedule>> BUSINESS_REPORT_SCHEDULES_FIELD = SdkField
            .<List<BusinessReportSchedule>> builder(MarshallingType.LIST)
            .memberName("BusinessReportSchedules")
            .getter(getter(ListBusinessReportSchedulesResponse::businessReportSchedules))
            .setter(setter(Builder::businessReportSchedules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessReportSchedules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BusinessReportSchedule> builder(MarshallingType.SDK_POJO)
                                            .constructor(BusinessReportSchedule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListBusinessReportSchedulesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BUSINESS_REPORT_SCHEDULES_FIELD, NEXT_TOKEN_FIELD));

    private final List<BusinessReportSchedule> businessReportSchedules;

    private final String nextToken;

    private ListBusinessReportSchedulesResponse(BuilderImpl builder) {
        super(builder);
        this.businessReportSchedules = builder.businessReportSchedules;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the BusinessReportSchedules property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBusinessReportSchedules() {
        return businessReportSchedules != null && !(businessReportSchedules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The schedule of the reports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBusinessReportSchedules} method.
     * </p>
     * 
     * @return The schedule of the reports.
     */
    public final List<BusinessReportSchedule> businessReportSchedules() {
        return businessReportSchedules;
    }

    /**
     * <p>
     * The token used to list the remaining schedules from the previous API call.
     * </p>
     * 
     * @return The token used to list the remaining schedules from the previous API call.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBusinessReportSchedules() ? businessReportSchedules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBusinessReportSchedulesResponse)) {
            return false;
        }
        ListBusinessReportSchedulesResponse other = (ListBusinessReportSchedulesResponse) obj;
        return hasBusinessReportSchedules() == other.hasBusinessReportSchedules()
                && Objects.equals(businessReportSchedules(), other.businessReportSchedules())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBusinessReportSchedulesResponse")
                .add("BusinessReportSchedules", hasBusinessReportSchedules() ? businessReportSchedules() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BusinessReportSchedules":
            return Optional.ofNullable(clazz.cast(businessReportSchedules()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBusinessReportSchedulesResponse, T> g) {
        return obj -> g.apply((ListBusinessReportSchedulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AlexaForBusinessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListBusinessReportSchedulesResponse> {
        /**
         * <p>
         * The schedule of the reports.
         * </p>
         * 
         * @param businessReportSchedules
         *        The schedule of the reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessReportSchedules(Collection<BusinessReportSchedule> businessReportSchedules);

        /**
         * <p>
         * The schedule of the reports.
         * </p>
         * 
         * @param businessReportSchedules
         *        The schedule of the reports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessReportSchedules(BusinessReportSchedule... businessReportSchedules);

        /**
         * <p>
         * The schedule of the reports.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportSchedule.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportSchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportSchedule.Builder#build()} is
         * called immediately and its result is passed to {@link #businessReportSchedules(List<BusinessReportSchedule>)}.
         * 
         * @param businessReportSchedules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #businessReportSchedules(java.util.Collection<BusinessReportSchedule>)
         */
        Builder businessReportSchedules(Consumer<BusinessReportSchedule.Builder>... businessReportSchedules);

        /**
         * <p>
         * The token used to list the remaining schedules from the previous API call.
         * </p>
         * 
         * @param nextToken
         *        The token used to list the remaining schedules from the previous API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AlexaForBusinessResponse.BuilderImpl implements Builder {
        private List<BusinessReportSchedule> businessReportSchedules = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBusinessReportSchedulesResponse model) {
            super(model);
            businessReportSchedules(model.businessReportSchedules);
            nextToken(model.nextToken);
        }

        public final List<BusinessReportSchedule.Builder> getBusinessReportSchedules() {
            List<BusinessReportSchedule.Builder> result = BusinessReportScheduleListCopier
                    .copyToBuilder(this.businessReportSchedules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBusinessReportSchedules(Collection<BusinessReportSchedule.BuilderImpl> businessReportSchedules) {
            this.businessReportSchedules = BusinessReportScheduleListCopier.copyFromBuilder(businessReportSchedules);
        }

        @Override
        public final Builder businessReportSchedules(Collection<BusinessReportSchedule> businessReportSchedules) {
            this.businessReportSchedules = BusinessReportScheduleListCopier.copy(businessReportSchedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder businessReportSchedules(BusinessReportSchedule... businessReportSchedules) {
            businessReportSchedules(Arrays.asList(businessReportSchedules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder businessReportSchedules(Consumer<BusinessReportSchedule.Builder>... businessReportSchedules) {
            businessReportSchedules(Stream.of(businessReportSchedules)
                    .map(c -> BusinessReportSchedule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBusinessReportSchedulesResponse build() {
            return new ListBusinessReportSchedulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
