/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.acmpca.model.CertificateAuthorityConfiguration;
import software.amazon.awssdk.services.acmpca.model.CertificateAuthorityStatus;
import software.amazon.awssdk.services.acmpca.model.CertificateAuthorityType;
import software.amazon.awssdk.services.acmpca.model.CertificateAuthorityUsageMode;
import software.amazon.awssdk.services.acmpca.model.FailureReason;
import software.amazon.awssdk.services.acmpca.model.KeyStorageSecurityStandard;
import software.amazon.awssdk.services.acmpca.model.RevocationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CertificateAuthority
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CertificateAuthority> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(CertificateAuthority.getter(CertificateAuthority::arn)).setter(CertificateAuthority.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerAccount").getter(CertificateAuthority.getter(CertificateAuthority::ownerAccount)).setter(CertificateAuthority.setter(Builder::ownerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccount").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(CertificateAuthority.getter(CertificateAuthority::createdAt)).setter(CertificateAuthority.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> LAST_STATE_CHANGE_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastStateChangeAt").getter(CertificateAuthority.getter(CertificateAuthority::lastStateChangeAt)).setter(CertificateAuthority.setter(Builder::lastStateChangeAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastStateChangeAt").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CertificateAuthority.getter(CertificateAuthority::typeAsString)).setter(CertificateAuthority.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> SERIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Serial").getter(CertificateAuthority.getter(CertificateAuthority::serial)).setter(CertificateAuthority.setter(Builder::serial)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Serial").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CertificateAuthority.getter(CertificateAuthority::statusAsString)).setter(CertificateAuthority.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> NOT_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("NotBefore").getter(CertificateAuthority.getter(CertificateAuthority::notBefore)).setter(CertificateAuthority.setter(Builder::notBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotBefore").build()}).build();
    private static final SdkField<Instant> NOT_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("NotAfter").getter(CertificateAuthority.getter(CertificateAuthority::notAfter)).setter(CertificateAuthority.setter(Builder::notAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotAfter").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(CertificateAuthority.getter(CertificateAuthority::failureReasonAsString)).setter(CertificateAuthority.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<CertificateAuthorityConfiguration> CERTIFICATE_AUTHORITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CertificateAuthorityConfiguration").getter(CertificateAuthority.getter(CertificateAuthority::certificateAuthorityConfiguration)).setter(CertificateAuthority.setter(Builder::certificateAuthorityConfiguration)).constructor(CertificateAuthorityConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityConfiguration").build()}).build();
    private static final SdkField<RevocationConfiguration> REVOCATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RevocationConfiguration").getter(CertificateAuthority.getter(CertificateAuthority::revocationConfiguration)).setter(CertificateAuthority.setter(Builder::revocationConfiguration)).constructor(RevocationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevocationConfiguration").build()}).build();
    private static final SdkField<Instant> RESTORABLE_UNTIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RestorableUntil").getter(CertificateAuthority.getter(CertificateAuthority::restorableUntil)).setter(CertificateAuthority.setter(Builder::restorableUntil)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestorableUntil").build()}).build();
    private static final SdkField<String> KEY_STORAGE_SECURITY_STANDARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyStorageSecurityStandard").getter(CertificateAuthority.getter(CertificateAuthority::keyStorageSecurityStandardAsString)).setter(CertificateAuthority.setter(Builder::keyStorageSecurityStandard)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyStorageSecurityStandard").build()}).build();
    private static final SdkField<String> USAGE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UsageMode").getter(CertificateAuthority.getter(CertificateAuthority::usageModeAsString)).setter(CertificateAuthority.setter(Builder::usageMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, OWNER_ACCOUNT_FIELD, CREATED_AT_FIELD, LAST_STATE_CHANGE_AT_FIELD, TYPE_FIELD, SERIAL_FIELD, STATUS_FIELD, NOT_BEFORE_FIELD, NOT_AFTER_FIELD, FAILURE_REASON_FIELD, CERTIFICATE_AUTHORITY_CONFIGURATION_FIELD, REVOCATION_CONFIGURATION_FIELD, RESTORABLE_UNTIL_FIELD, KEY_STORAGE_SECURITY_STANDARD_FIELD, USAGE_MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String ownerAccount;
    private final Instant createdAt;
    private final Instant lastStateChangeAt;
    private final String type;
    private final String serial;
    private final String status;
    private final Instant notBefore;
    private final Instant notAfter;
    private final String failureReason;
    private final CertificateAuthorityConfiguration certificateAuthorityConfiguration;
    private final RevocationConfiguration revocationConfiguration;
    private final Instant restorableUntil;
    private final String keyStorageSecurityStandard;
    private final String usageMode;

    private CertificateAuthority(BuilderImpl builder) {
        this.arn = builder.arn;
        this.ownerAccount = builder.ownerAccount;
        this.createdAt = builder.createdAt;
        this.lastStateChangeAt = builder.lastStateChangeAt;
        this.type = builder.type;
        this.serial = builder.serial;
        this.status = builder.status;
        this.notBefore = builder.notBefore;
        this.notAfter = builder.notAfter;
        this.failureReason = builder.failureReason;
        this.certificateAuthorityConfiguration = builder.certificateAuthorityConfiguration;
        this.revocationConfiguration = builder.revocationConfiguration;
        this.restorableUntil = builder.restorableUntil;
        this.keyStorageSecurityStandard = builder.keyStorageSecurityStandard;
        this.usageMode = builder.usageMode;
    }

    public final String arn() {
        return this.arn;
    }

    public final String ownerAccount() {
        return this.ownerAccount;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastStateChangeAt() {
        return this.lastStateChangeAt;
    }

    public final CertificateAuthorityType type() {
        return CertificateAuthorityType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String serial() {
        return this.serial;
    }

    public final CertificateAuthorityStatus status() {
        return CertificateAuthorityStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant notBefore() {
        return this.notBefore;
    }

    public final Instant notAfter() {
        return this.notAfter;
    }

    public final FailureReason failureReason() {
        return FailureReason.fromValue(this.failureReason);
    }

    public final String failureReasonAsString() {
        return this.failureReason;
    }

    public final CertificateAuthorityConfiguration certificateAuthorityConfiguration() {
        return this.certificateAuthorityConfiguration;
    }

    public final RevocationConfiguration revocationConfiguration() {
        return this.revocationConfiguration;
    }

    public final Instant restorableUntil() {
        return this.restorableUntil;
    }

    public final KeyStorageSecurityStandard keyStorageSecurityStandard() {
        return KeyStorageSecurityStandard.fromValue(this.keyStorageSecurityStandard);
    }

    public final String keyStorageSecurityStandardAsString() {
        return this.keyStorageSecurityStandard;
    }

    public final CertificateAuthorityUsageMode usageMode() {
        return CertificateAuthorityUsageMode.fromValue(this.usageMode);
    }

    public final String usageModeAsString() {
        return this.usageMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStateChangeAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serial());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.notBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.notAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthorityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.revocationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.restorableUntil());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyStorageSecurityStandardAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateAuthority)) {
            return false;
        }
        CertificateAuthority other = (CertificateAuthority)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.ownerAccount(), other.ownerAccount()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastStateChangeAt(), other.lastStateChangeAt()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.serial(), other.serial()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.notBefore(), other.notBefore()) && Objects.equals(this.notAfter(), other.notAfter()) && Objects.equals(this.failureReasonAsString(), other.failureReasonAsString()) && Objects.equals(this.certificateAuthorityConfiguration(), other.certificateAuthorityConfiguration()) && Objects.equals(this.revocationConfiguration(), other.revocationConfiguration()) && Objects.equals(this.restorableUntil(), other.restorableUntil()) && Objects.equals(this.keyStorageSecurityStandardAsString(), other.keyStorageSecurityStandardAsString()) && Objects.equals(this.usageModeAsString(), other.usageModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CertificateAuthority").add("Arn", (Object)this.arn()).add("OwnerAccount", (Object)this.ownerAccount()).add("CreatedAt", (Object)this.createdAt()).add("LastStateChangeAt", (Object)this.lastStateChangeAt()).add("Type", (Object)this.typeAsString()).add("Serial", (Object)this.serial()).add("Status", (Object)this.statusAsString()).add("NotBefore", (Object)this.notBefore()).add("NotAfter", (Object)this.notAfter()).add("FailureReason", (Object)this.failureReasonAsString()).add("CertificateAuthorityConfiguration", (Object)this.certificateAuthorityConfiguration()).add("RevocationConfiguration", (Object)this.revocationConfiguration()).add("RestorableUntil", (Object)this.restorableUntil()).add("KeyStorageSecurityStandard", (Object)this.keyStorageSecurityStandardAsString()).add("UsageMode", (Object)this.usageModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "OwnerAccount": {
                return Optional.ofNullable(clazz.cast(this.ownerAccount()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "LastStateChangeAt": {
                return Optional.ofNullable(clazz.cast(this.lastStateChangeAt()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Serial": {
                return Optional.ofNullable(clazz.cast(this.serial()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "NotBefore": {
                return Optional.ofNullable(clazz.cast(this.notBefore()));
            }
            case "NotAfter": {
                return Optional.ofNullable(clazz.cast(this.notAfter()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReasonAsString()));
            }
            case "CertificateAuthorityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityConfiguration()));
            }
            case "RevocationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.revocationConfiguration()));
            }
            case "RestorableUntil": {
                return Optional.ofNullable(clazz.cast(this.restorableUntil()));
            }
            case "KeyStorageSecurityStandard": {
                return Optional.ofNullable(clazz.cast(this.keyStorageSecurityStandardAsString()));
            }
            case "UsageMode": {
                return Optional.ofNullable(clazz.cast(this.usageModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CertificateAuthority, T> g) {
        return obj -> g.apply((CertificateAuthority)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String ownerAccount;
        private Instant createdAt;
        private Instant lastStateChangeAt;
        private String type;
        private String serial;
        private String status;
        private Instant notBefore;
        private Instant notAfter;
        private String failureReason;
        private CertificateAuthorityConfiguration certificateAuthorityConfiguration;
        private RevocationConfiguration revocationConfiguration;
        private Instant restorableUntil;
        private String keyStorageSecurityStandard;
        private String usageMode;

        private BuilderImpl() {
        }

        private BuilderImpl(CertificateAuthority model) {
            this.arn(model.arn);
            this.ownerAccount(model.ownerAccount);
            this.createdAt(model.createdAt);
            this.lastStateChangeAt(model.lastStateChangeAt);
            this.type(model.type);
            this.serial(model.serial);
            this.status(model.status);
            this.notBefore(model.notBefore);
            this.notAfter(model.notAfter);
            this.failureReason(model.failureReason);
            this.certificateAuthorityConfiguration(model.certificateAuthorityConfiguration);
            this.revocationConfiguration(model.revocationConfiguration);
            this.restorableUntil(model.restorableUntil);
            this.keyStorageSecurityStandard(model.keyStorageSecurityStandard);
            this.usageMode(model.usageMode);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastStateChangeAt() {
            return this.lastStateChangeAt;
        }

        public final void setLastStateChangeAt(Instant lastStateChangeAt) {
            this.lastStateChangeAt = lastStateChangeAt;
        }

        @Override
        public final Builder lastStateChangeAt(Instant lastStateChangeAt) {
            this.lastStateChangeAt = lastStateChangeAt;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CertificateAuthorityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getSerial() {
            return this.serial;
        }

        public final void setSerial(String serial) {
            this.serial = serial;
        }

        @Override
        public final Builder serial(String serial) {
            this.serial = serial;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CertificateAuthorityStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getNotBefore() {
            return this.notBefore;
        }

        public final void setNotBefore(Instant notBefore) {
            this.notBefore = notBefore;
        }

        @Override
        public final Builder notBefore(Instant notBefore) {
            this.notBefore = notBefore;
            return this;
        }

        public final Instant getNotAfter() {
            return this.notAfter;
        }

        public final void setNotAfter(Instant notAfter) {
            this.notAfter = notAfter;
        }

        @Override
        public final Builder notAfter(Instant notAfter) {
            this.notAfter = notAfter;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public final Builder failureReason(FailureReason failureReason) {
            this.failureReason(failureReason == null ? null : failureReason.toString());
            return this;
        }

        public final CertificateAuthorityConfiguration.Builder getCertificateAuthorityConfiguration() {
            return this.certificateAuthorityConfiguration != null ? this.certificateAuthorityConfiguration.toBuilder() : null;
        }

        public final void setCertificateAuthorityConfiguration(CertificateAuthorityConfiguration.BuilderImpl certificateAuthorityConfiguration) {
            this.certificateAuthorityConfiguration = certificateAuthorityConfiguration != null ? certificateAuthorityConfiguration.build() : null;
        }

        @Override
        public final Builder certificateAuthorityConfiguration(CertificateAuthorityConfiguration certificateAuthorityConfiguration) {
            this.certificateAuthorityConfiguration = certificateAuthorityConfiguration;
            return this;
        }

        public final RevocationConfiguration.Builder getRevocationConfiguration() {
            return this.revocationConfiguration != null ? this.revocationConfiguration.toBuilder() : null;
        }

        public final void setRevocationConfiguration(RevocationConfiguration.BuilderImpl revocationConfiguration) {
            this.revocationConfiguration = revocationConfiguration != null ? revocationConfiguration.build() : null;
        }

        @Override
        public final Builder revocationConfiguration(RevocationConfiguration revocationConfiguration) {
            this.revocationConfiguration = revocationConfiguration;
            return this;
        }

        public final Instant getRestorableUntil() {
            return this.restorableUntil;
        }

        public final void setRestorableUntil(Instant restorableUntil) {
            this.restorableUntil = restorableUntil;
        }

        @Override
        public final Builder restorableUntil(Instant restorableUntil) {
            this.restorableUntil = restorableUntil;
            return this;
        }

        public final String getKeyStorageSecurityStandard() {
            return this.keyStorageSecurityStandard;
        }

        public final void setKeyStorageSecurityStandard(String keyStorageSecurityStandard) {
            this.keyStorageSecurityStandard = keyStorageSecurityStandard;
        }

        @Override
        public final Builder keyStorageSecurityStandard(String keyStorageSecurityStandard) {
            this.keyStorageSecurityStandard = keyStorageSecurityStandard;
            return this;
        }

        @Override
        public final Builder keyStorageSecurityStandard(KeyStorageSecurityStandard keyStorageSecurityStandard) {
            this.keyStorageSecurityStandard(keyStorageSecurityStandard == null ? null : keyStorageSecurityStandard.toString());
            return this;
        }

        public final String getUsageMode() {
            return this.usageMode;
        }

        public final void setUsageMode(String usageMode) {
            this.usageMode = usageMode;
        }

        @Override
        public final Builder usageMode(String usageMode) {
            this.usageMode = usageMode;
            return this;
        }

        @Override
        public final Builder usageMode(CertificateAuthorityUsageMode usageMode) {
            this.usageMode(usageMode == null ? null : usageMode.toString());
            return this;
        }

        public CertificateAuthority build() {
            return new CertificateAuthority(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CertificateAuthority> {
        public Builder arn(String var1);

        public Builder ownerAccount(String var1);

        public Builder createdAt(Instant var1);

        public Builder lastStateChangeAt(Instant var1);

        public Builder type(String var1);

        public Builder type(CertificateAuthorityType var1);

        public Builder serial(String var1);

        public Builder status(String var1);

        public Builder status(CertificateAuthorityStatus var1);

        public Builder notBefore(Instant var1);

        public Builder notAfter(Instant var1);

        public Builder failureReason(String var1);

        public Builder failureReason(FailureReason var1);

        public Builder certificateAuthorityConfiguration(CertificateAuthorityConfiguration var1);

        default public Builder certificateAuthorityConfiguration(Consumer<CertificateAuthorityConfiguration.Builder> certificateAuthorityConfiguration) {
            return this.certificateAuthorityConfiguration((CertificateAuthorityConfiguration)((CertificateAuthorityConfiguration.Builder)CertificateAuthorityConfiguration.builder().applyMutation(certificateAuthorityConfiguration)).build());
        }

        public Builder revocationConfiguration(RevocationConfiguration var1);

        default public Builder revocationConfiguration(Consumer<RevocationConfiguration.Builder> revocationConfiguration) {
            return this.revocationConfiguration((RevocationConfiguration)((RevocationConfiguration.Builder)RevocationConfiguration.builder().applyMutation(revocationConfiguration)).build());
        }

        public Builder restorableUntil(Instant var1);

        public Builder keyStorageSecurityStandard(String var1);

        public Builder keyStorageSecurityStandard(KeyStorageSecurityStandard var1);

        public Builder usageMode(String var1);

        public Builder usageMode(CertificateAuthorityUsageMode var1);
    }
}

