/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.account;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.account.AccountAsyncClient;
import software.amazon.awssdk.services.account.AccountAsyncClientBuilder;
import software.amazon.awssdk.services.account.AccountServiceClientConfiguration;
import software.amazon.awssdk.services.account.DefaultAccountAsyncClient;
import software.amazon.awssdk.services.account.DefaultAccountBaseClientBuilder;
import software.amazon.awssdk.services.account.endpoints.AccountEndpointProvider;

@SdkInternalApi
final class DefaultAccountAsyncClientBuilder
extends DefaultAccountBaseClientBuilder<AccountAsyncClientBuilder, AccountAsyncClient>
implements AccountAsyncClientBuilder {
    DefaultAccountAsyncClientBuilder() {
    }

    @Override
    public DefaultAccountAsyncClientBuilder endpointProvider(AccountEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AccountAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultAccountAsyncClientBuilder.validateClientOptions(clientConfiguration);
        AccountServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultAccountAsyncClient client = new DefaultAccountAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private AccountServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return AccountServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

