/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGeneratedPolicyRequest extends AccessAnalyzerRequest implements
        ToCopyableBuilder<GetGeneratedPolicyRequest.Builder, GetGeneratedPolicyRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(GetGeneratedPolicyRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()).build();

    private static final SdkField<Boolean> INCLUDE_RESOURCE_PLACEHOLDERS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeResourcePlaceholders")
            .getter(getter(GetGeneratedPolicyRequest::includeResourcePlaceholders))
            .setter(setter(Builder::includeResourcePlaceholders))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeResourcePlaceholders")
                    .build()).build();

    private static final SdkField<Boolean> INCLUDE_SERVICE_LEVEL_TEMPLATE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeServiceLevelTemplate")
            .getter(getter(GetGeneratedPolicyRequest::includeServiceLevelTemplate))
            .setter(setter(Builder::includeServiceLevelTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeServiceLevelTemplate")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            INCLUDE_RESOURCE_PLACEHOLDERS_FIELD, INCLUDE_SERVICE_LEVEL_TEMPLATE_FIELD));

    private final String jobId;

    private final Boolean includeResourcePlaceholders;

    private final Boolean includeServiceLevelTemplate;

    private GetGeneratedPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.includeResourcePlaceholders = builder.includeResourcePlaceholders;
        this.includeServiceLevelTemplate = builder.includeServiceLevelTemplate;
    }

    /**
     * <p>
     * The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The
     * <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or used
     * with <code>CancelPolicyGeneration</code> to cancel the policy generation request.
     * </p>
     * 
     * @return The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The
     *         <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or
     *         used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The level of detail that you want to generate. You can specify whether to generate policies with placeholders for
     * resource ARNs for actions that support resource level granularity in policies.
     * </p>
     * <p>
     * For example, in the resource section of a policy, you can receive a placeholder such as
     * <code>"Resource":"arn:aws:s3:::${BucketName}"</code> instead of <code>"*"</code>.
     * </p>
     * 
     * @return The level of detail that you want to generate. You can specify whether to generate policies with
     *         placeholders for resource ARNs for actions that support resource level granularity in policies.</p>
     *         <p>
     *         For example, in the resource section of a policy, you can receive a placeholder such as
     *         <code>"Resource":"arn:aws:s3:::${BucketName}"</code> instead of <code>"*"</code>.
     */
    public final Boolean includeResourcePlaceholders() {
        return includeResourcePlaceholders;
    }

    /**
     * <p>
     * The level of detail that you want to generate. You can specify whether to generate service-level policies.
     * </p>
     * <p>
     * IAM Access Analyzer uses <code>iam:servicelastaccessed</code> to identify services that have been used recently
     * to create this service-level template.
     * </p>
     * 
     * @return The level of detail that you want to generate. You can specify whether to generate service-level
     *         policies. </p>
     *         <p>
     *         IAM Access Analyzer uses <code>iam:servicelastaccessed</code> to identify services that have been used
     *         recently to create this service-level template.
     */
    public final Boolean includeServiceLevelTemplate() {
        return includeServiceLevelTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(includeResourcePlaceholders());
        hashCode = 31 * hashCode + Objects.hashCode(includeServiceLevelTemplate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGeneratedPolicyRequest)) {
            return false;
        }
        GetGeneratedPolicyRequest other = (GetGeneratedPolicyRequest) obj;
        return Objects.equals(jobId(), other.jobId())
                && Objects.equals(includeResourcePlaceholders(), other.includeResourcePlaceholders())
                && Objects.equals(includeServiceLevelTemplate(), other.includeServiceLevelTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetGeneratedPolicyRequest").add("JobId", jobId())
                .add("IncludeResourcePlaceholders", includeResourcePlaceholders())
                .add("IncludeServiceLevelTemplate", includeServiceLevelTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "includeResourcePlaceholders":
            return Optional.ofNullable(clazz.cast(includeResourcePlaceholders()));
        case "includeServiceLevelTemplate":
            return Optional.ofNullable(clazz.cast(includeServiceLevelTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGeneratedPolicyRequest, T> g) {
        return obj -> g.apply((GetGeneratedPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AccessAnalyzerRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetGeneratedPolicyRequest> {
        /**
         * <p>
         * The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The
         * <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies or
         * used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.
         * </p>
         * 
         * @param jobId
         *        The <code>JobId</code> that is returned by the <code>StartPolicyGeneration</code> operation. The
         *        <code>JobId</code> can be used with <code>GetGeneratedPolicy</code> to retrieve the generated policies
         *        or used with <code>CancelPolicyGeneration</code> to cancel the policy generation request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The level of detail that you want to generate. You can specify whether to generate policies with placeholders
         * for resource ARNs for actions that support resource level granularity in policies.
         * </p>
         * <p>
         * For example, in the resource section of a policy, you can receive a placeholder such as
         * <code>"Resource":"arn:aws:s3:::${BucketName}"</code> instead of <code>"*"</code>.
         * </p>
         * 
         * @param includeResourcePlaceholders
         *        The level of detail that you want to generate. You can specify whether to generate policies with
         *        placeholders for resource ARNs for actions that support resource level granularity in policies.</p>
         *        <p>
         *        For example, in the resource section of a policy, you can receive a placeholder such as
         *        <code>"Resource":"arn:aws:s3:::${BucketName}"</code> instead of <code>"*"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeResourcePlaceholders(Boolean includeResourcePlaceholders);

        /**
         * <p>
         * The level of detail that you want to generate. You can specify whether to generate service-level policies.
         * </p>
         * <p>
         * IAM Access Analyzer uses <code>iam:servicelastaccessed</code> to identify services that have been used
         * recently to create this service-level template.
         * </p>
         * 
         * @param includeServiceLevelTemplate
         *        The level of detail that you want to generate. You can specify whether to generate service-level
         *        policies. </p>
         *        <p>
         *        IAM Access Analyzer uses <code>iam:servicelastaccessed</code> to identify services that have been used
         *        recently to create this service-level template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeServiceLevelTemplate(Boolean includeServiceLevelTemplate);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AccessAnalyzerRequest.BuilderImpl implements Builder {
        private String jobId;

        private Boolean includeResourcePlaceholders;

        private Boolean includeServiceLevelTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGeneratedPolicyRequest model) {
            super(model);
            jobId(model.jobId);
            includeResourcePlaceholders(model.includeResourcePlaceholders);
            includeServiceLevelTemplate(model.includeServiceLevelTemplate);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final Boolean getIncludeResourcePlaceholders() {
            return includeResourcePlaceholders;
        }

        public final void setIncludeResourcePlaceholders(Boolean includeResourcePlaceholders) {
            this.includeResourcePlaceholders = includeResourcePlaceholders;
        }

        @Override
        public final Builder includeResourcePlaceholders(Boolean includeResourcePlaceholders) {
            this.includeResourcePlaceholders = includeResourcePlaceholders;
            return this;
        }

        public final Boolean getIncludeServiceLevelTemplate() {
            return includeServiceLevelTemplate;
        }

        public final void setIncludeServiceLevelTemplate(Boolean includeServiceLevelTemplate) {
            this.includeServiceLevelTemplate = includeServiceLevelTemplate;
        }

        @Override
        public final Builder includeServiceLevelTemplate(Boolean includeServiceLevelTemplate) {
            this.includeServiceLevelTemplate = includeServiceLevelTemplate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetGeneratedPolicyRequest build() {
            return new GetGeneratedPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
