/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.IResolvable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_stepfunctions.JsonPath")
public class JsonPath
extends JsiiObject {
    public static final String DISCARD = (String)JsiiObject.jsiiStaticGet(JsonPath.class, (String)"DISCARD", (NativeType)NativeType.forClass(String.class));

    protected JsonPath(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected JsonPath(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    @NotNull
    public static String array(String ... values) {
        return (String)JsiiObject.jsiiStaticCall(JsonPath.class, (String)"array", (NativeType)NativeType.forClass(String.class), (Object[])Arrays.stream(values).toArray(Object[]::new));
    }

    @NotNull
    public static String arrayContains(@NotNull Object array, @NotNull Object value) {
        return (String)JsiiObject.jsiiStaticCall(JsonPath.class, (String)"arrayContains", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{array, value});
    }

    @NotNull
    public static String arrayGetItem(@NotNull Object array, @NotNull Number index) {
        return (String)JsiiObject.jsiiStaticCall(JsonPath.class, (String)"arrayGetItem", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{array, Objects.requireNonNull(index, "index is required")});
    }

    @NotNull
    public static String arrayLength(@NotNull Object array) {
        return (String)JsiiObject.jsiiStaticCall(JsonPath.class, (String)"arrayLength", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{array});
    }

    @NotNull
    public static String arrayPartition(@NotNull Object array, @NotNull Number chunkSize) {
        return (String)JsiiObject.jsiiStaticCall(JsonPath.class, (String)"arrayPartition", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{array, Objects.requireNonNull(chunkSize, "chunkSize is required")});
    }

    @NotNull
    public static String arrayRange(@NotNull Number start, @NotNull Number end, @NotNull Number step) {
        return (String)JsiiObject.jsiiStaticCall(JsonPath.class, (String)"arrayRange", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(start, "start is required"), Objects.requireNonNull(end, "end is required"), Objects.requireNonNull(step, "step is required")});
    }

    @NotNull
    public static String arrayUnique(@NotNull Object array) {
        return (String)JsiiObject.jsiiStaticCall(JsonPath.class, (String)"arrayUnique", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{array});
    }

    @NotNull
    public static String base64Decode(@NotNull String base64) {
        return (String)JsiiObject.jsiiStaticCall(JsonPath.class, (String)"base64Decode", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(base64, "base64 is required")});
    }

    @NotNull
    public static String base64Encode(@NotNull String input) {
        return (String)JsiiObject.jsiiStaticCall(JsonPath.class, (String)"base64Encode", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(input, "input is required")});
    }

    @NotNull
    public static String format(@NotNull String formatString, String ... values) {
        return (String)JsiiObject.jsiiStaticCall(JsonPath.class, (String)"format", (NativeType)NativeType.forClass(String.class), (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(formatString, "formatString is required")}), Arrays.stream(values)).toArray(Object[]::new));
    }

    @NotNull
    public static String hash(@NotNull Object data, @NotNull String algorithm) {
        return (String)JsiiObject.jsiiStaticCall(JsonPath.class, (String)"hash", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{data, Objects.requireNonNull(algorithm, "algorithm is required")});
    }

    @NotNull
    public static Boolean isEncodedJsonPath(@NotNull String value) {
        return (Boolean)JsiiObject.jsiiStaticCall(JsonPath.class, (String)"isEncodedJsonPath", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{Objects.requireNonNull(value, "value is required")});
    }

    @NotNull
    public static String jsonMerge(@NotNull Object value1, @NotNull Object value2) {
        return (String)JsiiObject.jsiiStaticCall(JsonPath.class, (String)"jsonMerge", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{value1, value2});
    }

    @NotNull
    public static String jsonToString(@NotNull Object value) {
        return (String)JsiiObject.jsiiStaticCall(JsonPath.class, (String)"jsonToString", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{value});
    }

    @NotNull
    public static List<String> listAt(@NotNull String path) {
        return Collections.unmodifiableList((List)JsiiObject.jsiiStaticCall(JsonPath.class, (String)"listAt", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)), (Object[])new Object[]{Objects.requireNonNull(path, "path is required")}));
    }

    @NotNull
    public static String mathAdd(@NotNull Number num1, @NotNull Number num2) {
        return (String)JsiiObject.jsiiStaticCall(JsonPath.class, (String)"mathAdd", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(num1, "num1 is required"), Objects.requireNonNull(num2, "num2 is required")});
    }

    @NotNull
    public static String mathRandom(@NotNull Number start, @NotNull Number end) {
        return (String)JsiiObject.jsiiStaticCall(JsonPath.class, (String)"mathRandom", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(start, "start is required"), Objects.requireNonNull(end, "end is required")});
    }

    @NotNull
    public static Number numberAt(@NotNull String path) {
        return (Number)JsiiObject.jsiiStaticCall(JsonPath.class, (String)"numberAt", (NativeType)NativeType.forClass(Number.class), (Object[])new Object[]{Objects.requireNonNull(path, "path is required")});
    }

    @NotNull
    public static IResolvable objectAt(@NotNull String path) {
        return (IResolvable)JsiiObject.jsiiStaticCall(JsonPath.class, (String)"objectAt", (NativeType)NativeType.forClass(IResolvable.class), (Object[])new Object[]{Objects.requireNonNull(path, "path is required")});
    }

    @NotNull
    public static String stringAt(@NotNull String path) {
        return (String)JsiiObject.jsiiStaticCall(JsonPath.class, (String)"stringAt", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(path, "path is required")});
    }

    @NotNull
    public static String stringSplit(@NotNull String inputString, @NotNull String splitter) {
        return (String)JsiiObject.jsiiStaticCall(JsonPath.class, (String)"stringSplit", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{Objects.requireNonNull(inputString, "inputString is required"), Objects.requireNonNull(splitter, "splitter is required")});
    }

    @NotNull
    public static IResolvable stringToJson(@NotNull String jsonString) {
        return (IResolvable)JsiiObject.jsiiStaticCall(JsonPath.class, (String)"stringToJson", (NativeType)NativeType.forClass(IResolvable.class), (Object[])new Object[]{Objects.requireNonNull(jsonString, "jsonString is required")});
    }

    @NotNull
    public static String uuid() {
        return (String)JsiiObject.jsiiStaticCall(JsonPath.class, (String)"uuid", (NativeType)NativeType.forClass(String.class), (Object[])new Object[0]);
    }

    @NotNull
    public static String getEntireContext() {
        return (String)JsiiObject.jsiiStaticGet(JsonPath.class, (String)"entireContext", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public static String getEntirePayload() {
        return (String)JsiiObject.jsiiStaticGet(JsonPath.class, (String)"entirePayload", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public static String getExecutionId() {
        return (String)JsiiObject.jsiiStaticGet(JsonPath.class, (String)"executionId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public static String getExecutionInput() {
        return (String)JsiiObject.jsiiStaticGet(JsonPath.class, (String)"executionInput", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public static String getExecutionName() {
        return (String)JsiiObject.jsiiStaticGet(JsonPath.class, (String)"executionName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public static String getExecutionRoleArn() {
        return (String)JsiiObject.jsiiStaticGet(JsonPath.class, (String)"executionRoleArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public static String getExecutionStartTime() {
        return (String)JsiiObject.jsiiStaticGet(JsonPath.class, (String)"executionStartTime", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public static String getStateEnteredTime() {
        return (String)JsiiObject.jsiiStaticGet(JsonPath.class, (String)"stateEnteredTime", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public static String getStateMachineId() {
        return (String)JsiiObject.jsiiStaticGet(JsonPath.class, (String)"stateMachineId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public static String getStateMachineName() {
        return (String)JsiiObject.jsiiStaticGet(JsonPath.class, (String)"stateMachineName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public static String getStateName() {
        return (String)JsiiObject.jsiiStaticGet(JsonPath.class, (String)"stateName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public static String getStateRetryCount() {
        return (String)JsiiObject.jsiiStaticGet(JsonPath.class, (String)"stateRetryCount", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public static String getTaskToken() {
        return (String)JsiiObject.jsiiStaticGet(JsonPath.class, (String)"taskToken", (NativeType)NativeType.forClass(String.class));
    }
}

