/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sagemaker;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.sagemaker.CfnProject;
import software.amazon.awscdk.services.sagemaker.CfnProjectProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnProject")
public class CfnProject
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnProject.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnProject(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnProject(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnProject(@NotNull Construct scope, @NotNull String id, @NotNull CfnProjectProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrCreationTime() {
        return (String)Kernel.get((Object)this, (String)"attrCreationTime", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrProjectArn() {
        return (String)Kernel.get((Object)this, (String)"attrProjectArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrProjectId() {
        return (String)Kernel.get((Object)this, (String)"attrProjectId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrProjectStatus() {
        return (String)Kernel.get((Object)this, (String)"attrProjectStatus", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getProjectName() {
        return (String)Kernel.get((Object)this, (String)"projectName", (NativeType)NativeType.forClass(String.class));
    }

    public void setProjectName(@NotNull String value) {
        Kernel.set((Object)this, (String)"projectName", (Object)Objects.requireNonNull(value, "projectName is required"));
    }

    @NotNull
    public Object getServiceCatalogProvisioningDetails() {
        return Kernel.get((Object)this, (String)"serviceCatalogProvisioningDetails", (NativeType)NativeType.forClass(Object.class));
    }

    public void setServiceCatalogProvisioningDetails(@NotNull Object value) {
        Kernel.set((Object)this, (String)"serviceCatalogProvisioningDetails", (Object)Objects.requireNonNull(value, "serviceCatalogProvisioningDetails is required"));
    }

    @Nullable
    public String getProjectDescription() {
        return (String)Kernel.get((Object)this, (String)"projectDescription", (NativeType)NativeType.forClass(String.class));
    }

    public void setProjectDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"projectDescription", (Object)value);
    }

    @Nullable
    public Object getServiceCatalogProvisionedProductDetails() {
        return Kernel.get((Object)this, (String)"serviceCatalogProvisionedProductDetails", (NativeType)NativeType.forClass(Object.class));
    }

    public void setServiceCatalogProvisionedProductDetails(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"serviceCatalogProvisionedProductDetails", (Object)value);
    }

    public void setServiceCatalogProvisionedProductDetails(@Nullable ServiceCatalogProvisionedProductDetailsProperty value) {
        Kernel.set((Object)this, (String)"serviceCatalogProvisionedProductDetails", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTagsRaw() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tagsRaw", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTagsRaw(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tagsRaw", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnProject> {
        private final Construct scope;
        private final String id;
        private final CfnProjectProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnProjectProps.Builder();
        }

        public Builder projectName(String projectName) {
            this.props.projectName(projectName);
            return this;
        }

        public Builder serviceCatalogProvisioningDetails(Object serviceCatalogProvisioningDetails) {
            this.props.serviceCatalogProvisioningDetails(serviceCatalogProvisioningDetails);
            return this;
        }

        public Builder projectDescription(String projectDescription) {
            this.props.projectDescription(projectDescription);
            return this;
        }

        public Builder serviceCatalogProvisionedProductDetails(IResolvable serviceCatalogProvisionedProductDetails) {
            this.props.serviceCatalogProvisionedProductDetails(serviceCatalogProvisionedProductDetails);
            return this;
        }

        public Builder serviceCatalogProvisionedProductDetails(ServiceCatalogProvisionedProductDetailsProperty serviceCatalogProvisionedProductDetails) {
            this.props.serviceCatalogProvisionedProductDetails(serviceCatalogProvisionedProductDetails);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnProject build() {
            return new CfnProject(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnProject.ServiceCatalogProvisioningDetailsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServiceCatalogProvisioningDetailsProperty
    extends JsiiSerializable {
        @NotNull
        public String getProductId();

        @Nullable
        default public String getPathId() {
            return null;
        }

        @Nullable
        default public String getProvisioningArtifactId() {
            return null;
        }

        @Nullable
        default public Object getProvisioningParameters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServiceCatalogProvisioningDetailsProperty> {
            String productId;
            String pathId;
            String provisioningArtifactId;
            Object provisioningParameters;

            public Builder productId(String productId) {
                this.productId = productId;
                return this;
            }

            public Builder pathId(String pathId) {
                this.pathId = pathId;
                return this;
            }

            public Builder provisioningArtifactId(String provisioningArtifactId) {
                this.provisioningArtifactId = provisioningArtifactId;
                return this;
            }

            public Builder provisioningParameters(IResolvable provisioningParameters) {
                this.provisioningParameters = provisioningParameters;
                return this;
            }

            public Builder provisioningParameters(List<? extends Object> provisioningParameters) {
                this.provisioningParameters = provisioningParameters;
                return this;
            }

            public ServiceCatalogProvisioningDetailsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnProject.ServiceCatalogProvisionedProductDetailsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ServiceCatalogProvisionedProductDetailsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getProvisionedProductId() {
            return null;
        }

        @Nullable
        default public String getProvisionedProductStatusMessage() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ServiceCatalogProvisionedProductDetailsProperty> {
            String provisionedProductId;
            String provisionedProductStatusMessage;

            public Builder provisionedProductId(String provisionedProductId) {
                this.provisionedProductId = provisionedProductId;
                return this;
            }

            public Builder provisionedProductStatusMessage(String provisionedProductStatusMessage) {
                this.provisionedProductStatusMessage = provisionedProductStatusMessage;
                return this;
            }

            public ServiceCatalogProvisionedProductDetailsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnProject.ProvisioningParameterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ProvisioningParameterProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ProvisioningParameterProperty> {
            String key;
            String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public ProvisioningParameterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

