/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.rds;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.logs.RetentionDays;
import software.amazon.awscdk.services.rds.CaCertificate;
import software.amazon.awscdk.services.rds.CfnDBInstanceProps;
import software.amazon.awscdk.services.rds.DatabaseInstanceBase;
import software.amazon.awscdk.services.rds.DatabaseInstanceReadReplicaProps;
import software.amazon.awscdk.services.rds.Endpoint;
import software.amazon.awscdk.services.rds.IDatabaseInstance;
import software.amazon.awscdk.services.rds.IInstanceEngine;
import software.amazon.awscdk.services.rds.IOptionGroup;
import software.amazon.awscdk.services.rds.IParameterGroup;
import software.amazon.awscdk.services.rds.ISubnetGroup;
import software.amazon.awscdk.services.rds.NetworkType;
import software.amazon.awscdk.services.rds.PerformanceInsightRetention;
import software.amazon.awscdk.services.rds.ProcessorFeatures;
import software.amazon.awscdk.services.rds.StorageType;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_rds.DatabaseInstanceReadReplica")
public class DatabaseInstanceReadReplica
extends DatabaseInstanceBase
implements IDatabaseInstance {
    protected DatabaseInstanceReadReplica(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DatabaseInstanceReadReplica(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public DatabaseInstanceReadReplica(@NotNull Construct scope, @NotNull String id, @NotNull DatabaseInstanceReadReplicaProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    protected void setLogRetention() {
        Kernel.call((Object)this, (String)"setLogRetention", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)Kernel.get((Object)this, (String)"connections", (NativeType)NativeType.forClass(Connections.class));
    }

    @Override
    @NotNull
    public String getDbInstanceEndpointAddress() {
        return (String)Kernel.get((Object)this, (String)"dbInstanceEndpointAddress", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getDbInstanceEndpointPort() {
        return (String)Kernel.get((Object)this, (String)"dbInstanceEndpointPort", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public Endpoint getInstanceEndpoint() {
        return (Endpoint)((Object)Kernel.get((Object)this, (String)"instanceEndpoint", (NativeType)NativeType.forClass(Endpoint.class)));
    }

    @Override
    @NotNull
    public String getInstanceIdentifier() {
        return (String)Kernel.get((Object)this, (String)"instanceIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected InstanceType getInstanceType() {
        return (InstanceType)((Object)Kernel.get((Object)this, (String)"instanceType", (NativeType)NativeType.forClass(InstanceType.class)));
    }

    @NotNull
    protected CfnDBInstanceProps getNewCfnProps() {
        return (CfnDBInstanceProps)Kernel.get((Object)this, (String)"newCfnProps", (NativeType)NativeType.forClass(CfnDBInstanceProps.class));
    }

    @NotNull
    public IVpc getVpc() {
        return (IVpc)Kernel.get((Object)this, (String)"vpc", (NativeType)NativeType.forClass(IVpc.class));
    }

    @Override
    @Nullable
    public IInstanceEngine getEngine() {
        return (IInstanceEngine)Kernel.get((Object)this, (String)"engine", (NativeType)NativeType.forClass(IInstanceEngine.class));
    }

    @Override
    @Nullable
    public String getInstanceResourceId() {
        return (String)Kernel.get((Object)this, (String)"instanceResourceId", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    protected SubnetSelection getVpcPlacement() {
        return (SubnetSelection)Kernel.get((Object)this, (String)"vpcPlacement", (NativeType)NativeType.forClass(SubnetSelection.class));
    }

    @Override
    @Nullable
    protected Boolean getEnableIamAuthentication() {
        return (Boolean)Kernel.get((Object)this, (String)"enableIamAuthentication", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Override
    protected void setEnableIamAuthentication(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"enableIamAuthentication", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<DatabaseInstanceReadReplica> {
        private final Construct scope;
        private final String id;
        private final DatabaseInstanceReadReplicaProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new DatabaseInstanceReadReplicaProps.Builder();
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.props.autoMinorVersionUpgrade(autoMinorVersionUpgrade);
            return this;
        }

        public Builder availabilityZone(String availabilityZone) {
            this.props.availabilityZone(availabilityZone);
            return this;
        }

        public Builder backupRetention(Duration backupRetention) {
            this.props.backupRetention(backupRetention);
            return this;
        }

        public Builder caCertificate(CaCertificate caCertificate) {
            this.props.caCertificate(caCertificate);
            return this;
        }

        public Builder cloudwatchLogsExports(List<String> cloudwatchLogsExports) {
            this.props.cloudwatchLogsExports(cloudwatchLogsExports);
            return this;
        }

        public Builder cloudwatchLogsRetention(RetentionDays cloudwatchLogsRetention) {
            this.props.cloudwatchLogsRetention(cloudwatchLogsRetention);
            return this;
        }

        public Builder cloudwatchLogsRetentionRole(IRole cloudwatchLogsRetentionRole) {
            this.props.cloudwatchLogsRetentionRole(cloudwatchLogsRetentionRole);
            return this;
        }

        public Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.props.copyTagsToSnapshot(copyTagsToSnapshot);
            return this;
        }

        public Builder deleteAutomatedBackups(Boolean deleteAutomatedBackups) {
            this.props.deleteAutomatedBackups(deleteAutomatedBackups);
            return this;
        }

        public Builder deletionProtection(Boolean deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        public Builder domain(String domain) {
            this.props.domain(domain);
            return this;
        }

        public Builder domainRole(IRole domainRole) {
            this.props.domainRole(domainRole);
            return this;
        }

        public Builder enablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.props.enablePerformanceInsights(enablePerformanceInsights);
            return this;
        }

        public Builder iamAuthentication(Boolean iamAuthentication) {
            this.props.iamAuthentication(iamAuthentication);
            return this;
        }

        public Builder instanceIdentifier(String instanceIdentifier) {
            this.props.instanceIdentifier(instanceIdentifier);
            return this;
        }

        public Builder iops(Number iops) {
            this.props.iops(iops);
            return this;
        }

        public Builder maxAllocatedStorage(Number maxAllocatedStorage) {
            this.props.maxAllocatedStorage(maxAllocatedStorage);
            return this;
        }

        public Builder monitoringInterval(Duration monitoringInterval) {
            this.props.monitoringInterval(monitoringInterval);
            return this;
        }

        public Builder monitoringRole(IRole monitoringRole) {
            this.props.monitoringRole(monitoringRole);
            return this;
        }

        public Builder multiAz(Boolean multiAz) {
            this.props.multiAz(multiAz);
            return this;
        }

        public Builder networkType(NetworkType networkType) {
            this.props.networkType(networkType);
            return this;
        }

        public Builder optionGroup(IOptionGroup optionGroup) {
            this.props.optionGroup(optionGroup);
            return this;
        }

        public Builder parameterGroup(IParameterGroup parameterGroup) {
            this.props.parameterGroup(parameterGroup);
            return this;
        }

        public Builder performanceInsightEncryptionKey(IKey performanceInsightEncryptionKey) {
            this.props.performanceInsightEncryptionKey(performanceInsightEncryptionKey);
            return this;
        }

        public Builder performanceInsightRetention(PerformanceInsightRetention performanceInsightRetention) {
            this.props.performanceInsightRetention(performanceInsightRetention);
            return this;
        }

        public Builder port(Number port) {
            this.props.port(port);
            return this;
        }

        public Builder preferredBackupWindow(String preferredBackupWindow) {
            this.props.preferredBackupWindow(preferredBackupWindow);
            return this;
        }

        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.props.preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        public Builder processorFeatures(ProcessorFeatures processorFeatures) {
            this.props.processorFeatures(processorFeatures);
            return this;
        }

        public Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.props.publiclyAccessible(publiclyAccessible);
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        public Builder s3ExportBuckets(List<? extends IBucket> s3ExportBuckets) {
            this.props.s3ExportBuckets(s3ExportBuckets);
            return this;
        }

        public Builder s3ExportRole(IRole s3ExportRole) {
            this.props.s3ExportRole(s3ExportRole);
            return this;
        }

        public Builder s3ImportBuckets(List<? extends IBucket> s3ImportBuckets) {
            this.props.s3ImportBuckets(s3ImportBuckets);
            return this;
        }

        public Builder s3ImportRole(IRole s3ImportRole) {
            this.props.s3ImportRole(s3ImportRole);
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        public Builder storageThroughput(Number storageThroughput) {
            this.props.storageThroughput(storageThroughput);
            return this;
        }

        public Builder storageType(StorageType storageType) {
            this.props.storageType(storageType);
            return this;
        }

        public Builder subnetGroup(ISubnetGroup subnetGroup) {
            this.props.subnetGroup(subnetGroup);
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        public Builder instanceType(InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        public Builder sourceDatabaseInstance(IDatabaseInstance sourceDatabaseInstance) {
            this.props.sourceDatabaseInstance(sourceDatabaseInstance);
            return this;
        }

        public Builder storageEncrypted(Boolean storageEncrypted) {
            this.props.storageEncrypted(storageEncrypted);
            return this;
        }

        public Builder storageEncryptionKey(IKey storageEncryptionKey) {
            this.props.storageEncryptionKey(storageEncryptionKey);
            return this;
        }

        public DatabaseInstanceReadReplica build() {
            return new DatabaseInstanceReadReplica(this.scope, this.id, this.props.build());
        }
    }
}

