/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lambda.eventsources;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.lambda.IEventSource;
import software.amazon.awscdk.services.lambda.IFunction;
import software.amazon.awscdk.services.lambda.eventsources.SqsEventSourceProps;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_lambda_event_sources.SqsEventSource")
public class SqsEventSource
extends JsiiObject
implements IEventSource {
    protected SqsEventSource(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SqsEventSource(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public SqsEventSource(@NotNull IQueue queue, @Nullable SqsEventSourceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(queue, "queue is required"), props});
    }

    public SqsEventSource(@NotNull IQueue queue) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(queue, "queue is required")});
    }

    @Override
    public void bind(@NotNull IFunction target) {
        Kernel.call((Object)this, (String)"bind", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(target, "target is required")});
    }

    @NotNull
    public String getEventSourceMappingArn() {
        return (String)Kernel.get((Object)this, (String)"eventSourceMappingArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getEventSourceMappingId() {
        return (String)Kernel.get((Object)this, (String)"eventSourceMappingId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IQueue getQueue() {
        return (IQueue)Kernel.get((Object)this, (String)"queue", (NativeType)NativeType.forClass(IQueue.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<SqsEventSource> {
        private final IQueue queue;
        private SqsEventSourceProps.Builder props;

        public static Builder create(IQueue queue) {
            return new Builder(queue);
        }

        private Builder(IQueue queue) {
            this.queue = queue;
        }

        public Builder batchSize(Number batchSize) {
            this.props().batchSize(batchSize);
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.props().enabled(enabled);
            return this;
        }

        public Builder filters(List<? extends Map<String, ? extends Object>> filters) {
            this.props().filters(filters);
            return this;
        }

        public Builder maxBatchingWindow(Duration maxBatchingWindow) {
            this.props().maxBatchingWindow(maxBatchingWindow);
            return this;
        }

        public Builder maxConcurrency(Number maxConcurrency) {
            this.props().maxConcurrency(maxConcurrency);
            return this;
        }

        public Builder reportBatchItemFailures(Boolean reportBatchItemFailures) {
            this.props().reportBatchItemFailures(reportBatchItemFailures);
            return this;
        }

        public SqsEventSource build() {
            return new SqsEventSource(this.queue, this.props != null ? this.props.build() : null);
        }

        private SqsEventSourceProps.Builder props() {
            if (this.props == null) {
                this.props = new SqsEventSourceProps.Builder();
            }
            return this.props;
        }
    }
}

