/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.events.targets;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.events.IRule;
import software.amazon.awscdk.services.events.IRuleTarget;
import software.amazon.awscdk.services.events.RuleTargetConfig;
import software.amazon.awscdk.services.events.RuleTargetInput;
import software.amazon.awscdk.services.events.targets.SqsQueueProps;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_events_targets.SqsQueue")
public class SqsQueue
extends JsiiObject
implements IRuleTarget {
    protected SqsQueue(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SqsQueue(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public SqsQueue(@NotNull IQueue queue, @Nullable SqsQueueProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(queue, "queue is required"), props});
    }

    public SqsQueue(@NotNull IQueue queue) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(queue, "queue is required")});
    }

    @Override
    @NotNull
    public RuleTargetConfig bind(@NotNull IRule rule, @Nullable String _id) {
        return (RuleTargetConfig)Kernel.call((Object)this, (String)"bind", (NativeType)NativeType.forClass(RuleTargetConfig.class), (Object[])new Object[]{Objects.requireNonNull(rule, "rule is required"), _id});
    }

    @Override
    @NotNull
    public RuleTargetConfig bind(@NotNull IRule rule) {
        return (RuleTargetConfig)Kernel.call((Object)this, (String)"bind", (NativeType)NativeType.forClass(RuleTargetConfig.class), (Object[])new Object[]{Objects.requireNonNull(rule, "rule is required")});
    }

    @NotNull
    public IQueue getQueue() {
        return (IQueue)Kernel.get((Object)this, (String)"queue", (NativeType)NativeType.forClass(IQueue.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<SqsQueue> {
        private final IQueue queue;
        private SqsQueueProps.Builder props;

        public static Builder create(IQueue queue) {
            return new Builder(queue);
        }

        private Builder(IQueue queue) {
            this.queue = queue;
        }

        public Builder deadLetterQueue(IQueue deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }

        public Builder maxEventAge(Duration maxEventAge) {
            this.props().maxEventAge(maxEventAge);
            return this;
        }

        public Builder retryAttempts(Number retryAttempts) {
            this.props().retryAttempts(retryAttempts);
            return this;
        }

        public Builder message(RuleTargetInput message) {
            this.props().message(message);
            return this;
        }

        public Builder messageGroupId(String messageGroupId) {
            this.props().messageGroupId(messageGroupId);
            return this;
        }

        public SqsQueue build() {
            return new SqsQueue(this.queue, this.props != null ? this.props.build() : null);
        }

        private SqsQueueProps.Builder props() {
            if (this.props == null) {
                this.props = new SqsQueueProps.Builder();
            }
            return this.props;
        }
    }
}

